/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Objects;
import java.util.Set;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.SupportingMappingMethod;
import org.mapstruct.ap.internal.model.source.builtin.BuiltInFieldReference;

public class SupportingField
extends Field {
    private final String templateName;
    private final SupportingMappingMethod definingMethod;

    public SupportingField(SupportingMappingMethod definingMethod, BuiltInFieldReference fieldReference, String name) {
        super(fieldReference.getType(), name, true);
        this.templateName = this.getTemplateNameForClass(fieldReference.getClass());
        this.definingMethod = definingMethod;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    public SupportingMappingMethod getDefiningMethod() {
        return this.definingMethod;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.templateName == null ? 0 : this.templateName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupportingField other = (SupportingField)obj;
        return Objects.equals(this.templateName, other.templateName);
    }

    public static void addAllFieldsIn(Set<SupportingMappingMethod> supportingMappingMethods, Set<Field> targets) {
        for (SupportingMappingMethod supportingMappingMethod : supportingMappingMethods) {
            Field field = supportingMappingMethod.getSupportingField();
            if (field == null) continue;
            targets.add(supportingMappingMethod.getSupportingField());
        }
    }
}

