/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor.creation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.conversion.ConversionProvider;
import org.mapstruct.ap.internal.conversion.Conversions;
import org.mapstruct.ap.internal.gem.ReportingPolicyGem;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.ForgedMethodHistory;
import org.mapstruct.ap.internal.model.HelperMethod;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.SupportingField;
import org.mapstruct.ap.internal.model.SupportingMappingMethod;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.DefaultConversionContext;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.builtin.BuiltInMappingMethods;
import org.mapstruct.ap.internal.model.source.builtin.BuiltInMethod;
import org.mapstruct.ap.internal.model.source.selector.MethodSelectors;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.NativeTypes;
import org.mapstruct.ap.internal.util.Strings;

public class MappingResolverImpl
implements MappingBuilderContext.MappingResolver {
    private static final int LIMIT_REPORTING_AMBIGUOUS = 5;
    private final FormattingMessager messager;
    private final Types typeUtils;
    private final TypeFactory typeFactory;
    private final List<Method> sourceModel;
    private final List<MapperReference> mapperReferences;
    private final Conversions conversions;
    private final BuiltInMappingMethods builtInMethods;
    private final MethodSelectors methodSelectors;
    private final boolean verboseLogging;
    private static final String JL_OBJECT_NAME = Object.class.getName();
    private final Set<SupportingMappingMethod> usedSupportedMappings = new HashSet<SupportingMappingMethod>();

    public MappingResolverImpl(FormattingMessager messager, Elements elementUtils, Types typeUtils, TypeFactory typeFactory, List<Method> sourceModel, List<MapperReference> mapperReferences, boolean verboseLogging) {
        this.messager = messager;
        this.typeUtils = typeUtils;
        this.typeFactory = typeFactory;
        this.sourceModel = sourceModel;
        this.mapperReferences = mapperReferences;
        this.conversions = new Conversions(typeFactory);
        this.builtInMethods = new BuiltInMappingMethods(typeFactory);
        this.methodSelectors = new MethodSelectors(typeUtils, elementUtils, typeFactory, messager);
        this.verboseLogging = verboseLogging;
    }

    @Override
    public Assignment getTargetAssignment(Method mappingMethod, ForgedMethodHistory description, Type targetType, FormattingParameters formattingParameters, SelectionCriteria criteria, SourceRHS sourceRHS, AnnotationMirror positionHint, Supplier<Assignment> forger) {
        ResolvingAttempt attempt = new ResolvingAttempt(this.sourceModel, mappingMethod, description, formattingParameters, sourceRHS, criteria, positionHint, forger, this.builtInMethods.getBuiltInMethods(), this.messager, this.verboseLogging);
        return attempt.getTargetAssignment(sourceRHS.getSourceTypeForMatching(), targetType);
    }

    @Override
    public Set<SupportingMappingMethod> getUsedSupportedMappings() {
        return this.usedSupportedMappings;
    }

    private MapperReference findMapperReference(Method method) {
        for (MapperReference ref : this.mapperReferences) {
            if (!ref.getType().equals(method.getDeclaringMapper())) continue;
            ref.setUsed(ref.isUsed() || !method.isStatic());
            ref.setTypeRequiresImport(true);
            return ref;
        }
        return null;
    }

    private static class MethodConversion<T extends Method> {
        private final ResolvingAttempt attempt;
        private final List<T> methods;
        private final Function<SelectedMethod<T>, Assignment> create;
        private boolean hasResult = false;
        private Assignment result = null;

        static Assignment getBestMatch(ResolvingAttempt att, Type sourceType, Type targetType) {
            MethodConversion mAttempt = super.getBestMatch(sourceType, targetType);
            if (mAttempt.hasResult) {
                return mAttempt.result;
            }
            MethodConversion bAttempt = super.getBestMatch(sourceType, targetType);
            return bAttempt.result;
        }

        MethodConversion(ResolvingAttempt attempt, List<T> methods, Function<SelectedMethod<T>, Assignment> create) {
            this.attempt = attempt;
            this.methods = methods;
            this.create = create;
        }

        private MethodConversion<T> getBestMatch(Type sourceType, Type targetType) {
            ArrayList<Method> xCandidates = new ArrayList<Method>();
            LinkedHashMap<ConversionAssignment, List<SelectedMethod<T>>> yRefCandidates = new LinkedHashMap<ConversionAssignment, List<SelectedMethod<T>>>();
            for (Method xCandidate : this.methods) {
                ConversionAssignment yRefCandidate;
                Type xTargetType = xCandidate.getReturnType();
                Type xSourceType = xCandidate.getMappingSourceType();
                if ((xTargetType = xTargetType.resolveTypeVarToType(sourceType, xSourceType)) == null || xCandidate.isUpdateMethod() || !sourceType.isRawAssignableTo(xSourceType) || JL_OBJECT_NAME.equals(xTargetType.getFullyQualifiedName()) || (yRefCandidate = this.attempt.resolveViaConversion(xTargetType, targetType)) == null) continue;
                yRefCandidates.put(yRefCandidate, new ArrayList());
                xCandidates.add(xCandidate);
            }
            Iterator i = yRefCandidates.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ((List)entry.getValue()).addAll(this.attempt.getBestMatch(xCandidates, sourceType, ((ConversionAssignment)entry.getKey()).sourceType));
                if (!((List)entry.getValue()).isEmpty()) continue;
                i.remove();
            }
            if (yRefCandidates.isEmpty()) {
                return this;
            }
            this.hasResult = true;
            if (yRefCandidates.size() == 1 && ((List)Collections.firstValue(yRefCandidates)).size() == 1) {
                Assignment methodRefX = this.create.apply(Collections.first((Collection)Collections.firstValue(yRefCandidates)));
                ConversionAssignment conversionRefY = Collections.firstKey(yRefCandidates);
                conversionRefY.reportMessageWhenNarrowing(this.attempt.messager, this.attempt);
                methodRefX.setAssignment(this.attempt.sourceRHS);
                conversionRefY.assignment.setAssignment(methodRefX);
                this.result = conversionRefY.assignment;
            } else {
                this.reportAmbiguousError(yRefCandidates, targetType);
            }
            return this;
        }

        void reportAmbiguousError(Map<ConversionAssignment, List<SelectedMethod<T>>> yRefCandidates, Type target) {
            StringBuilder result = new StringBuilder();
            yRefCandidates.entrySet().stream().limit(this.attempt.reportingLimitAmbiguous).forEach(e -> result.append("conversionY: ").append(((ConversionAssignment)e.getKey()).shortName()).append(", method(s)X: ").append(this.attempt.join((List)e.getValue())).append("; "));
            this.attempt.messager.printMessage((Element)this.attempt.mappingMethod.getExecutable(), this.attempt.positionHint, Message.GENERAL_AMBIGUOUS_MAPPING_CONVERSIONY_METHODX, this.attempt.sourceRHS.getSourceType().getName() + " " + this.attempt.sourceRHS.getSourceParameterName(), target.getName(), result.toString());
        }
    }

    private static class ConversionMethod<T extends Method> {
        private final ResolvingAttempt attempt;
        private final List<T> methods;
        private final Function<SelectedMethod<T>, Assignment> create;
        private boolean hasResult = false;
        private Assignment result = null;

        static Assignment getBestMatch(ResolvingAttempt att, Type sourceType, Type targetType) {
            ConversionMethod mAttempt = super.getBestMatch(sourceType, targetType);
            if (mAttempt.hasResult) {
                return mAttempt.result;
            }
            ConversionMethod bAttempt = super.getBestMatch(sourceType, targetType);
            return bAttempt.result;
        }

        ConversionMethod(ResolvingAttempt attempt, List<T> methods, Function<SelectedMethod<T>, Assignment> create) {
            this.attempt = attempt;
            this.methods = methods;
            this.create = create;
        }

        private ConversionMethod<T> getBestMatch(Type sourceType, Type targetType) {
            ArrayList<Method> yCandidates = new ArrayList<Method>();
            LinkedHashMap<ConversionAssignment, List<SelectedMethod<T>>> xRefCandidates = new LinkedHashMap<ConversionAssignment, List<SelectedMethod<T>>>();
            for (Method yCandidate : this.methods) {
                ConversionAssignment xRefCandidate;
                Type ySourceType = yCandidate.getMappingSourceType();
                ySourceType = ySourceType.resolveTypeVarToType(targetType, yCandidate.getResultType());
                Type yTargetType = yCandidate.getResultType();
                if (ySourceType == null || !yTargetType.isRawAssignableTo(targetType) || JL_OBJECT_NAME.equals(ySourceType.getFullyQualifiedName()) || (xRefCandidate = this.attempt.resolveViaConversion(sourceType, ySourceType)) == null) continue;
                xRefCandidates.put(xRefCandidate, new ArrayList());
                yCandidates.add(yCandidate);
            }
            Iterator i = xRefCandidates.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ((List)entry.getValue()).addAll(this.attempt.getBestMatch(yCandidates, ((ConversionAssignment)entry.getKey()).targetType, targetType));
                if (!((List)entry.getValue()).isEmpty()) continue;
                i.remove();
            }
            if (xRefCandidates.isEmpty()) {
                return this;
            }
            this.hasResult = true;
            if (xRefCandidates.size() == 1 && ((List)Collections.firstValue(xRefCandidates)).size() == 1) {
                Assignment methodRefY = this.create.apply(Collections.first((Collection)Collections.firstValue(xRefCandidates)));
                ConversionAssignment conversionRefX = Collections.firstKey(xRefCandidates);
                conversionRefX.reportMessageWhenNarrowing(this.attempt.messager, this.attempt);
                methodRefY.setAssignment(conversionRefX.assignment);
                conversionRefX.assignment.setAssignment(this.attempt.sourceRHS);
                this.result = methodRefY;
            } else {
                this.reportAmbiguousError(xRefCandidates, targetType);
            }
            return this;
        }

        void reportAmbiguousError(Map<ConversionAssignment, List<SelectedMethod<T>>> xRefCandidates, Type target) {
            StringBuilder result = new StringBuilder();
            xRefCandidates.entrySet().stream().limit(this.attempt.reportingLimitAmbiguous).forEach(e -> result.append("method(s)Y: ").append(this.attempt.join((List)e.getValue())).append(", conversionX: ").append(((ConversionAssignment)e.getKey()).shortName()).append("; "));
            this.attempt.messager.printMessage((Element)this.attempt.mappingMethod.getExecutable(), this.attempt.positionHint, Message.GENERAL_AMBIGUOUS_MAPPING_METHODY_CONVERSIONX, this.attempt.sourceRHS.getSourceType().getName() + " " + this.attempt.sourceRHS.getSourceParameterName(), target.getName(), result.toString());
        }
    }

    private static class MethodMethod<T1 extends Method, T2 extends Method> {
        private final ResolvingAttempt attempt;
        private final List<T1> xMethods;
        private final List<T2> yMethods;
        private final Function<SelectedMethod<T1>, Assignment> xCreate;
        private final Function<SelectedMethod<T2>, Assignment> yCreate;
        private boolean hasResult = false;
        private Assignment result = null;

        static Assignment getBestMatch(ResolvingAttempt att, Type sourceType, Type targetType) {
            MethodMethod mmAttempt = super.getBestMatch(sourceType, targetType);
            if (mmAttempt.hasResult) {
                return mmAttempt.result;
            }
            MethodMethod mbAttempt = super.getBestMatch(sourceType, targetType);
            if (mbAttempt.hasResult) {
                return mbAttempt.result;
            }
            MethodMethod bmAttempt = super.getBestMatch(sourceType, targetType);
            if (bmAttempt.hasResult) {
                return bmAttempt.result;
            }
            MethodMethod bbAttempt = super.getBestMatch(sourceType, targetType);
            return bbAttempt.result;
        }

        MethodMethod(ResolvingAttempt attempt, List<T1> xMethods, List<T2> yMethods, Function<SelectedMethod<T1>, Assignment> xCreate, Function<SelectedMethod<T2>, Assignment> yCreate) {
            this.attempt = attempt;
            this.xMethods = xMethods;
            this.yMethods = yMethods;
            this.xCreate = xCreate;
            this.yCreate = yCreate;
        }

        private MethodMethod<T1, T2> getBestMatch(Type sourceType, Type targetType) {
            HashSet<Method> yCandidates = new HashSet<Method>();
            LinkedHashMap xCandidates = new LinkedHashMap();
            LinkedHashMap typesInTheMiddle = new LinkedHashMap();
            this.attempt.selectionCriteria.setPreferUpdateMapping(false);
            for (Method yCandidate : this.yMethods) {
                List xMatches;
                Type ySourceType = yCandidate.getMappingSourceType();
                ySourceType = ySourceType.resolveTypeVarToType(targetType, yCandidate.getResultType());
                Type yTargetType = yCandidate.getResultType();
                if (ySourceType == null || !yTargetType.isRawAssignableTo(targetType) || JL_OBJECT_NAME.equals(ySourceType.getFullyQualifiedName()) || (xMatches = this.attempt.getBestMatch(this.xMethods, sourceType, ySourceType)).isEmpty()) continue;
                xMatches.stream().forEach(x -> {
                    List cfr_ignored_0 = xCandidates.put((SelectedMethod)x, new ArrayList());
                });
                Type typeInTheMiddle = ySourceType;
                xMatches.stream().forEach(x -> typesInTheMiddle.put(x, typeInTheMiddle));
                yCandidates.add(yCandidate);
            }
            this.attempt.selectionCriteria.setPreferUpdateMapping(true);
            ArrayList yCandidatesList = new ArrayList(yCandidates);
            Iterator i = xCandidates.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Type typeInTheMiddle = (Type)typesInTheMiddle.get(entry.getKey());
                ((List)entry.getValue()).addAll(this.attempt.getBestMatch(yCandidatesList, typeInTheMiddle, targetType));
                if (!((List)entry.getValue()).isEmpty()) continue;
                i.remove();
            }
            if (xCandidates.isEmpty()) {
                return this;
            }
            this.hasResult = true;
            if (xCandidates.size() == 1 && ((List)Collections.firstValue(xCandidates)).size() == 1) {
                Assignment methodRefY = this.yCreate.apply((SelectedMethod<T2>)Collections.first((Collection)Collections.firstValue(xCandidates)));
                Assignment methodRefX = this.xCreate.apply(Collections.firstKey(xCandidates));
                methodRefY.setAssignment(methodRefX);
                methodRefX.setAssignment(this.attempt.sourceRHS);
                this.result = methodRefY;
            } else {
                this.reportAmbiguousError(xCandidates, targetType);
            }
            return this;
        }

        void reportAmbiguousError(Map<SelectedMethod<T1>, List<SelectedMethod<T2>>> xCandidates, Type target) {
            StringBuilder result = new StringBuilder();
            xCandidates.entrySet().stream().limit(this.attempt.reportingLimitAmbiguous).forEach(e -> result.append("method(s)Y: ").append(this.attempt.join((List)e.getValue())).append(", methodX: ").append(((SelectedMethod)e.getKey()).getMethod().describe()).append("; "));
            this.attempt.messager.printMessage((Element)this.attempt.mappingMethod.getExecutable(), this.attempt.positionHint, Message.GENERAL_AMBIGUOUS_MAPPING_METHODY_METHODX, this.attempt.sourceRHS.getSourceType().getName() + " " + this.attempt.sourceRHS.getSourceParameterName(), target.getName(), result.toString());
        }
    }

    private static class ConversionAssignment {
        private final Type sourceType;
        private final Type targetType;
        private final Assignment assignment;

        ConversionAssignment(Type sourceType, Type targetType, Assignment assignment) {
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.assignment = assignment;
        }

        Assignment getAssignment() {
            return this.assignment;
        }

        void reportMessageWhenNarrowing(FormattingMessager messager, ResolvingAttempt attempt) {
            if (NativeTypes.isNarrowing(this.sourceType.getFullyQualifiedName(), this.targetType.getFullyQualifiedName())) {
                ReportingPolicyGem policy = attempt.mappingMethod.getOptions().getMapper().typeConversionPolicy();
                if (policy == ReportingPolicyGem.WARN) {
                    this.report(messager, attempt, Message.CONVERSION_LOSSY_WARNING);
                } else if (policy == ReportingPolicyGem.ERROR) {
                    this.report(messager, attempt, Message.CONVERSION_LOSSY_ERROR);
                }
            }
        }

        private void report(FormattingMessager messager, ResolvingAttempt attempt, Message message) {
            messager.printMessage((Element)attempt.mappingMethod.getExecutable(), attempt.positionHint, message, attempt.sourceRHS.getSourceErrorMessagePart(), this.sourceType.describe(), this.targetType.describe());
        }

        String shortName() {
            return this.sourceType.getName() + "-->" + this.targetType.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConversionAssignment that = (ConversionAssignment)o;
            return this.sourceType.equals(that.sourceType) && this.targetType.equals(that.targetType);
        }

        public int hashCode() {
            return Objects.hash(this.sourceType, this.targetType);
        }
    }

    private class ResolvingAttempt {
        private final Method mappingMethod;
        private final ForgedMethodHistory description;
        private final List<Method> methods;
        private final SelectionCriteria selectionCriteria;
        private final SourceRHS sourceRHS;
        private final FormattingParameters formattingParameters;
        private final AnnotationMirror positionHint;
        private final Supplier<Assignment> forger;
        private final List<BuiltInMethod> builtIns;
        private final FormattingMessager messager;
        private final int reportingLimitAmbiguous;
        private final Set<SupportingMappingMethod> supportingMethodCandidates;

        private ResolvingAttempt(List<Method> sourceModel, Method mappingMethod, ForgedMethodHistory description, FormattingParameters formattingParameters, SourceRHS sourceRHS, SelectionCriteria criteria, AnnotationMirror positionHint, Supplier<Assignment> forger, List<BuiltInMethod> builtIns, FormattingMessager messager, boolean verboseLogging) {
            this.mappingMethod = mappingMethod;
            this.description = description;
            this.methods = this.filterPossibleCandidateMethods(sourceModel);
            this.formattingParameters = formattingParameters == null ? FormattingParameters.EMPTY : formattingParameters;
            this.sourceRHS = sourceRHS;
            this.supportingMethodCandidates = new HashSet<SupportingMappingMethod>();
            this.selectionCriteria = criteria;
            this.positionHint = positionHint;
            this.forger = forger;
            this.builtIns = builtIns;
            this.messager = messager;
            this.reportingLimitAmbiguous = verboseLogging ? Integer.MAX_VALUE : 5;
        }

        private <T extends Method> List<T> filterPossibleCandidateMethods(List<T> candidateMethods) {
            ArrayList<Method> result = new ArrayList<Method>(candidateMethods.size());
            for (Method candidate : candidateMethods) {
                if (!this.isCandidateForMapping(candidate)) continue;
                result.add(candidate);
            }
            return result;
        }

        private Assignment getTargetAssignment(Type sourceType, Type targetType) {
            List<SelectedMethod<Object>> matches;
            if (this.allowMappingMethod()) {
                matches = this.getBestMatch(this.methods, sourceType, targetType);
                this.reportErrorWhenAmbiguous(matches, targetType);
                if (!matches.isEmpty()) {
                    Assignment assignment = this.toMethodRef(Collections.first(matches));
                    assignment.setAssignment(this.sourceRHS);
                    return assignment;
                }
            }
            if (!this.hasQualfiers() && (sourceType.isAssignableTo(targetType) || this.isAssignableThroughCollectionCopyConstructor(sourceType, targetType)) && this.allowDirect(sourceType, targetType)) {
                SourceRHS simpleAssignment = this.sourceRHS;
                return simpleAssignment;
            }
            if (sourceType.isLiteral() && "java.lang.String".equals(sourceType.getFullyQualifiedName()) && targetType.isNative()) {
                return null;
            }
            if (this.allowConversion()) {
                ConversionAssignment conversion;
                if (!this.hasQualfiers() && (conversion = this.resolveViaConversion(sourceType, targetType)) != null) {
                    conversion.reportMessageWhenNarrowing(this.messager, this);
                    conversion.getAssignment().setAssignment(this.sourceRHS);
                    return conversion.getAssignment();
                }
                if (!this.hasQualfiers()) {
                    matches = this.getBestMatch(this.builtIns, sourceType, targetType);
                    this.reportErrorWhenAmbiguous(matches, targetType);
                    if (!matches.isEmpty()) {
                        Assignment assignment = this.toBuildInRef(Collections.first(matches));
                        assignment.setAssignment(this.sourceRHS);
                        MappingResolverImpl.this.usedSupportedMappings.addAll(this.supportingMethodCandidates);
                        return assignment;
                    }
                }
            }
            if (this.allow2Steps()) {
                Assignment assignment = MethodMethod.getBestMatch(this, sourceType, targetType);
                if (assignment != null) {
                    MappingResolverImpl.this.usedSupportedMappings.addAll(this.supportingMethodCandidates);
                    return assignment;
                }
                assignment = ConversionMethod.getBestMatch(this, sourceType, targetType);
                if (assignment != null) {
                    MappingResolverImpl.this.usedSupportedMappings.addAll(this.supportingMethodCandidates);
                    return assignment;
                }
                this.selectionCriteria.setPreferUpdateMapping(false);
                assignment = MethodConversion.getBestMatch(this, sourceType, targetType);
                if (assignment != null) {
                    MappingResolverImpl.this.usedSupportedMappings.addAll(this.supportingMethodCandidates);
                    return assignment;
                }
            }
            if (this.hasQualfiers()) {
                this.printQualifierMessage(this.selectionCriteria);
            } else if (this.allowMappingMethod()) {
                return this.forger.get();
            }
            return null;
        }

        private boolean hasQualfiers() {
            return this.selectionCriteria != null && this.selectionCriteria.hasQualfiers();
        }

        private void printQualifierMessage(SelectionCriteria selectionCriteria) {
            List annotations = selectionCriteria.getQualifiers().stream().filter(DeclaredType.class::isInstance).map(DeclaredType.class::cast).map(DeclaredType::asElement).map(Element::getSimpleName).map(Object::toString).map(a -> "@" + a).collect(Collectors.toList());
            List<String> names = selectionCriteria.getQualifiedByNames();
            if (!annotations.isEmpty() && !names.isEmpty()) {
                this.messager.printMessage((Element)this.mappingMethod.getExecutable(), this.positionHint, Message.GENERAL_NO_QUALIFYING_METHOD_COMBINED, Strings.join(names, " and "), Strings.join(annotations, " and "));
            } else if (!annotations.isEmpty()) {
                this.messager.printMessage((Element)this.mappingMethod.getExecutable(), this.positionHint, Message.GENERAL_NO_QUALIFYING_METHOD_ANNOTATION, Strings.join(annotations, " and "));
            } else {
                this.messager.printMessage((Element)this.mappingMethod.getExecutable(), this.positionHint, Message.GENERAL_NO_QUALIFYING_METHOD_NAMED, Strings.join(names, " and "));
            }
        }

        private boolean allowDirect(Type sourceType, Type targetType) {
            if (this.selectionCriteria != null && this.selectionCriteria.isAllowDirect()) {
                return true;
            }
            return this.allowDirect(sourceType) || this.allowDirect(targetType);
        }

        private boolean allowDirect(Type type) {
            if (type.isPrimitive()) {
                return true;
            }
            if (type.isArrayType()) {
                return type.isJavaLangType() || type.getComponentType().isPrimitive();
            }
            if (type.isIterableOrStreamType()) {
                List<Type> typeParameters = type.getTypeParameters();
                return typeParameters.isEmpty() || this.allowDirect(Collections.first(typeParameters));
            }
            if (type.isMapType()) {
                List<Type> typeParameters = type.getTypeParameters();
                return typeParameters.isEmpty() || this.allowDirect(typeParameters.get(0)) && this.allowDirect(typeParameters.get(1));
            }
            return type.isJavaLangType();
        }

        private boolean allowConversion() {
            return this.selectionCriteria != null && this.selectionCriteria.isAllowConversion();
        }

        private boolean allowMappingMethod() {
            return this.selectionCriteria != null && this.selectionCriteria.isAllowMappingMethod();
        }

        private boolean allow2Steps() {
            return this.selectionCriteria != null && this.selectionCriteria.isAllow2Steps();
        }

        private ConversionAssignment resolveViaConversion(Type sourceType, Type targetType) {
            ConversionProvider conversionProvider = MappingResolverImpl.this.conversions.getConversion(sourceType, targetType);
            if (conversionProvider == null) {
                return null;
            }
            DefaultConversionContext ctx = new DefaultConversionContext(MappingResolverImpl.this.typeFactory, this.messager, sourceType, targetType, this.formattingParameters);
            for (HelperMethod helperMethod : conversionProvider.getRequiredHelperMethods(ctx)) {
                MappingResolverImpl.this.usedSupportedMappings.add(new SupportingMappingMethod(helperMethod));
            }
            Assignment conversion = conversionProvider.to(ctx);
            if (conversion != null) {
                return new ConversionAssignment(sourceType, targetType, conversionProvider.to(ctx));
            }
            return null;
        }

        private boolean isCandidateForMapping(Method methodCandidate) {
            return this.isCreateMethodForMapping(methodCandidate) || this.isUpdateMethodForMapping(methodCandidate);
        }

        private boolean isCreateMethodForMapping(Method methodCandidate) {
            return methodCandidate.getSourceParameters().size() == 1 && !methodCandidate.getReturnType().isVoid() && methodCandidate.getMappingTargetParameter() == null && !methodCandidate.isLifecycleCallbackMethod();
        }

        private boolean isUpdateMethodForMapping(Method methodCandidate) {
            return methodCandidate.getSourceParameters().size() == 1 && methodCandidate.getMappingTargetParameter() != null && !methodCandidate.isLifecycleCallbackMethod();
        }

        private <T extends Method> List<SelectedMethod<T>> getBestMatch(List<T> methods, Type source, Type target) {
            return MappingResolverImpl.this.methodSelectors.getMatchingMethods(this.mappingMethod, methods, java.util.Collections.singletonList(source), target, this.selectionCriteria);
        }

        private <T extends Method> void reportErrorWhenAmbiguous(List<SelectedMethod<T>> candidates, Type target) {
            if (candidates.size() > 1) {
                String descriptionStr = "";
                descriptionStr = this.description != null ? this.description.createSourcePropertyErrorMessage() : this.sourceRHS.getSourceErrorMessagePart();
                if (this.sourceRHS.getSourceErrorMessagePart() != null) {
                    this.messager.printMessage((Element)this.mappingMethod.getExecutable(), this.positionHint, Message.GENERAL_AMBIGUOUS_MAPPING_METHOD, descriptionStr, target.describe(), this.join(candidates));
                } else {
                    this.messager.printMessage((Element)this.mappingMethod.getExecutable(), this.positionHint, Message.GENERAL_AMBIGUOUS_FACTORY_METHOD, target.describe(), this.join(candidates));
                }
            }
        }

        private Assignment toMethodRef(SelectedMethod<Method> selectedMethod) {
            MapperReference mapperReference = MappingResolverImpl.this.findMapperReference(selectedMethod.getMethod());
            return MethodReference.forMapperReference(selectedMethod.getMethod(), mapperReference, selectedMethod.getParameterBindings());
        }

        private Assignment toBuildInRef(SelectedMethod<BuiltInMethod> selectedMethod) {
            BuiltInMethod method = selectedMethod.getMethod();
            HashSet<Field> allUsedFields = new HashSet<Field>(MappingResolverImpl.this.mapperReferences);
            SupportingField.addAllFieldsIn(this.supportingMethodCandidates, allUsedFields);
            SupportingMappingMethod supportingMappingMethod = new SupportingMappingMethod(method, allUsedFields);
            this.supportingMethodCandidates.add(supportingMappingMethod);
            DefaultConversionContext ctx = new DefaultConversionContext(MappingResolverImpl.this.typeFactory, this.messager, method.getMappingSourceType(), method.getResultType(), this.formattingParameters);
            MethodReference methodReference = MethodReference.forBuiltInMethod(method, ctx);
            methodReference.setAssignment(this.sourceRHS);
            return methodReference;
        }

        private boolean isAssignableThroughCollectionCopyConstructor(Type sourceType, Type targetType) {
            boolean bothCollectionOrMap = false;
            if (sourceType.isCollectionType() && targetType.isCollectionType() || sourceType.isMapType() && targetType.isMapType()) {
                bothCollectionOrMap = true;
            }
            if (bothCollectionOrMap) {
                return this.hasCompatibleCopyConstructor(sourceType, targetType.getImplementationType() != null ? targetType.getImplementationType() : targetType);
            }
            return false;
        }

        private boolean hasCompatibleCopyConstructor(Type sourceType, Type targetType) {
            if (targetType.isPrimitive()) {
                return false;
            }
            List<ExecutableElement> targetTypeConstructors = ElementFilter.constructorsIn(targetType.getTypeElement().getEnclosedElements());
            for (ExecutableElement constructor : targetTypeConstructors) {
                if (constructor.getParameters().size() != 1) continue;
                ExecutableType typedConstructor = (ExecutableType)MappingResolverImpl.this.typeUtils.asMemberOf((DeclaredType)targetType.getTypeMirror(), constructor);
                TypeMirror parameterType = Collections.first(typedConstructor.getParameterTypes());
                if (parameterType.getKind() == TypeKind.DECLARED) {
                    DeclaredType p = (DeclaredType)parameterType;
                    ArrayList<TypeMirror> typeArguments = new ArrayList<TypeMirror>(p.getTypeArguments().size());
                    for (TypeMirror typeMirror : p.getTypeArguments()) {
                        typeArguments.add(MappingResolverImpl.this.typeFactory.getTypeBound(typeMirror));
                    }
                    parameterType = MappingResolverImpl.this.typeUtils.getDeclaredType((TypeElement)p.asElement(), typeArguments.toArray(new TypeMirror[typeArguments.size()]));
                }
                if (!MappingResolverImpl.this.typeUtils.isAssignable(sourceType.getTypeMirror(), parameterType)) continue;
                return true;
            }
            return false;
        }

        private <T extends Method> String join(List<SelectedMethod<T>> candidates) {
            String candidateStr = candidates.stream().limit(this.reportingLimitAmbiguous).map(m -> m.getMethod().describe()).collect(Collectors.joining(", "));
            if (candidates.size() > this.reportingLimitAmbiguous) {
                candidateStr = candidateStr + String.format("... and %s more", candidates.size() - this.reportingLimitAmbiguous);
            }
            return candidateStr;
        }
    }
}

