/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.mapstruct.ap.internal.gem.MappingGem;
import org.mapstruct.ap.internal.gem.MappingsGem;
import org.mapstruct.ap.internal.gem.NullValueCheckStrategyGem;
import org.mapstruct.ap.internal.gem.NullValuePropertyMappingStrategyGem;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.source.BeanMappingOptions;
import org.mapstruct.ap.internal.model.source.DelegatingOptions;
import org.mapstruct.ap.internal.model.source.MappingControl;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.util.ElementUtils;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.TypeUtils;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.GemValue;

public class MappingOptions
extends DelegatingOptions {
    private static final Pattern JAVA_EXPRESSION = Pattern.compile("^java\\((.*)\\)$");
    private final String sourceName;
    private final String constant;
    private final String javaExpression;
    private final String defaultJavaExpression;
    private final String conditionJavaExpression;
    private final String targetName;
    private final String defaultValue;
    private final FormattingParameters formattingParameters;
    private final SelectionParameters selectionParameters;
    private final boolean isIgnored;
    private final Set<String> dependsOn;
    private final Element element;
    private final AnnotationValue sourceAnnotationValue;
    private final AnnotationValue targetAnnotationValue;
    private final MappingGem mapping;
    private final InheritContext inheritContext;

    public static Set<String> getMappingTargetNamesBy(Predicate<MappingOptions> predicate, Set<MappingOptions> mappings) {
        return mappings.stream().filter(predicate).map(MappingOptions::getTargetName).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static void addInstances(MappingsGem gem, ExecutableElement method, BeanMappingOptions beanMappingOptions, FormattingMessager messager, TypeUtils typeUtils, Set<MappingOptions> mappings) {
        for (MappingGem mapping : gem.value().getValue()) {
            MappingOptions.addInstance(mapping, method, beanMappingOptions, messager, typeUtils, mappings);
        }
    }

    public static void addInstance(MappingGem mapping, ExecutableElement method, BeanMappingOptions beanMappingOptions, FormattingMessager messager, TypeUtils typeUtils, Set<MappingOptions> mappings) {
        if (!MappingOptions.isConsistent(mapping, method, messager)) {
            return;
        }
        String source = mapping.source().getValue();
        String constant = mapping.constant().getValue();
        String expression = MappingOptions.getExpression(mapping, method, messager);
        String defaultExpression = MappingOptions.getDefaultExpression(mapping, method, messager);
        String conditionExpression = MappingOptions.getConditionExpression(mapping, method, messager);
        String dateFormat = mapping.dateFormat().getValue();
        String numberFormat = mapping.numberFormat().getValue();
        String defaultValue = mapping.defaultValue().getValue();
        LinkedHashSet<String> dependsOn = mapping.dependsOn().hasValue() ? new LinkedHashSet<String>((Collection)mapping.dependsOn().getValue()) : Collections.emptySet();
        FormattingParameters formattingParam = new FormattingParameters(dateFormat, numberFormat, mapping.mirror(), mapping.dateFormat().getAnnotationValue(), method);
        SelectionParameters selectionParams = new SelectionParameters(mapping.qualifiedBy().get(), mapping.qualifiedByName().get(), mapping.conditionQualifiedBy().get(), mapping.conditionQualifiedByName().get(), mapping.resultType().getValue(), typeUtils);
        MappingOptions options = new MappingOptions(mapping.target().getValue(), method, mapping.target().getAnnotationValue(), source, mapping.source().getAnnotationValue(), constant, expression, defaultExpression, conditionExpression, defaultValue, mapping.ignore().get(), formattingParam, selectionParams, dependsOn, mapping, null, beanMappingOptions);
        if (mappings.contains(options)) {
            messager.printMessage((Element)method, Message.PROPERTYMAPPING_DUPLICATE_TARGETS, mapping.target().get());
        } else {
            mappings.add(options);
        }
    }

    public static MappingOptions forIgnore(String targetName) {
        return new MappingOptions(targetName, null, null, null, null, null, null, null, null, null, true, null, null, Collections.emptySet(), null, null, null);
    }

    private static boolean isConsistent(MappingGem gem, ExecutableElement method, FormattingMessager messager) {
        if (!gem.target().hasValue()) {
            messager.printMessage((Element)method, gem.mirror(), gem.target().getAnnotationValue(), Message.PROPERTYMAPPING_EMPTY_TARGET, new Object[0]);
            return false;
        }
        Message message = null;
        if (gem.source().hasValue() && gem.constant().hasValue()) {
            message = Message.PROPERTYMAPPING_SOURCE_AND_CONSTANT_BOTH_DEFINED;
        } else if (gem.source().hasValue() && gem.expression().hasValue()) {
            message = Message.PROPERTYMAPPING_SOURCE_AND_EXPRESSION_BOTH_DEFINED;
        } else if (gem.expression().hasValue() && gem.constant().hasValue()) {
            message = Message.PROPERTYMAPPING_EXPRESSION_AND_CONSTANT_BOTH_DEFINED;
        } else if (gem.expression().hasValue() && gem.defaultValue().hasValue()) {
            message = Message.PROPERTYMAPPING_EXPRESSION_AND_DEFAULT_VALUE_BOTH_DEFINED;
        } else if (gem.constant().hasValue() && gem.defaultValue().hasValue()) {
            message = Message.PROPERTYMAPPING_CONSTANT_AND_DEFAULT_VALUE_BOTH_DEFINED;
        } else if (gem.expression().hasValue() && gem.defaultExpression().hasValue()) {
            message = Message.PROPERTYMAPPING_EXPRESSION_AND_DEFAULT_EXPRESSION_BOTH_DEFINED;
        } else if (gem.expression().hasValue() && gem.conditionExpression().hasValue()) {
            message = Message.PROPERTYMAPPING_EXPRESSION_AND_CONDITION_EXPRESSION_BOTH_DEFINED;
        } else if (gem.constant().hasValue() && gem.defaultExpression().hasValue()) {
            message = Message.PROPERTYMAPPING_CONSTANT_AND_DEFAULT_EXPRESSION_BOTH_DEFINED;
        } else if (gem.constant().hasValue() && gem.conditionExpression().hasValue()) {
            message = Message.PROPERTYMAPPING_CONSTANT_AND_CONDITION_EXPRESSION_BOTH_DEFINED;
        } else if (gem.defaultValue().hasValue() && gem.defaultExpression().hasValue()) {
            message = Message.PROPERTYMAPPING_DEFAULT_VALUE_AND_DEFAULT_EXPRESSION_BOTH_DEFINED;
        } else if (gem.expression().hasValue() && (gem.qualifiedByName().hasValue() || gem.qualifiedBy().hasValue())) {
            message = Message.PROPERTYMAPPING_EXPRESSION_AND_QUALIFIER_BOTH_DEFINED;
        } else if (gem.nullValuePropertyMappingStrategy().hasValue() && gem.defaultValue().hasValue()) {
            message = Message.PROPERTYMAPPING_DEFAULT_VALUE_AND_NVPMS;
        } else if (gem.nullValuePropertyMappingStrategy().hasValue() && gem.constant().hasValue()) {
            message = Message.PROPERTYMAPPING_CONSTANT_VALUE_AND_NVPMS;
        } else if (gem.nullValuePropertyMappingStrategy().hasValue() && gem.expression().hasValue()) {
            message = Message.PROPERTYMAPPING_EXPRESSION_VALUE_AND_NVPMS;
        } else if (gem.nullValuePropertyMappingStrategy().hasValue() && gem.defaultExpression().hasValue()) {
            message = Message.PROPERTYMAPPING_DEFAULT_EXPERSSION_AND_NVPMS;
        } else if (gem.nullValuePropertyMappingStrategy().hasValue() && gem.ignore().hasValue() && gem.ignore().getValue().booleanValue()) {
            message = Message.PROPERTYMAPPING_IGNORE_AND_NVPMS;
        }
        if (message == null) {
            return true;
        }
        messager.printMessage((Element)method, gem.mirror(), message, new Object[0]);
        return false;
    }

    private MappingOptions(String targetName, Element element, AnnotationValue targetAnnotationValue, String sourceName, AnnotationValue sourceAnnotationValue, String constant, String javaExpression, String defaultJavaExpression, String conditionJavaExpression, String defaultValue, boolean isIgnored, FormattingParameters formattingParameters, SelectionParameters selectionParameters, Set<String> dependsOn, MappingGem mapping, InheritContext inheritContext, DelegatingOptions next) {
        super(next);
        this.targetName = targetName;
        this.element = element;
        this.targetAnnotationValue = targetAnnotationValue;
        this.sourceName = sourceName;
        this.sourceAnnotationValue = sourceAnnotationValue;
        this.constant = constant;
        this.javaExpression = javaExpression;
        this.defaultJavaExpression = defaultJavaExpression;
        this.conditionJavaExpression = conditionJavaExpression;
        this.defaultValue = defaultValue;
        this.isIgnored = isIgnored;
        this.formattingParameters = formattingParameters;
        this.selectionParameters = selectionParameters;
        this.dependsOn = dependsOn;
        this.mapping = mapping;
        this.inheritContext = inheritContext;
    }

    private static String getExpression(MappingGem mapping, ExecutableElement element, FormattingMessager messager) {
        if (!mapping.expression().hasValue()) {
            return null;
        }
        Matcher javaExpressionMatcher = JAVA_EXPRESSION.matcher(mapping.expression().get());
        if (!javaExpressionMatcher.matches()) {
            messager.printMessage((Element)element, mapping.mirror(), mapping.expression().getAnnotationValue(), Message.PROPERTYMAPPING_INVALID_EXPRESSION, new Object[0]);
            return null;
        }
        return javaExpressionMatcher.group(1).trim();
    }

    private static String getDefaultExpression(MappingGem mapping, ExecutableElement element, FormattingMessager messager) {
        if (!mapping.defaultExpression().hasValue()) {
            return null;
        }
        Matcher javaExpressionMatcher = JAVA_EXPRESSION.matcher(mapping.defaultExpression().get());
        if (!javaExpressionMatcher.matches()) {
            messager.printMessage((Element)element, mapping.mirror(), mapping.defaultExpression().getAnnotationValue(), Message.PROPERTYMAPPING_INVALID_DEFAULT_EXPRESSION, new Object[0]);
            return null;
        }
        return javaExpressionMatcher.group(1).trim();
    }

    private static String getConditionExpression(MappingGem mapping, ExecutableElement element, FormattingMessager messager) {
        if (!mapping.conditionExpression().hasValue()) {
            return null;
        }
        Matcher javaExpressionMatcher = JAVA_EXPRESSION.matcher(mapping.conditionExpression().get());
        if (!javaExpressionMatcher.matches()) {
            messager.printMessage((Element)element, mapping.mirror(), mapping.conditionExpression().getAnnotationValue(), Message.PROPERTYMAPPING_INVALID_CONDITION_EXPRESSION, new Object[0]);
            return null;
        }
        return javaExpressionMatcher.group(1).trim();
    }

    public String getTargetName() {
        return this.targetName;
    }

    public AnnotationValue getTargetAnnotationValue() {
        return this.targetAnnotationValue;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public AnnotationValue getSourceAnnotationValue() {
        return this.sourceAnnotationValue;
    }

    public String getConstant() {
        return this.constant;
    }

    public String getJavaExpression() {
        return this.javaExpression;
    }

    public String getDefaultJavaExpression() {
        return this.defaultJavaExpression;
    }

    public String getConditionJavaExpression() {
        return this.conditionJavaExpression;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public FormattingParameters getFormattingParameters() {
        return this.formattingParameters;
    }

    public SelectionParameters getSelectionParameters() {
        return this.selectionParameters;
    }

    public boolean isIgnored() {
        return this.isIgnored;
    }

    public AnnotationMirror getMirror() {
        return Optional.ofNullable(this.mapping).map(MappingGem::mirror).orElse(null);
    }

    public Element getElement() {
        return this.element;
    }

    public AnnotationValue getDependsOnAnnotationValue() {
        return Optional.ofNullable(this.mapping).map(MappingGem::dependsOn).map(GemValue::getAnnotationValue).orElse(null);
    }

    public Set<String> getDependsOn() {
        return this.dependsOn;
    }

    public InheritContext getInheritContext() {
        return this.inheritContext;
    }

    @Override
    public NullValueCheckStrategyGem getNullValueCheckStrategy() {
        return Optional.ofNullable(this.mapping).map(MappingGem::nullValueCheckStrategy).filter(GemValue::hasValue).map(GemValue::getValue).map(NullValueCheckStrategyGem::valueOf).orElse(this.next().getNullValueCheckStrategy());
    }

    @Override
    public NullValuePropertyMappingStrategyGem getNullValuePropertyMappingStrategy() {
        return Optional.ofNullable(this.mapping).map(MappingGem::nullValuePropertyMappingStrategy).filter(GemValue::hasValue).map(GemValue::getValue).map(NullValuePropertyMappingStrategyGem::valueOf).orElse(this.next().getNullValuePropertyMappingStrategy());
    }

    @Override
    public MappingControl getMappingControl(ElementUtils elementUtils) {
        return Optional.ofNullable(this.mapping).map(MappingGem::mappingControl).filter(GemValue::hasValue).map(GemValue::getValue).map(mc -> MappingControl.fromTypeMirror(mc, elementUtils)).orElse(this.next().getMappingControl(elementUtils));
    }

    public boolean canInverse() {
        return this.constant == null && this.javaExpression == null && (!this.isIgnored || this.sourceName != null);
    }

    public MappingOptions copyForInverseInheritance(SourceMethod templateMethod, BeanMappingOptions beanMappingOptions) {
        MappingOptions mappingOptions = new MappingOptions(this.sourceName != null ? this.sourceName : this.targetName, templateMethod.getExecutable(), this.targetAnnotationValue, this.sourceName != null ? this.targetName : null, this.sourceAnnotationValue, null, null, null, null, null, this.isIgnored, this.formattingParameters, this.selectionParameters, Collections.emptySet(), this.mapping, new InheritContext(true, false, templateMethod), beanMappingOptions);
        return mappingOptions;
    }

    public MappingOptions copyForForwardInheritance(SourceMethod templateMethod, BeanMappingOptions beanMappingOptions) {
        MappingOptions mappingOptions = new MappingOptions(this.targetName, templateMethod.getExecutable(), this.targetAnnotationValue, this.sourceName, this.sourceAnnotationValue, this.constant, this.javaExpression, this.defaultJavaExpression, this.conditionJavaExpression, this.defaultValue, this.isIgnored, this.formattingParameters, this.selectionParameters, this.dependsOn, this.mapping, new InheritContext(false, true, templateMethod), beanMappingOptions);
        return mappingOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (".".equals(this.targetName)) {
            return false;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingOptions mapping = (MappingOptions)o;
        return this.targetName.equals(mapping.targetName);
    }

    public int hashCode() {
        return Objects.hash(this.targetName);
    }

    public String toString() {
        return "Mapping {\n    sourceName='" + this.sourceName + "',\n    targetName='" + this.targetName + "',\n}";
    }

    @Override
    public boolean hasAnnotation() {
        return this.mapping != null;
    }

    public static class InheritContext {
        private final boolean isReversed;
        private final boolean isForwarded;
        private final Method templateMethod;

        public InheritContext(boolean isReversed, boolean isForwarded, Method templateMethod) {
            this.isReversed = isReversed;
            this.isForwarded = isForwarded;
            this.templateMethod = templateMethod;
        }

        public boolean isReversed() {
            return this.isReversed;
        }

        public boolean isForwarded() {
            return this.isForwarded;
        }

        public Method getTemplateMethod() {
            return this.templateMethod;
        }
    }
}

