/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import org.mapstruct.ap.shaded.freemarker.core.MessageUtil;
import org.mapstruct.ap.shaded.freemarker.core.ParameterRole;
import org.mapstruct.ap.shaded.freemarker.core.ParseException;
import org.mapstruct.ap.shaded.freemarker.core.Token;
import org.mapstruct.ap.shaded.freemarker.template.Template;

public abstract class TemplateObject {
    private Template template;
    int beginColumn;
    int beginLine;
    int endColumn;
    int endLine;
    static final int RUNTIME_EVAL_LINE_DISPLACEMENT = -1000000000;

    final void setLocation(Template template, Token begin, Token end) throws ParseException {
        this.setLocation(template, begin.beginColumn, begin.beginLine, end.endColumn, end.endLine);
    }

    final void setLocation(Template template, Token begin, TemplateObject end) throws ParseException {
        this.setLocation(template, begin.beginColumn, begin.beginLine, end.endColumn, end.endLine);
    }

    final void setLocation(Template template, TemplateObject begin, Token end) throws ParseException {
        this.setLocation(template, begin.beginColumn, begin.beginLine, end.endColumn, end.endLine);
    }

    final void setLocation(Template template, TemplateObject begin, TemplateObject end) throws ParseException {
        this.setLocation(template, begin.beginColumn, begin.beginLine, end.endColumn, end.endLine);
    }

    void setLocation(Template template, int beginColumn, int beginLine, int endColumn, int endLine) throws ParseException {
        this.template = template;
        this.beginColumn = beginColumn;
        this.beginLine = beginLine;
        this.endColumn = endColumn;
        this.endLine = endLine;
    }

    public final int getBeginColumn() {
        return this.beginColumn;
    }

    public final int getBeginLine() {
        return this.beginLine;
    }

    public final int getEndColumn() {
        return this.endColumn;
    }

    public final int getEndLine() {
        return this.endLine;
    }

    public String getStartLocation() {
        return MessageUtil.formatLocationForEvaluationError(this.template, this.beginLine, this.beginColumn);
    }

    public String getStartLocationQuoted() {
        return this.getStartLocation();
    }

    public String getEndLocation() {
        return MessageUtil.formatLocationForEvaluationError(this.template, this.endLine, this.endColumn);
    }

    public String getEndLocationQuoted() {
        return this.getEndLocation();
    }

    public final String getSource() {
        String s = this.template != null ? this.template.getSource(this.beginColumn, this.beginLine, this.endColumn, this.endLine) : null;
        return s != null ? s : this.getCanonicalForm();
    }

    public String toString() {
        String s;
        try {
            s = this.getSource();
        }
        catch (Exception e) {
            s = null;
        }
        return s != null ? s : this.getCanonicalForm();
    }

    public boolean contains(int column, int line) {
        if (line < this.beginLine || line > this.endLine) {
            return false;
        }
        if (line == this.beginLine && column < this.beginColumn) {
            return false;
        }
        return line != this.endLine || column <= this.endColumn;
    }

    public Template getTemplate() {
        return this.template;
    }

    TemplateObject copyLocationFrom(TemplateObject from) {
        this.template = from.template;
        this.beginColumn = from.beginColumn;
        this.beginLine = from.beginLine;
        this.endColumn = from.endColumn;
        this.endLine = from.endLine;
        return this;
    }

    public abstract String getCanonicalForm();

    abstract String getNodeTypeSymbol();

    abstract int getParameterCount();

    abstract Object getParameterValue(int var1);

    abstract ParameterRole getParameterRole(int var1);
}

