/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.mapstruct.ap.internal.util.Executables;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.accessor.AccessorType;
import org.mapstruct.ap.spi.AccessorNamingStrategy;
import org.mapstruct.ap.spi.MethodType;

public final class AccessorNamingUtils {
    private final AccessorNamingStrategy accessorNamingStrategy;

    public AccessorNamingUtils(AccessorNamingStrategy accessorNamingStrategy) {
        this.accessorNamingStrategy = accessorNamingStrategy;
    }

    public boolean isGetterMethod(ExecutableElement executable) {
        return executable != null && Executables.isPublicNotStatic(executable) && executable.getParameters().isEmpty() && this.accessorNamingStrategy.getMethodType(executable) == MethodType.GETTER;
    }

    public boolean isPresenceCheckMethod(ExecutableElement executable) {
        return executable != null && Executables.isPublicNotStatic(executable) && executable.getParameters().isEmpty() && (executable.getReturnType().getKind() == TypeKind.BOOLEAN || "java.lang.Boolean".equals(AccessorNamingUtils.getQualifiedName(executable.getReturnType()))) && this.accessorNamingStrategy.getMethodType(executable) == MethodType.PRESENCE_CHECKER;
    }

    public boolean isSetterMethod(ExecutableElement executable) {
        return executable != null && Executables.isPublicNotStatic(executable) && executable.getParameters().size() == 1 && this.accessorNamingStrategy.getMethodType(executable) == MethodType.SETTER;
    }

    public boolean isAdderMethod(ExecutableElement executable) {
        return executable != null && Executables.isPublicNotStatic(executable) && executable.getParameters().size() == 1 && this.accessorNamingStrategy.getMethodType(executable) == MethodType.ADDER;
    }

    public String getPropertyName(ExecutableElement executable) {
        return this.accessorNamingStrategy.getPropertyName(executable);
    }

    public String getElementNameForAdder(Accessor adderMethod) {
        if (adderMethod.getAccessorType() == AccessorType.ADDER) {
            return this.accessorNamingStrategy.getElementName((ExecutableElement)adderMethod.getElement());
        }
        return null;
    }

    private static String getQualifiedName(TypeMirror type) {
        DeclaredType declaredType = type.accept(new SimpleTypeVisitor6<DeclaredType, Void>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        }, null);
        if (declaredType == null) {
            return null;
        }
        TypeElement typeElement = declaredType.asElement().accept(new SimpleElementVisitor6<TypeElement, Void>(){

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }
        }, null);
        return typeElement != null ? typeElement.getQualifiedName().toString() : null;
    }
}

