/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import org.mapstruct.ap.shaded.freemarker.template.TemplateModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModelException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModelIterator;
import org.mapstruct.ap.shaded.freemarker.template.TemplateSequenceModel;

class LazySequenceIterator
implements TemplateModelIterator {
    private final TemplateSequenceModel sequence;
    private Integer size;
    private int index = 0;

    LazySequenceIterator(TemplateSequenceModel sequence) throws TemplateModelException {
        this.sequence = sequence;
    }

    @Override
    public TemplateModel next() throws TemplateModelException {
        return this.sequence.get(this.index++);
    }

    @Override
    public boolean hasNext() {
        if (this.size == null) {
            try {
                this.size = this.sequence.size();
            }
            catch (TemplateModelException e) {
                throw new RuntimeException("Error when getting sequence size", e);
            }
        }
        return this.index < this.size;
    }
}

