package org.mapstruct.ap.internal.gem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor8;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.tools.gem.Gem;
import org.mapstruct.tools.gem.GemValue;

import javax.lang.model.type.TypeMirror;

public class ElementGem implements Gem {

    private final GemValue<String> name;
    private final GemValue<List<Short>> shorts;
    private final GemValue<List<Byte>> bytes;
    private final GemValue<List<Integer>> ints;
    private final GemValue<List<Long>> longs;
    private final GemValue<List<Float>> floats;
    private final GemValue<List<Double>> doubles;
    private final GemValue<List<Character>> chars;
    private final GemValue<List<Boolean>> booleans;
    private final GemValue<List<String>> strings;
    private final GemValue<List<TypeMirror>> classes;
    private final GemValue<TypeMirror> enumClass;
    private final GemValue<List<String>> enums;
    private final boolean isValid;
    private final AnnotationMirror mirror;

    private ElementGem( BuilderImpl builder ) {
        this.name = builder.name;
        this.shorts = builder.shorts;
        this.bytes = builder.bytes;
        this.ints = builder.ints;
        this.longs = builder.longs;
        this.floats = builder.floats;
        this.doubles = builder.doubles;
        this.chars = builder.chars;
        this.booleans = builder.booleans;
        this.strings = builder.strings;
        this.classes = builder.classes;
        this.enumClass = builder.enumClass;
        this.enums = builder.enums;
        isValid = ( this.name != null ? this.name.isValid() : false )
               && ( this.shorts != null ? this.shorts.isValid() : false )
               && ( this.bytes != null ? this.bytes.isValid() : false )
               && ( this.ints != null ? this.ints.isValid() : false )
               && ( this.longs != null ? this.longs.isValid() : false )
               && ( this.floats != null ? this.floats.isValid() : false )
               && ( this.doubles != null ? this.doubles.isValid() : false )
               && ( this.chars != null ? this.chars.isValid() : false )
               && ( this.booleans != null ? this.booleans.isValid() : false )
               && ( this.strings != null ? this.strings.isValid() : false )
               && ( this.classes != null ? this.classes.isValid() : false )
               && ( this.enumClass != null ? this.enumClass.isValid() : false )
               && ( this.enums != null ? this.enums.isValid() : false );
        mirror = builder.mirror;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ElementGem#name}
    */
    public GemValue<String> name( ) {
        return name;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ElementGem#shorts}
    */
    public GemValue<List<Short>> shorts( ) {
        return shorts;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ElementGem#bytes}
    */
    public GemValue<List<Byte>> bytes( ) {
        return bytes;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ElementGem#ints}
    */
    public GemValue<List<Integer>> ints( ) {
        return ints;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ElementGem#longs}
    */
    public GemValue<List<Long>> longs( ) {
        return longs;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ElementGem#floats}
    */
    public GemValue<List<Float>> floats( ) {
        return floats;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ElementGem#doubles}
    */
    public GemValue<List<Double>> doubles( ) {
        return doubles;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ElementGem#chars}
    */
    public GemValue<List<Character>> chars( ) {
        return chars;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ElementGem#booleans}
    */
    public GemValue<List<Boolean>> booleans( ) {
        return booleans;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ElementGem#strings}
    */
    public GemValue<List<String>> strings( ) {
        return strings;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ElementGem#classes}
    */
    public GemValue<List<TypeMirror>> classes( ) {
        return classes;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ElementGem#enumClass}
    */
    public GemValue<TypeMirror> enumClass( ) {
        return enumClass;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ElementGem#enums}
    */
    public GemValue<List<String>> enums( ) {
        return enums;
    }

    @Override
    public AnnotationMirror mirror( ) {
        return mirror;
    }

    @Override
    public boolean isValid( ) {
        return isValid;
    }

    public static ElementGem  instanceOn(Element element) {
        return build( element, new BuilderImpl() );
    }

    public static ElementGem instanceOn(AnnotationMirror mirror ) {
        return build( mirror, new BuilderImpl() );
    }

    public static  <T> T  build(Element element, Builder<T> builder) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream()
            .filter( a ->  "org.mapstruct.AnnotateWith.Element".contentEquals( ( ( TypeElement )a.getAnnotationType().asElement() ).getQualifiedName() ) )
            .findAny()
            .orElse( null );
        return build( mirror, builder );
    }

    public static <T> T build(AnnotationMirror mirror, Builder<T> builder ) {

        // return fast
        if ( mirror == null || builder == null ) {
            return null;
        }

        // fetch defaults from all defined values in the annotation type
        List<ExecutableElement> enclosed = ElementFilter.methodsIn( mirror.getAnnotationType().asElement().getEnclosedElements() );
        Map<String, AnnotationValue> defaultValues = new HashMap<>( enclosed.size() );
        enclosed.forEach( e -> defaultValues.put( e.getSimpleName().toString(), e.getDefaultValue() ) );

        // fetch all explicitely set annotation values in the annotation instance
        Map<String, AnnotationValue> values = new HashMap<>( enclosed.size() );
        mirror.getElementValues().entrySet().forEach( e -> values.put( e.getKey().getSimpleName().toString(), e.getValue() ) );

        // iterate and populate builder
        for ( String methodName : defaultValues.keySet() ) {

            if ( "name".equals( methodName ) ) {
                builder.setName( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "shorts".equals( methodName ) ) {
                builder.setShorts( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), Short.class ) );
            }
            else if ( "bytes".equals( methodName ) ) {
                builder.setBytes( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), Byte.class ) );
            }
            else if ( "ints".equals( methodName ) ) {
                builder.setInts( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), Integer.class ) );
            }
            else if ( "longs".equals( methodName ) ) {
                builder.setLongs( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), Long.class ) );
            }
            else if ( "floats".equals( methodName ) ) {
                builder.setFloats( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), Float.class ) );
            }
            else if ( "doubles".equals( methodName ) ) {
                builder.setDoubles( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), Double.class ) );
            }
            else if ( "chars".equals( methodName ) ) {
                builder.setChars( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), Character.class ) );
            }
            else if ( "booleans".equals( methodName ) ) {
                builder.setBooleans( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), Boolean.class ) );
            }
            else if ( "strings".equals( methodName ) ) {
                builder.setStrings( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "classes".equals( methodName ) ) {
                builder.setClasses( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), TypeMirror.class ) );
            }
            else if ( "enumClass".equals( methodName ) ) {
                builder.setEnumclass( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), TypeMirror.class ) );
            }
            else if ( "enums".equals( methodName ) ) {
                builder.setEnums( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
        }
        builder.setMirror( mirror );
        return builder.build();
    }

    /**
     * A builder that can be implemented by the user to define custom logic e.g. in the
     * build method, prior to creating the annotation gem.
     */
    public interface Builder<T> {

       /**
        * Sets the {@link GemValue} for {@link ElementGem#name}
        *
        * @return the {@link Builder} for this gem, representing {@link ElementGem}
        */
        Builder setName(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link ElementGem#shorts}
        *
        * @return the {@link Builder} for this gem, representing {@link ElementGem}
        */
        Builder setShorts(GemValue<List<Short>> methodName );

       /**
        * Sets the {@link GemValue} for {@link ElementGem#bytes}
        *
        * @return the {@link Builder} for this gem, representing {@link ElementGem}
        */
        Builder setBytes(GemValue<List<Byte>> methodName );

       /**
        * Sets the {@link GemValue} for {@link ElementGem#ints}
        *
        * @return the {@link Builder} for this gem, representing {@link ElementGem}
        */
        Builder setInts(GemValue<List<Integer>> methodName );

       /**
        * Sets the {@link GemValue} for {@link ElementGem#longs}
        *
        * @return the {@link Builder} for this gem, representing {@link ElementGem}
        */
        Builder setLongs(GemValue<List<Long>> methodName );

       /**
        * Sets the {@link GemValue} for {@link ElementGem#floats}
        *
        * @return the {@link Builder} for this gem, representing {@link ElementGem}
        */
        Builder setFloats(GemValue<List<Float>> methodName );

       /**
        * Sets the {@link GemValue} for {@link ElementGem#doubles}
        *
        * @return the {@link Builder} for this gem, representing {@link ElementGem}
        */
        Builder setDoubles(GemValue<List<Double>> methodName );

       /**
        * Sets the {@link GemValue} for {@link ElementGem#chars}
        *
        * @return the {@link Builder} for this gem, representing {@link ElementGem}
        */
        Builder setChars(GemValue<List<Character>> methodName );

       /**
        * Sets the {@link GemValue} for {@link ElementGem#booleans}
        *
        * @return the {@link Builder} for this gem, representing {@link ElementGem}
        */
        Builder setBooleans(GemValue<List<Boolean>> methodName );

       /**
        * Sets the {@link GemValue} for {@link ElementGem#strings}
        *
        * @return the {@link Builder} for this gem, representing {@link ElementGem}
        */
        Builder setStrings(GemValue<List<String>> methodName );

       /**
        * Sets the {@link GemValue} for {@link ElementGem#classes}
        *
        * @return the {@link Builder} for this gem, representing {@link ElementGem}
        */
        Builder setClasses(GemValue<List<TypeMirror>> methodName );

       /**
        * Sets the {@link GemValue} for {@link ElementGem#enumClass}
        *
        * @return the {@link Builder} for this gem, representing {@link ElementGem}
        */
        Builder setEnumclass(GemValue<TypeMirror> methodName );

       /**
        * Sets the {@link GemValue} for {@link ElementGem#enums}
        *
        * @return the {@link Builder} for this gem, representing {@link ElementGem}
        */
        Builder setEnums(GemValue<List<String>> methodName );

        /**
         * Sets the annotation mirror
         *
         * @param mirror the mirror which this gem represents
         *
         * @return the {@link Builder} for this gem, representing {@link ElementGem}
         */
          Builder setMirror( AnnotationMirror mirror );

        /**
         * The build method can be overriden in a custom custom implementation, which allows
         * the user to define his own custom validation on the annotation.
         *
         * @return the representation of the annotation
         */
        T build();
    }

    private static class BuilderImpl implements Builder<ElementGem> {

        private GemValue<String> name;
        private GemValue<List<Short>> shorts;
        private GemValue<List<Byte>> bytes;
        private GemValue<List<Integer>> ints;
        private GemValue<List<Long>> longs;
        private GemValue<List<Float>> floats;
        private GemValue<List<Double>> doubles;
        private GemValue<List<Character>> chars;
        private GemValue<List<Boolean>> booleans;
        private GemValue<List<String>> strings;
        private GemValue<List<TypeMirror>> classes;
        private GemValue<TypeMirror> enumClass;
        private GemValue<List<String>> enums;
        private AnnotationMirror mirror;

        public Builder setName(GemValue<String> name ) {
            this.name = name;
            return this;
        }

        public Builder setShorts(GemValue<List<Short>> shorts ) {
            this.shorts = shorts;
            return this;
        }

        public Builder setBytes(GemValue<List<Byte>> bytes ) {
            this.bytes = bytes;
            return this;
        }

        public Builder setInts(GemValue<List<Integer>> ints ) {
            this.ints = ints;
            return this;
        }

        public Builder setLongs(GemValue<List<Long>> longs ) {
            this.longs = longs;
            return this;
        }

        public Builder setFloats(GemValue<List<Float>> floats ) {
            this.floats = floats;
            return this;
        }

        public Builder setDoubles(GemValue<List<Double>> doubles ) {
            this.doubles = doubles;
            return this;
        }

        public Builder setChars(GemValue<List<Character>> chars ) {
            this.chars = chars;
            return this;
        }

        public Builder setBooleans(GemValue<List<Boolean>> booleans ) {
            this.booleans = booleans;
            return this;
        }

        public Builder setStrings(GemValue<List<String>> strings ) {
            this.strings = strings;
            return this;
        }

        public Builder setClasses(GemValue<List<TypeMirror>> classes ) {
            this.classes = classes;
            return this;
        }

        public Builder setEnumclass(GemValue<TypeMirror> enumClass ) {
            this.enumClass = enumClass;
            return this;
        }

        public Builder setEnums(GemValue<List<String>> enums ) {
            this.enums = enums;
            return this;
        }

        public Builder  setMirror( AnnotationMirror mirror ) {
            this.mirror = mirror;
            return this;
        }

        public ElementGem build() {
            return new ElementGem( this );
        }
    }

}
