/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.tools.gem;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;

public class GemValue<T> {
    private final T value;
    private final T defaultValue;
    private final AnnotationValue annotationValue;

    public static <V> GemValue<V> create(AnnotationValue annotationValue, AnnotationValue annotationDefaultValue, Class<V> valueClass) {
        Object value = annotationValue == null ? null : (Object)valueClass.cast(annotationValue.getValue());
        Object defaultValue = annotationDefaultValue == null ? null : (Object)valueClass.cast(annotationDefaultValue.getValue());
        return new GemValue<Object>(value, defaultValue, annotationValue);
    }

    public static <V> GemValue<List<V>> createArray(AnnotationValue annotationValue, AnnotationValue annotationDefaultValue, Class<V> valueClass) {
        List value = GemValue.extractListValues(annotationValue, valueClass, Function.identity());
        List defaultValue = GemValue.extractListValues(annotationDefaultValue, valueClass, Function.identity());
        return new GemValue<List<V>>(value, defaultValue, annotationValue);
    }

    public static GemValue<String> createEnum(AnnotationValue annotationValue, AnnotationValue annotationDefaultValue) {
        String value = annotationValue == null ? null : ((VariableElement)annotationValue.getValue()).getSimpleName().toString();
        String defaultValue = annotationDefaultValue == null ? null : ((VariableElement)annotationDefaultValue.getValue()).getSimpleName().toString();
        return new GemValue<String>(value, defaultValue, annotationValue);
    }

    public static GemValue<List<String>> createEnumArray(AnnotationValue annotationValue, AnnotationValue annotationDefaultValue) {
        List<String> value = GemValue.extractListValues(annotationValue, VariableElement.class, variableElement -> variableElement.getSimpleName().toString());
        List<String> defaultValue = GemValue.extractListValues(annotationDefaultValue, VariableElement.class, variableElement -> variableElement.getSimpleName().toString());
        return new GemValue<List<String>>(value, defaultValue, annotationValue);
    }

    public static <V> GemValue<V> create(AnnotationValue annotationValue, AnnotationValue annotationDefaultValue, Function<AnnotationMirror, V> creator) {
        Object value = annotationValue == null ? null : (Object)creator.apply((AnnotationMirror)annotationValue.getValue());
        Object defaultValue = annotationDefaultValue == null ? null : (Object)creator.apply((AnnotationMirror)annotationDefaultValue.getValue());
        return new GemValue<Object>(value, defaultValue, annotationValue);
    }

    public static <V> GemValue<List<V>> createArray(AnnotationValue annotationValue, AnnotationValue annotationDefaultValue, Function<AnnotationMirror, V> creator) {
        List<V> value = GemValue.extractListValues(annotationValue, AnnotationMirror.class, creator);
        List<V> defaultValue = GemValue.extractListValues(annotationDefaultValue, AnnotationMirror.class, creator);
        return new GemValue<List<V>>(value, defaultValue, annotationValue);
    }

    private static <V, R> List<R> extractListValues(AnnotationValue annotationValue, Class<V> valueClass, Function<V, R> mapper) {
        Object definedValue;
        List value = annotationValue != null ? ((definedValue = annotationValue.getValue()) instanceof List ? GemValue.toStream((List)definedValue, valueClass).map(mapper).collect(Collectors.toList()) : null) : null;
        return value;
    }

    private static <T> Stream<T> toStream(List<?> annotationValues, Class<T> clz) {
        return annotationValues.stream().filter(AnnotationValue.class::isInstance).map(AnnotationValue.class::cast).map(AnnotationValue::getValue).filter(clz::isInstance).map(clz::cast);
    }

    private GemValue(T value, T defaultValue, AnnotationValue annotationValue) {
        this.value = value;
        this.defaultValue = defaultValue;
        this.annotationValue = annotationValue;
    }

    public T get() {
        return this.value != null ? this.value : this.defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public AnnotationValue getAnnotationValue() {
        return this.annotationValue;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean isValid() {
        return this.value != null || this.defaultValue != null;
    }
}

