/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.PacketFetcher;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.common.packet.CompressOutputStream;
import org.mariadb.jdbc.internal.common.packet.DecompressInputStream;
import org.mariadb.jdbc.internal.common.packet.EOFPacket;
import org.mariadb.jdbc.internal.common.packet.ErrorPacket;
import org.mariadb.jdbc.internal.common.packet.LocalInfilePacket;
import org.mariadb.jdbc.internal.common.packet.MaxAllowedPacketException;
import org.mariadb.jdbc.internal.common.packet.OKPacket;
import org.mariadb.jdbc.internal.common.packet.PacketOutputStream;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacketFactory;
import org.mariadb.jdbc.internal.common.packet.ResultSetPacket;
import org.mariadb.jdbc.internal.common.packet.SyncPacketFetcher;
import org.mariadb.jdbc.internal.common.packet.buffer.ReadUtil;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;
import org.mariadb.jdbc.internal.common.packet.commands.ClosePacket;
import org.mariadb.jdbc.internal.common.packet.commands.SelectDBPacket;
import org.mariadb.jdbc.internal.common.packet.commands.StreamedQueryPacket;
import org.mariadb.jdbc.internal.common.query.MySQLQuery;
import org.mariadb.jdbc.internal.common.query.Query;
import org.mariadb.jdbc.internal.common.queryresults.CachedSelectResult;
import org.mariadb.jdbc.internal.common.queryresults.NoSuchColumnException;
import org.mariadb.jdbc.internal.common.queryresults.QueryResult;
import org.mariadb.jdbc.internal.common.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.common.queryresults.StreamingSelectResult;
import org.mariadb.jdbc.internal.common.queryresults.UpdateResult;
import org.mariadb.jdbc.internal.mysql.MySQLColumnInformation;
import org.mariadb.jdbc.internal.mysql.MyX509TrustManager;
import org.mariadb.jdbc.internal.mysql.NamedPipeSocket;
import org.mariadb.jdbc.internal.mysql.SharedMemorySocket;
import org.mariadb.jdbc.internal.mysql.UnixDomainSocket;
import org.mariadb.jdbc.internal.mysql.packet.MySQLGreetingReadPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.AbbreviatedMySQLClientAuthPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.MySQLClientAuthPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.MySQLClientOldPasswordAuthPacket;
import org.mariadb.jdbc.internal.mysql.packet.commands.MySQLPingPacket;

public class MySQLProtocol {
    private static final Logger log = Logger.getLogger(MySQLProtocol.class.getName());
    private boolean connected = false;
    private Socket socket;
    private PacketOutputStream writer;
    private String version;
    private boolean readOnly = false;
    private String database;
    private final String username;
    private final String password;
    private int maxRows;
    private SyncPacketFetcher packetFetcher;
    private final Properties info;
    private long serverThreadId;
    public boolean moreResults = false;
    public boolean hasWarnings = false;
    public StreamingSelectResult activeResult = null;
    public int datatypeMappingFlags;
    public short serverStatus;
    JDBCUrl jdbcUrl;
    HostAddress currentHost;
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;
    boolean hostFailed;
    long failTimestamp;
    int reconnectCount;
    int queriesSinceFailover;
    private byte serverLanguage;
    private boolean autoReconnect = false;
    private int maxReconnects = 3;
    int retriesAllDown = 120;
    int initialTimeout = 2;
    boolean roundRobinLoadBalance = false;
    int queriesBeforeRetryMaster = 50;
    int secondsBeforeRetryMaster = 30;
    private InputStream localInfileInputStream;

    private SSLSocketFactory getSSLSocketFactory(boolean trustServerCertificate) throws QueryException {
        if (this.info.getProperty("trustServerCertificate") == null && this.info.getProperty("serverSslCert") == null) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] m = new X509TrustManager[]{new MyX509TrustManager(this.info)};
            sslContext.init(null, m, null);
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new QueryException(e.getMessage(), 0, "HY000", e);
        }
    }

    public MySQLProtocol(JDBCUrl url, String username, String password, Properties info) throws QueryException, SQLException {
        String fractionalSeconds = info.getProperty("useFractionalSeconds", "true");
        if ("true".equalsIgnoreCase(fractionalSeconds)) {
            info.setProperty("useFractionalSeconds", "true");
        }
        if ("true".equalsIgnoreCase(info.getProperty("pinGlobalTxToPhysicalConnection", "false"))) {
            info.setProperty("pinGlobalTxToPhysicalConnection", "true");
        }
        this.info = info;
        this.jdbcUrl = url;
        this.database = this.jdbcUrl.getDatabase() == null ? "" : this.jdbcUrl.getDatabase();
        this.username = username == null ? "" : username;
        this.password = password == null ? "" : password;
        String logLevel = info.getProperty("MySQLProtocolLogLevel");
        if (logLevel != null) {
            log.setLevel(Level.parse(logLevel));
        } else {
            log.setLevel(Level.OFF);
        }
        this.setDatatypeMappingFlags();
        this.parseHAOptions();
        this.connect();
    }

    private void parseHAOptions() {
        String s = this.info.getProperty("autoReconnect");
        if (s != null && s.equals("true")) {
            this.autoReconnect = true;
        }
        if ((s = this.info.getProperty("maxReconnects")) != null) {
            this.maxReconnects = Integer.parseInt(s);
        }
        if ((s = this.info.getProperty("queriesBeforeRetryMaster")) != null) {
            this.queriesBeforeRetryMaster = Integer.parseInt(s);
        }
        if ((s = this.info.getProperty("secondsBeforeRetryMaster")) != null) {
            this.secondsBeforeRetryMaster = Integer.parseInt(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(String host, int port) throws QueryException, IOException, SQLException {
        SocketFactory socketFactory = null;
        String socketFactoryName = this.info.getProperty("socketFactory");
        if (socketFactoryName != null) {
            try {
                socketFactory = (SocketFactory)Class.forName(socketFactoryName).newInstance();
            }
            catch (Exception sfex) {
                log.info("Failed to create socket factory " + socketFactoryName);
                socketFactory = SocketFactory.getDefault();
            }
        } else {
            socketFactory = SocketFactory.getDefault();
        }
        String connectTimeoutString = this.info.getProperty("connectTimeout");
        Integer connectTimeout = null;
        if (connectTimeoutString != null) {
            try {
                connectTimeout = Integer.valueOf(connectTimeoutString);
            }
            catch (Exception e) {
                connectTimeout = null;
            }
        }
        if (this.info.getProperty("pipe") != null) {
            this.socket = new NamedPipeSocket(host, this.info.getProperty("pipe"));
        } else if (this.info.getProperty("localSocket") != null) {
            try {
                this.socket = new UnixDomainSocket(this.info.getProperty("localSocket"));
            }
            catch (RuntimeException re) {
                throw new IOException(re.getMessage(), re.getCause());
            }
        } else if (this.info.getProperty("sharedMemory") != null) {
            try {
                this.socket = new SharedMemorySocket(this.info.getProperty("sharedMemory"));
            }
            catch (RuntimeException re) {
                throw new IOException(re.getMessage(), re.getCause());
            }
        } else {
            this.socket = socketFactory.createSocket();
        }
        try {
            String value = this.info.getProperty("tcpNoDelay", "false");
            if (value.equalsIgnoreCase("true")) {
                this.socket.setTcpNoDelay(true);
            }
            if ((value = this.info.getProperty("tcpKeepAlive", "false")).equalsIgnoreCase("true")) {
                this.socket.setKeepAlive(true);
            }
            if ((value = this.info.getProperty("tcpRcvBuf")) != null) {
                this.socket.setReceiveBufferSize(Integer.parseInt(value));
            }
            if ((value = this.info.getProperty("tcpSndBuf")) != null) {
                this.socket.setSendBufferSize(Integer.parseInt(value));
            }
            if ((value = this.info.getProperty("tcpAbortiveClose", "false")).equalsIgnoreCase("true")) {
                this.socket.setSoLinger(true, 0);
            }
        }
        catch (Exception e) {
            log.finest("Failed to set socket option: " + e.getLocalizedMessage());
        }
        String localHost = this.info.getProperty("localSocketAddress");
        if (localHost != null) {
            InetSocketAddress localAddress = new InetSocketAddress(localHost, 0);
            this.socket.bind(localAddress);
        }
        if (!this.socket.isConnected()) {
            InetSocketAddress sockAddr = new InetSocketAddress(host, port);
            if (connectTimeout != null) {
                this.socket.connect(sockAddr, connectTimeout);
            } else {
                this.socket.connect(sockAddr);
            }
        }
        String socketTimeoutString = this.info.getProperty("socketTimeout");
        Integer socketTimeout = null;
        if (socketTimeoutString != null) {
            try {
                socketTimeout = Integer.valueOf(socketTimeoutString);
            }
            catch (Exception e) {
                socketTimeout = null;
            }
        }
        if (socketTimeout != null) {
            this.socket.setSoTimeout(socketTimeout);
        }
        try {
            BufferedInputStream reader = new BufferedInputStream(this.socket.getInputStream(), 32768);
            this.packetFetcher = new SyncPacketFetcher(reader);
            this.writer = new PacketOutputStream(this.socket.getOutputStream());
            RawPacket packet = this.packetFetcher.getRawPacket();
            if (ReadUtil.isErrorPacket(packet)) {
                ((InputStream)reader).close();
                ErrorPacket errorPacket = (ErrorPacket)ResultPacketFactory.createResultPacket(packet);
                throw new QueryException(errorPacket.getMessage());
            }
            MySQLGreetingReadPacket greetingPacket = new MySQLGreetingReadPacket(packet);
            this.serverThreadId = greetingPacket.getServerThreadID();
            this.serverLanguage = greetingPacket.getServerLanguage();
            boolean useCompression = false;
            log.finest("Got greeting packet");
            this.version = greetingPacket.getServerVersion();
            this.parseVersion();
            byte packetSeq = 1;
            int capabilities = 172931;
            if (this.info.getProperty("allowMultiQueries") != null || this.info.getProperty("rewriteBatchedStatements") != null && "true".equalsIgnoreCase(this.info.getProperty("rewriteBatchedStatements"))) {
                capabilities |= 0x10000;
            }
            if (this.info.getProperty("useCompression") != null) {
                capabilities |= 0x20;
                useCompression = true;
            }
            if (this.info.getProperty("interactiveClient") != null) {
                capabilities |= 0x400;
            }
            if (this.database != null && !this.createDB()) {
                capabilities |= 8;
            }
            if (this.info.getProperty("useSSL") != null && (greetingPacket.getServerCapabilities() & 0x800) != 0) {
                AbbreviatedMySQLClientAuthPacket amcap = new AbbreviatedMySQLClientAuthPacket(capabilities |= 0x800);
                amcap.send(this.writer);
                boolean trustServerCertificate = this.info.getProperty("trustServerCertificate") != null;
                SSLSocketFactory f = this.getSSLSocketFactory(trustServerCertificate);
                SSLSocket sslSocket = (SSLSocket)f.createSocket(this.socket, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), false);
                sslSocket.setEnabledProtocols(new String[]{"TLSv1"});
                sslSocket.setUseClientMode(true);
                sslSocket.startHandshake();
                this.socket = sslSocket;
                this.writer = new PacketOutputStream(this.socket.getOutputStream());
                reader = new BufferedInputStream(this.socket.getInputStream(), 32768);
                this.packetFetcher = new SyncPacketFetcher(reader);
                packetSeq = (byte)(packetSeq + 1);
            } else if (this.info.getProperty("useSSL") != null) {
                throw new QueryException("Trying to connect with ssl, but ssl not enabled in the server");
            }
            MySQLClientAuthPacket cap = new MySQLClientAuthPacket(this.username, this.password, this.database, capabilities, this.decideLanguage(), greetingPacket.getSeed(), packetSeq);
            cap.send(this.writer);
            log.finest("Sending auth packet");
            RawPacket rp = this.packetFetcher.getRawPacket();
            if ((rp.getByteBuffer().get(0) & 0xFF) == 254) {
                MySQLClientOldPasswordAuthPacket oldPassPacket = new MySQLClientOldPasswordAuthPacket(this.password, Utils.copyWithLength(greetingPacket.getSeed(), 8), rp.getPacketSeq() + 1);
                oldPassPacket.send(this.writer);
                rp = this.packetFetcher.getRawPacket();
            }
            this.checkErrorPacket(rp);
            ResultPacket resultPacket = ResultPacketFactory.createResultPacket(rp);
            OKPacket ok = (OKPacket)resultPacket;
            this.serverStatus = ok.getServerStatus();
            if (useCompression) {
                this.writer = new PacketOutputStream(new CompressOutputStream(this.socket.getOutputStream()));
                this.packetFetcher = new SyncPacketFetcher(new DecompressInputStream(this.socket.getInputStream()));
            }
            if ((this.serverStatus & 2) == 0) {
                this.executeQuery(new MySQLQuery("set autocommit=1"));
            }
            QueryResult qr = null;
            try {
                qr = (SelectQueryResult)this.executeQuery(new MySQLQuery("show variables like 'max_allowed_packet'"));
                ((SelectQueryResult)qr).next();
                this.setMaxAllowedPacket(((SelectQueryResult)qr).getValueObject(1).getInt());
            }
            finally {
                if (qr != null) {
                    qr.close();
                }
            }
            String sessionVariables = this.info.getProperty("sessionVariables");
            if (sessionVariables != null) {
                this.executeQuery(new MySQLQuery("set session " + sessionVariables));
            }
            if (this.createDB()) {
                String quotedDB = MySQLConnection.quoteIdentifier(this.database);
                this.executeQuery(new MySQLQuery("CREATE DATABASE IF NOT EXISTS " + quotedDB));
                this.executeQuery(new MySQLQuery("USE " + quotedDB));
            }
            this.activeResult = null;
            this.moreResults = false;
            this.hasWarnings = false;
            this.connected = true;
            this.hostFailed = false;
        }
        catch (IOException e) {
            this.ensureClosingSocketOnException();
            throw new QueryException("Could not connect to " + host + ":" + port + ": " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        catch (QueryException queryException) {
            this.ensureClosingSocketOnException();
            throw queryException;
        }
        catch (SQLException sqlException) {
            this.ensureClosingSocketOnException();
            throw sqlException;
        }
    }

    private void ensureClosingSocketOnException() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isServerLanguageUTF8MB4(byte serverLanguage) {
        Byte[] utf8mb4Languages = new Byte[]{(byte)45, (byte)46, (byte)-32, (byte)-31, (byte)-30, (byte)-29, (byte)-28, (byte)-27, (byte)-26, (byte)-25, (byte)-24, (byte)-23, (byte)-22, (byte)-21, (byte)-20, (byte)-19, (byte)-18, (byte)-17, (byte)-16, (byte)-15, (byte)-14, (byte)-13, (byte)-11};
        return Arrays.asList(utf8mb4Languages).contains(serverLanguage);
    }

    private byte decideLanguage() {
        byte result = this.isServerLanguageUTF8MB4(this.serverLanguage) ? (byte)this.serverLanguage : (byte)33;
        return result;
    }

    void checkErrorPacket(RawPacket rp) throws QueryException {
        if (rp.getByteBuffer().get(0) == -1) {
            ErrorPacket ep = new ErrorPacket(rp);
            String message = ep.getMessage();
            throw new QueryException("Could not connect: " + message);
        }
    }

    void readEOFPacket() throws QueryException, IOException {
        RawPacket rp = this.packetFetcher.getRawPacket();
        this.checkErrorPacket(rp);
        ResultPacket resultPacket = ResultPacketFactory.createResultPacket(rp);
        if (resultPacket.getResultType() != ResultPacket.ResultType.EOF) {
            throw new QueryException("Unexpected packet type " + (Object)((Object)resultPacket.getResultType()) + "insted of EOF");
        }
        EOFPacket eof = (EOFPacket)resultPacket;
        this.hasWarnings = eof.getWarningCount() > 0;
        this.serverStatus = eof.getStatusFlags();
    }

    void readOKPacket() throws QueryException, IOException {
        RawPacket rp = this.packetFetcher.getRawPacket();
        this.checkErrorPacket(rp);
        ResultPacket resultPacket = ResultPacketFactory.createResultPacket(rp);
        if (resultPacket.getResultType() != ResultPacket.ResultType.OK) {
            throw new QueryException("Unexpected packet type " + (Object)((Object)resultPacket.getResultType()) + "insted of OK");
        }
        OKPacket ok = (OKPacket)resultPacket;
        this.hasWarnings = ok.getWarnings() > 0;
        this.serverStatus = ok.getServerStatus();
    }

    public PrepareResult prepare(String sql) throws QueryException {
        try {
            this.writer.startPacket(0);
            this.writer.write(22);
            this.writer.write(sql.getBytes("UTF8"));
            this.writer.finishPacket();
            RawPacket rp = this.packetFetcher.getRawPacket();
            this.checkErrorPacket(rp);
            byte b = rp.getByteBuffer().get(0);
            if (b == 0) {
                Reader r = new Reader(rp);
                r.readByte();
                int statementId = r.readInt();
                int numColumns = r.readShort();
                int numParams = r.readShort();
                r.readByte();
                this.hasWarnings = r.readShort() > 0;
                MySQLColumnInformation[] params = new MySQLColumnInformation[numParams];
                if (numParams > 0) {
                    for (int i = 0; i < numParams; ++i) {
                        params[i] = new MySQLColumnInformation(this.packetFetcher.getRawPacket());
                    }
                    this.readEOFPacket();
                }
                MySQLColumnInformation[] columns = new MySQLColumnInformation[numColumns];
                if (numColumns > 0) {
                    for (int i = 0; i < numColumns; ++i) {
                        columns[i] = new MySQLColumnInformation(this.packetFetcher.getRawPacket());
                    }
                    this.readEOFPacket();
                }
                return new PrepareResult(statementId, columns, params);
            }
            throw new QueryException("Unexpected packet returned by server, first byte " + b);
        }
        catch (IOException e) {
            throw new QueryException(e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    public synchronized void closePreparedStatement(int statementId) throws QueryException {
        try {
            this.writer.startPacket(0);
            this.writer.write(25);
            this.writer.write(statementId);
            this.writer.finishPacket();
        }
        catch (IOException e) {
            throw new QueryException(e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    public void setHostFailed() {
        this.hostFailed = true;
        this.failTimestamp = System.currentTimeMillis();
    }

    public boolean shouldReconnect() {
        return !this.inTransaction() && this.hostFailed && this.autoReconnect && this.reconnectCount < this.maxReconnects;
    }

    public boolean getAutocommit() {
        return (this.serverStatus & 2) != 0;
    }

    public boolean noBackslashEscapes() {
        return (this.serverStatus & 0x200) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnectToMaster() throws IOException, QueryException, SQLException {
        SyncPacketFetcher saveFetcher = this.packetFetcher;
        PacketOutputStream saveWriter = this.writer;
        Socket saveSocket = this.socket;
        HostAddress[] addrs = this.jdbcUrl.getHostAddresses();
        boolean success = false;
        try {
            this.connect(addrs[0].host, addrs[0].port);
            try {
                MySQLProtocol.close(saveFetcher, saveWriter, saveSocket);
            }
            catch (Exception exception) {
                // empty catch block
            }
            success = true;
        }
        finally {
            if (!success) {
                this.failTimestamp = System.currentTimeMillis();
                this.queriesSinceFailover = 0;
                this.packetFetcher = saveFetcher;
                this.writer = saveWriter;
                this.socket = saveSocket;
            }
        }
    }

    public void connect() throws QueryException, SQLException {
        if (!this.isClosed()) {
            this.close();
        }
        HostAddress[] addrs = this.jdbcUrl.getHostAddresses();
        for (int i = 0; i < addrs.length; ++i) {
            this.currentHost = addrs[i];
            try {
                this.connect(this.currentHost.host, this.currentHost.port);
                return;
            }
            catch (IOException e) {
                if (i != addrs.length - 1) continue;
                throw new QueryException("Could not connect to " + HostAddress.toString(addrs) + " : " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
    }

    public boolean isMasterConnection() {
        return this.currentHost == this.jdbcUrl.getHostAddresses()[0];
    }

    public boolean shouldTryFailback() {
        if (this.isMasterConnection()) {
            return false;
        }
        if (this.inTransaction()) {
            return false;
        }
        if (this.reconnectCount >= this.maxReconnects) {
            return false;
        }
        long now = System.currentTimeMillis();
        if ((now - this.failTimestamp) / 1000L > (long)this.secondsBeforeRetryMaster) {
            return true;
        }
        return this.queriesSinceFailover > this.queriesBeforeRetryMaster;
    }

    public boolean inTransaction() {
        return (this.serverStatus & 1) != 0;
    }

    private void setDatatypeMappingFlags() {
        this.datatypeMappingFlags = 0;
        String tinyInt1isBit = this.info.getProperty("tinyInt1isBit");
        String yearIsDateType = this.info.getProperty("yearIsDateType");
        if (tinyInt1isBit == null || tinyInt1isBit.equals("1") || tinyInt1isBit.equals("true")) {
            this.datatypeMappingFlags |= 1;
        }
        if (yearIsDateType == null || yearIsDateType.equals("1") || yearIsDateType.equals("true")) {
            this.datatypeMappingFlags |= 2;
        }
    }

    public Properties getInfo() {
        return this.info;
    }

    void skip() throws IOException, QueryException {
        if (this.activeResult != null) {
            this.activeResult.close();
        }
        while (this.moreResults) {
            this.getMoreResults(true);
        }
    }

    public boolean hasMoreResults() {
        return this.moreResults;
    }

    private static void close(PacketFetcher fetcher, PacketOutputStream packetOutputStream, Socket socket) throws QueryException {
        ClosePacket closePacket = new ClosePacket();
        try {
            try {
                closePacket.send(packetOutputStream);
                socket.shutdownOutput();
                socket.setSoTimeout(3);
                InputStream is = socket.getInputStream();
                while (is.read() != -1) {
                }
            }
            catch (Throwable is) {
                // empty catch block
            }
            packetOutputStream.close();
            fetcher.close();
        }
        catch (IOException e) {
            throw new QueryException("Could not close connection: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                log.warning("Could not close socket");
            }
        }
    }

    public void close() {
        try {
            this.skip();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            MySQLProtocol.close(this.packetFetcher, this.writer, this.socket);
        }
        catch (Exception e) {
            log.info("got exception " + e + " while closing connection");
        }
        finally {
            this.connected = false;
        }
    }

    public boolean isClosed() {
        return !this.connected;
    }

    private SelectQueryResult createQueryResult(ResultSetPacket packet, boolean streaming) throws IOException, QueryException {
        StreamingSelectResult streamingResult = StreamingSelectResult.createStreamingSelectResult(packet, this.packetFetcher, this);
        if (streaming) {
            return streamingResult;
        }
        return CachedSelectResult.createCachedSelectResult(streamingResult);
    }

    public void selectDB(String database) throws QueryException {
        log.finest("Selecting db " + database);
        SelectDBPacket packet = new SelectDBPacket(database);
        try {
            packet.send(this.writer);
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            ResultPacketFactory.createResultPacket(rawPacket);
        }
        catch (IOException e) {
            throw new QueryException("Could not select database: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        this.database = database;
    }

    public String getServerVersion() {
        return this.version;
    }

    public void setReadonly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getReadonly() {
        return this.readOnly;
    }

    public String getHost() {
        return this.currentHost.host;
    }

    public int getPort() {
        return this.currentHost.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean ping() throws QueryException {
        MySQLPingPacket pingPacket = new MySQLPingPacket();
        try {
            pingPacket.send(this.writer);
            log.finest("Sent ping packet");
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            return ResultPacketFactory.createResultPacket(rawPacket).getResultType() == ResultPacket.ResultType.OK;
        }
        catch (IOException e) {
            throw new QueryException("Could not ping: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    public QueryResult executeQuery(Query dQuery) throws QueryException, SQLException {
        return this.executeQuery(dQuery, false);
    }

    public QueryResult getResult(List<Query> dQueries, boolean streaming) throws QueryException {
        ResultPacket resultPacket;
        try {
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            resultPacket = ResultPacketFactory.createResultPacket(rawPacket);
            if (resultPacket.getResultType() == ResultPacket.ResultType.LOCALINFILE) {
                InputStream is;
                if (this.localInfileInputStream == null) {
                    LocalInfilePacket localInfilePacket = (LocalInfilePacket)resultPacket;
                    log.fine("sending local file " + localInfilePacket.getFileName());
                    String localInfile = localInfilePacket.getFileName();
                    try {
                        URL u = new URL(localInfile);
                        is = u.openStream();
                    }
                    catch (IOException ioe) {
                        is = new FileInputStream(localInfile);
                    }
                } else {
                    is = this.localInfileInputStream;
                    this.localInfileInputStream = null;
                }
                this.writer.sendFile(is, rawPacket.getPacketSeq() + 1);
                is.close();
                rawPacket = this.packetFetcher.getRawPacket();
                resultPacket = ResultPacketFactory.createResultPacket(rawPacket);
            }
        }
        catch (SocketTimeoutException ste) {
            this.close();
            throw new QueryException("Could not read resultset: " + ste.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), ste);
        }
        catch (IOException e) {
            throw new QueryException("Could not read resultset: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        switch (resultPacket.getResultType()) {
            case ERROR: {
                this.moreResults = false;
                this.hasWarnings = false;
                ErrorPacket ep = (ErrorPacket)resultPacket;
                if (dQueries != null && dQueries.size() == 1) {
                    log.warning("Could not execute query " + dQueries.get(0) + ": " + ((ErrorPacket)resultPacket).getMessage());
                } else {
                    log.warning("Got error from server: " + ((ErrorPacket)resultPacket).getMessage());
                }
                throw new QueryException(ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
            }
            case OK: {
                OKPacket okpacket = (OKPacket)resultPacket;
                this.serverStatus = okpacket.getServerStatus();
                this.moreResults = (this.serverStatus & 8) != 0;
                this.hasWarnings = okpacket.getWarnings() > 0;
                UpdateResult updateResult = new UpdateResult(okpacket.getAffectedRows(), okpacket.getWarnings(), okpacket.getMessage(), okpacket.getInsertId());
                log.fine("OK, " + okpacket.getAffectedRows());
                return updateResult;
            }
            case RESULTSET: {
                this.hasWarnings = false;
                log.fine("SELECT executed, fetching result set");
                ResultSetPacket resultSetPacket = (ResultSetPacket)resultPacket;
                try {
                    return this.createQueryResult(resultSetPacket, streaming);
                }
                catch (IOException e) {
                    throw new QueryException("Could not read result set: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
                }
            }
        }
        log.severe("Could not parse result..." + (Object)((Object)resultPacket.getResultType()));
        throw new QueryException("Could not parse result", -1, SQLExceptionMapper.SQLStates.INTERRUPTED_EXCEPTION.getSqlState());
    }

    public QueryResult executeQuery(Query query, boolean streaming) throws QueryException, SQLException {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(query);
        return this.executeQuery(queries, streaming, false, 0);
    }

    public QueryResult executeQuery(List<Query> dQueries, boolean streaming, boolean isRewritable, int rewriteOffset) throws QueryException, SQLException {
        for (Query query : dQueries) {
            query.validate();
        }
        this.moreResults = false;
        StreamedQueryPacket packet = new StreamedQueryPacket(dQueries, isRewritable, rewriteOffset);
        try {
            packet.send(this.writer);
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.INTERRUPTED_EXCEPTION.getSqlState(), e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        if (!this.isMasterConnection()) {
            ++this.queriesSinceFailover;
        }
        try {
            return this.getResult(dQueries, streaming);
        }
        catch (QueryException qex) {
            if (qex.getCause() instanceof SocketTimeoutException) {
                this.close();
                throw SQLExceptionMapper.getSQLException("Connection timed out");
            }
            throw qex;
        }
    }

    public String getServerVariable(String variable) throws QueryException, SQLException {
        CachedSelectResult qr = (CachedSelectResult)this.executeQuery(new MySQLQuery("select @@" + variable));
        try {
            if (!qr.next()) {
                throw new QueryException("Could not get variable: " + variable);
            }
        }
        catch (IOException ioe) {
            throw new QueryException(ioe.getMessage(), 0, "HYOOO", ioe);
        }
        try {
            String value = qr.getValueObject(0).getString();
            return value;
        }
        catch (NoSuchColumnException e) {
            throw new QueryException("Could not get variable: " + variable);
        }
    }

    public void cancelCurrentQuery() throws QueryException, IOException, SQLException {
        MySQLProtocol copiedProtocol = new MySQLProtocol(this.jdbcUrl, this.username, this.password, this.info);
        copiedProtocol.executeQuery(new MySQLQuery("KILL QUERY " + this.serverThreadId));
        copiedProtocol.close();
    }

    public boolean createDB() {
        String alias = this.info.getProperty("createDatabaseIfNotExist");
        return this.info != null && (this.info.getProperty("createDB", "").equalsIgnoreCase("true") || alias != null && alias.equalsIgnoreCase("true"));
    }

    public QueryResult getMoreResults(boolean streaming) throws QueryException {
        if (!this.moreResults) {
            return null;
        }
        return this.getResult(null, streaming);
    }

    public static String hexdump(byte[] buffer, int offset) {
        StringBuffer dump = new StringBuffer();
        if (buffer.length - offset > 0) {
            dump.append(String.format("%02x", buffer[offset]));
            for (int i = offset + 1; i < buffer.length; ++i) {
                dump.append(String.format("%02x", buffer[i]));
            }
        }
        return dump.toString();
    }

    public static String hexdump(ByteBuffer bb, int offset) {
        byte[] b = new byte[bb.remaining()];
        bb.mark();
        bb.get(b);
        bb.reset();
        return MySQLProtocol.hexdump(b, offset);
    }

    public boolean hasUnreadData() {
        return this.activeResult != null;
    }

    public void setMaxRows(int max) throws QueryException, SQLException {
        if (this.maxRows != max) {
            if (max == 0) {
                this.executeQuery(new MySQLQuery("set @@SQL_SELECT_LIMIT=DEFAULT"));
            } else {
                this.executeQuery(new MySQLQuery("set @@SQL_SELECT_LIMIT=" + max));
            }
            this.maxRows = max;
        }
    }

    void parseVersion() {
        String[] a = this.version.split("[^0-9]");
        if (a.length > 0) {
            this.majorVersion = Integer.parseInt(a[0]);
        }
        if (a.length > 1) {
            this.minorVersion = Integer.parseInt(a[1]);
        }
        if (a.length > 2) {
            this.patchVersion = Integer.parseInt(a[2]);
        }
    }

    public int getMajorServerVersion() {
        return this.majorVersion;
    }

    public int getMinorServerVersion() {
        return this.minorVersion;
    }

    public boolean versionGreaterOrEqual(int major, int minor, int patch) {
        if (this.majorVersion > major) {
            return true;
        }
        if (this.majorVersion < major) {
            return false;
        }
        if (this.minorVersion > minor) {
            return true;
        }
        if (this.minorVersion < minor) {
            return false;
        }
        if (this.patchVersion > patch) {
            return true;
        }
        return this.patchVersion >= patch;
    }

    public void setLocalInfileInputStream(InputStream inputStream) {
        this.localInfileInputStream = inputStream;
    }

    public void setMaxAllowedPacket(int maxAllowedPacket) {
        this.writer.setMaxAllowedPacket(maxAllowedPacket);
    }

    public void setTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public int getTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public String getPinGlobalTxToPhysicalConnection() {
        return this.info.getProperty("pinGlobalTxToPhysicalConnection", "false");
    }

    public class PrepareResult {
        public int statementId;
        public MySQLColumnInformation[] columns;
        public MySQLColumnInformation[] parameters;

        public PrepareResult(int statementId, MySQLColumnInformation[] columns, MySQLColumnInformation[] parameters) {
            this.statementId = statementId;
            this.columns = columns;
            this.parameters = parameters;
        }
    }
}

