/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.mysql.HandleErrorResult;
import org.mariadb.jdbc.internal.mysql.listener.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverProxy
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(FailoverProxy.class);
    public static final String METHOD_IS_EXPLICIT_CLOSED = "isExplicitClosed";
    public static final String METHOD_GET_OPTIONS = "getOptions";
    public static final String METHOD_GET_PROXY = "getProxy";
    public static final String METHOD_EXECUTE_QUERY = "executeQuery";
    public static final String METHOD_SET_READ_ONLY = "setReadonly";
    public static final String METHOD_IS_READ_ONLY = "isReadOnly";
    public static final String METHOD_CLOSED_EXPLICIT = "closeExplicit";
    public static final String METHOD_IS_CLOSED = "isClosed";
    public final ReentrantReadWriteLock lock;
    private Listener listener;

    public FailoverProxy(Listener listener, ReentrantReadWriteLock lock) throws QueryException, SQLException {
        this.lock = lock;
        this.listener = listener;
        this.listener.setProxy(this);
        this.listener.initializeConnection();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "isExplicitClosed": {
                return this.listener.isExplicitClosed();
            }
            case "getOptions": {
                return this.listener.getJdbcUrl().getOptions();
            }
            case "getProxy": {
                return this;
            }
            case "isClosed": {
                return this.listener.isClosed();
            }
            case "executeQuery": {
                try {
                    this.listener.preExecute();
                    break;
                }
                catch (QueryException e) {
                    return this.handleFailOver(e, method, args);
                }
            }
            case "setReadonly": {
                this.listener.switchReadOnlyConnection((Boolean)args[0]);
                return null;
            }
            case "isReadOnly": {
                return this.listener.isReadOnly();
            }
            case "closeExplicit": {
                this.listener.preClose();
                return null;
            }
        }
        try {
            return this.listener.invoke(method, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof QueryException && this.hasToHandleFailover((QueryException)e.getTargetException())) {
                    return this.handleFailOver((QueryException)e.getTargetException(), method, args);
                }
                throw e.getTargetException();
            }
            throw e;
        }
    }

    private Object handleFailOver(QueryException qe, Method method, Object[] args) throws Throwable {
        HandleErrorResult handleErrorResult = this.listener.handleFailover(method, args);
        if (handleErrorResult.mustThrowError) {
            this.listener.throwFailoverMessage(qe, handleErrorResult.isReconnected);
        }
        return handleErrorResult.resultObject;
    }

    public boolean hasToHandleFailover(QueryException e) {
        return e.getSqlState() != null && e.getSqlState().startsWith("08");
    }

    public void reconnect() throws SQLException {
        try {
            this.listener.reconnect();
        }
        catch (QueryException e) {
            SQLExceptionMapper.throwException(e, null, null);
        }
    }

    public Listener getListener() {
        return this.listener;
    }
}

