/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.UrlHAMode;
import org.mariadb.jdbc.internal.mysql.AuroraProtocol;
import org.mariadb.jdbc.internal.mysql.FailoverProxy;
import org.mariadb.jdbc.internal.mysql.MastersSlavesProtocol;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;
import org.mariadb.jdbc.internal.mysql.Protocol;
import org.mariadb.jdbc.internal.mysql.listener.impl.AuroraListener;
import org.mariadb.jdbc.internal.mysql.listener.impl.MastersFailoverListener;
import org.mariadb.jdbc.internal.mysql.listener.impl.MastersSlavesListener;

public class Utils {
    public static List<String> createQueryParts(String queryString, boolean noBackslashEscapes) {
        ArrayList<String> list = new ArrayList<String>();
        LexState state = LexState.Normal;
        char lastChar = '\u0000';
        StringBuffer sb = new StringBuffer();
        boolean singleQuotes = false;
        boolean isParam = false;
        char[] query = queryString.toCharArray();
        for (int i = 0; i < query.length; ++i) {
            if (state == LexState.Escape) {
                sb.append(query[i]);
                state = LexState.String;
                continue;
            }
            char c = query[i];
            switch (c) {
                case '*': {
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case '/': {
                    if (state == LexState.SlashStarComment && lastChar == '*') {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '#': {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != LexState.Normal || lastChar != '-') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '\n': {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case '\"': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state != LexState.String || singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case '\'': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state != LexState.String || !singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case '?': {
                    if (state != LexState.Normal) break;
                    isParam = true;
                    break;
                }
                case '`': {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                }
            }
            lastChar = c;
            if (isParam) {
                list.add(sb.toString());
                sb.setLength(0);
                isParam = false;
                continue;
            }
            sb.append(c);
        }
        list.add(sb.toString());
        return list;
    }

    public static String escapeString(String s, boolean noBackslashEscapes) {
        if (s.indexOf("'") == -1) {
            if (noBackslashEscapes) {
                return s;
            }
            if (s.indexOf("\\") == -1) {
                return s;
            }
        }
        String escaped = s.replace("'", "''");
        if (noBackslashEscapes) {
            return escaped;
        }
        return escaped.replace("\\", "\\\\");
    }

    public static byte[] encryptPassword(String password, byte[] seed) throws NoSuchAlgorithmException {
        if (password == null || password.equals("")) {
            return new byte[0];
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] stage1 = messageDigest.digest(password.getBytes());
        messageDigest.reset();
        byte[] stage2 = messageDigest.digest(stage1);
        messageDigest.reset();
        messageDigest.update(seed);
        messageDigest.update(stage2);
        byte[] digest = messageDigest.digest();
        byte[] returnBytes = new byte[digest.length];
        for (int i = 0; i < digest.length; ++i) {
            returnBytes[i] = (byte)(stage1[i] ^ digest[i]);
        }
        return returnBytes;
    }

    public static byte[] copyWithLength(byte[] orig, int length) {
        byte[] result = new byte[length];
        int howMuchToCopy = length < orig.length ? length : orig.length;
        System.arraycopy(orig, 0, result, 0, howMuchToCopy);
        return result;
    }

    public static byte[] copyRange(byte[] orig, int from, int to) {
        int length = to - from;
        byte[] result = new byte[length];
        int howMuchToCopy = orig.length - from < length ? orig.length - from : length;
        System.arraycopy(orig, from, result, 0, howMuchToCopy);
        return result;
    }

    public static String replaceFunctionParameter(String s) {
        int i;
        if (!s.contains("SQL_")) {
            return s;
        }
        char[] input = s.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < input.length && input[i] == ' '; ++i) {
        }
        while ((input[i] >= 'a' && i <= 122 || input[i] >= 'A' && input[i] <= 'Z') && i < input.length) {
            sb.append(input[i]);
            ++i;
        }
        String func = sb.toString().toLowerCase();
        if (func.equals("convert") || func.equals("timestampdiff") || func.equals("timestampadd")) {
            if (func.equals("timestampdiff") || func.equals("timestampadd")) {
                while (i < input.length && (Character.isWhitespace(input[i]) || input[i] == '(')) {
                    ++i;
                }
                if (i == input.length) {
                    return new String(input);
                }
                if (i >= input.length - 8) {
                    return new String(input);
                }
                String paramPrefix = new String(input, i, 8);
                if (paramPrefix.equals("SQL_TSI_")) {
                    return new String(input, 0, i) + new String(input, i + 8, input.length - (i + 8));
                }
                return new String(input);
            }
            int lastCommaIndex = s.lastIndexOf(44);
            for (i = lastCommaIndex + 1; i < input.length && Character.isWhitespace(input[i]); ++i) {
            }
            if (i >= input.length - 4) {
                return new String(input);
            }
            String paramPrefix = new String(input, i, 4);
            if (paramPrefix.equals("SQL_")) {
                return new String(input, 0, i) + new String(input, i + 4, input.length - (i + 4));
            }
        }
        return new String(input);
    }

    private static String resolveEscapes(String escaped, boolean noBackslashEscapes) throws SQLException {
        if (escaped.charAt(0) != '{' || escaped.charAt(escaped.length() - 1) != '}') {
            throw new SQLException("unexpected escaped string");
        }
        int endIndex = escaped.length() - 1;
        String escapedLower = escaped.toLowerCase();
        if (escaped.startsWith("{fn ")) {
            String resolvedParams = Utils.replaceFunctionParameter(escaped.substring(4, endIndex));
            return Utils.nativeSQL(resolvedParams, noBackslashEscapes);
        }
        if (escapedLower.startsWith("{oj ")) {
            return Utils.nativeSQL(escaped.substring(4, endIndex), noBackslashEscapes);
        }
        if (escaped.startsWith("{d ")) {
            return escaped.substring(3, endIndex);
        }
        if (escaped.startsWith("{t ")) {
            return escaped.substring(3, endIndex);
        }
        if (escaped.startsWith("{ts ")) {
            return escaped.substring(4, endIndex);
        }
        if (escaped.startsWith("{d'")) {
            return escaped.substring(2, endIndex);
        }
        if (escaped.startsWith("{t'")) {
            return escaped.substring(2, endIndex);
        }
        if (escaped.startsWith("{ts'")) {
            return escaped.substring(3, endIndex);
        }
        if (escaped.startsWith("{call ") || escaped.startsWith("{CALL ")) {
            return Utils.nativeSQL(escaped.substring(1, endIndex), noBackslashEscapes);
        }
        if (escaped.startsWith("{escape ")) {
            return escaped.substring(1, endIndex);
        }
        if (escaped.startsWith("{?")) {
            return Utils.nativeSQL(escaped.substring(1, endIndex), noBackslashEscapes);
        }
        if (escaped.startsWith("{ ")) {
            for (int i = 2; i < escaped.length(); ++i) {
                if (Character.isWhitespace(escaped.charAt(i))) continue;
                return Utils.resolveEscapes("{" + escaped.substring(i), noBackslashEscapes);
            }
        }
        throw new SQLException("unknown escape sequence " + escaped);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String nativeSQL(String sql, boolean noBackslashEscapes) throws SQLException {
        if (sql.indexOf(123) == -1) {
            return sql;
        }
        StringBuffer escapeSequenceBuf = new StringBuffer();
        StringBuffer sqlBuffer = new StringBuffer();
        char[] a = sql.toCharArray();
        char lastChar = '\u0000';
        boolean inQuote = false;
        char quoteChar = '\u0000';
        boolean inComment = false;
        boolean isSlashSlashComment = false;
        int inEscapeSeq = 0;
        block9: for (int i = 0; i < a.length; ++i) {
            char c = a[i];
            if (lastChar == '\\' && !noBackslashEscapes) {
                sqlBuffer.append(c);
                continue;
            }
            switch (c) {
                case '\"': 
                case '\'': {
                    if (inComment) break;
                    if (inQuote) {
                        if (quoteChar != c) break;
                        inQuote = false;
                        break;
                    }
                    inQuote = true;
                    quoteChar = c;
                    break;
                }
                case '*': {
                    if (inQuote || inComment || lastChar != 47) break;
                    inComment = true;
                    isSlashSlashComment = false;
                    break;
                }
                case '-': 
                case '/': {
                    if (inQuote) break;
                    if (inComment) {
                        if (lastChar == '*' && !isSlashSlashComment) {
                            inComment = false;
                            break;
                        }
                        if (lastChar != c || !isSlashSlashComment) break;
                        inComment = false;
                        break;
                    }
                    if (lastChar == c) {
                        inComment = true;
                        isSlashSlashComment = true;
                        break;
                    }
                    if (lastChar != 42) break;
                    inComment = true;
                    isSlashSlashComment = false;
                    break;
                }
                case 'S': {
                    if (inQuote || inComment || inEscapeSeq <= 0 || i + 4 >= a.length || a[i + 1] != 'Q' || a[i + 2] != 'L' || a[i + 3] != 'L' || a[i + 4] != '_') break;
                    if (i + 8 < a.length && a[i + 5] == 'T' && a[i + 6] == 'S' && a[i + 7] == 'I' && a[i + 8] == '_') {
                        i += 8;
                        continue block9;
                    }
                    i += 4;
                    continue block9;
                }
                case '\n': {
                    if (!inComment || !isSlashSlashComment) break;
                    inComment = false;
                    break;
                }
                case '{': {
                    if (inQuote || inComment) break;
                    ++inEscapeSeq;
                    break;
                }
                case '}': {
                    if (inQuote || inComment || --inEscapeSeq != 0) break;
                    escapeSequenceBuf.append(c);
                    sqlBuffer.append(Utils.resolveEscapes(escapeSequenceBuf.toString(), noBackslashEscapes));
                    escapeSequenceBuf.setLength(0);
                    continue block9;
                }
            }
            lastChar = c;
            if (inEscapeSeq > 0) {
                escapeSequenceBuf.append(c);
                continue;
            }
            sqlBuffer.append(c);
        }
        if (inEscapeSeq > 0) {
            throw new SQLException("Invalid escape sequence , missing closing '}' character in '" + sqlBuffer);
        }
        return sqlBuffer.toString();
    }

    public static Protocol retrieveProxy(JDBCUrl jdbcUrl, ReentrantReadWriteLock lock) throws QueryException, SQLException {
        if (jdbcUrl.getHaMode().equals((Object)UrlHAMode.AURORA)) {
            return (Protocol)Proxy.newProxyInstance(AuroraProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new AuroraListener(jdbcUrl), lock));
        }
        if (jdbcUrl.getHaMode().equals((Object)UrlHAMode.REPLICATION)) {
            return (Protocol)Proxy.newProxyInstance(MastersSlavesProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new MastersSlavesListener(jdbcUrl), lock));
        }
        if (jdbcUrl.getHaMode().equals((Object)UrlHAMode.FAILOVER) || jdbcUrl.getHaMode().equals((Object)UrlHAMode.SEQUENTIAL)) {
            return (Protocol)Proxy.newProxyInstance(MySQLProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new MastersFailoverListener(jdbcUrl), lock));
        }
        MySQLProtocol protocol = new MySQLProtocol(jdbcUrl, lock);
        protocol.connectWithoutProxy();
        return protocol;
    }

    public static TimeZone getTimeZone(String id) throws SQLException {
        TimeZone tz = TimeZone.getTimeZone(id);
        if (tz.getID().equals("GMT") && !id.equals("GMT")) {
            throw new SQLException("invalid timezone id '" + id + "'");
        }
        return tz;
    }

    static enum LexState {
        Normal,
        String,
        SlashStarComment,
        Escape,
        Parameter,
        EOLComment,
        Backtick;

    }
}

