/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql.listener.impl;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.mysql.HandleErrorResult;
import org.mariadb.jdbc.internal.mysql.MastersSlavesProtocol;
import org.mariadb.jdbc.internal.mysql.Protocol;
import org.mariadb.jdbc.internal.mysql.listener.AbstractMastersSlavesListener;
import org.mariadb.jdbc.internal.mysql.listener.tools.SearchFilter;

public class MastersSlavesListener
extends AbstractMastersSlavesListener {
    protected Protocol masterProtocol = null;
    protected Protocol secondaryProtocol = null;
    protected long lastQueryTime = System.currentTimeMillis();
    protected ScheduledFuture scheduledPing = null;

    public MastersSlavesListener(JDBCUrl jdbcUrl) {
        super(jdbcUrl);
    }

    @Override
    public void initializeConnection() throws QueryException {
        if (this.jdbcUrl.getOptions().validConnectionTimeout != 0) {
            this.scheduledPing = this.executorService.scheduleWithFixedDelay(new PingLoop(this), this.jdbcUrl.getOptions().validConnectionTimeout, this.jdbcUrl.getOptions().validConnectionTimeout, TimeUnit.SECONDS);
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, true, true));
        }
        catch (QueryException e) {
            this.checkInitialConnection();
            this.throwFailoverMessage(e, false);
        }
    }

    protected void checkInitialConnection() {
        if (this.masterProtocol != null && !this.masterProtocol.isConnected()) {
            this.setMasterHostFail();
        }
        if (this.secondaryProtocol != null && !this.secondaryProtocol.isConnected()) {
            this.setSecondaryHostFail();
        }
        this.launchFailLoopIfNotlaunched(false);
    }

    @Override
    public void preClose() throws SQLException {
        this.setExplicitClosed(true);
        this.proxy.lock.writeLock().lock();
        try {
            if (this.masterProtocol != null && this.masterProtocol.isConnected()) {
                this.masterProtocol.close();
            }
            if (this.secondaryProtocol != null && this.secondaryProtocol.isConnected()) {
                this.secondaryProtocol.close();
            }
        }
        finally {
            this.proxy.lock.writeLock().unlock();
            if (this.scheduledPing != null) {
                this.scheduledPing.cancel(true);
            }
            if (this.scheduledFailover != null) {
                this.scheduledFailover.cancel(true);
                this.isLooping.set(false);
            }
            this.executorService.shutdownNow();
            try {
                this.executorService.awaitTermination(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void preExecute() throws QueryException {
        if (this.currentProtocol != null && (this.currentProtocol.isClosed() || !this.currentReadOnlyAsked.get() && !this.currentProtocol.isMasterConnection())) {
            this.queriesSinceFailover.incrementAndGet();
            if (!this.isExplicitClosed() && this.jdbcUrl.getOptions().autoReconnect) {
                try {
                    this.reconnectFailedConnection(new SearchFilter(this.isMasterHostFail(), this.isSecondaryHostFail(), !this.currentReadOnlyAsked.get(), this.currentReadOnlyAsked.get()));
                }
                catch (QueryException queryException) {}
            } else {
                throw new QueryException("Connection is closed", -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState());
            }
        }
        if (this.isMasterHostFail() || this.isSecondaryHostFail()) {
            this.queriesSinceFailover.incrementAndGet();
        }
        if (this.jdbcUrl.getOptions().validConnectionTimeout != 0) {
            this.lastQueryTime = System.currentTimeMillis();
        }
    }

    @Override
    public boolean shouldReconnect() {
        if (this.isMasterHostFail() || this.isSecondaryHostFail()) {
            if (this.currentConnectionAttempts.get() > this.jdbcUrl.getOptions().retriesAllDown) {
                return false;
            }
            long now = System.currentTimeMillis();
            if (this.isMasterHostFail()) {
                if (this.jdbcUrl.getOptions().queriesBeforeRetryMaster > 0 && this.queriesSinceFailover.get() >= this.jdbcUrl.getOptions().queriesBeforeRetryMaster) {
                    return true;
                }
                if (this.jdbcUrl.getOptions().secondsBeforeRetryMaster > 0 && now - this.getMasterHostFailTimestamp() >= (long)(this.jdbcUrl.getOptions().secondsBeforeRetryMaster * 1000)) {
                    return true;
                }
            }
            if (this.isSecondaryHostFail() && this.jdbcUrl.getOptions().secondsBeforeRetryMaster > 0 && now - this.getSecondaryHostFailTimestamp() >= (long)(this.jdbcUrl.getOptions().secondsBeforeRetryMaster * 1000)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) throws QueryException {
        this.currentConnectionAttempts.incrementAndGet();
        this.resetOldsBlackListHosts();
        LinkedList<HostAddress> loopAddress = new LinkedList<HostAddress>(this.jdbcUrl.getHostAddresses());
        loopAddress.removeAll(blacklist.keySet());
        Collections.shuffle(loopAddress);
        LinkedList blacklistShuffle = new LinkedList(blacklist.keySet());
        Collections.shuffle(blacklistShuffle);
        loopAddress.addAll(blacklistShuffle);
        if (this.masterProtocol != null && !this.isMasterHostFail()) {
            loopAddress.remove(this.masterProtocol.getHostAddress());
        }
        if (this.secondaryProtocol != null && !this.isSecondaryHostFail()) {
            loopAddress.remove(this.secondaryProtocol.getHostAddress());
        }
        if (searchFilter.isSearchForMaster() && this.isMasterHostFail() || searchFilter.isSearchForSlave() && this.isSecondaryHostFail() || searchFilter.isInitialConnection()) {
            MastersSlavesProtocol.loop(this, loopAddress, (Map<HostAddress, Long>)blacklist, searchFilter);
        }
    }

    @Override
    public void foundActiveMaster(Protocol newMasterProtocol) {
        if (this.isExplicitClosed()) {
            newMasterProtocol.close();
            return;
        }
        this.proxy.lock.writeLock().lock();
        try {
            if (this.masterProtocol != null && !this.masterProtocol.isClosed()) {
                this.masterProtocol.close();
            }
            this.masterProtocol = (MastersSlavesProtocol)newMasterProtocol;
            if (!this.currentReadOnlyAsked.get() || this.isSecondaryHostFail()) {
                try {
                    this.syncConnection(this.currentProtocol, this.masterProtocol);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.currentProtocol = this.masterProtocol;
            }
            this.resetMasterFailoverData();
            if (!this.isSecondaryHostFail()) {
                this.stopFailover();
            }
        }
        finally {
            this.proxy.lock.writeLock().unlock();
        }
    }

    @Override
    public void foundActiveSecondary(Protocol newSecondaryProtocol) throws QueryException {
        if (this.isExplicitClosed()) {
            newSecondaryProtocol.close();
            return;
        }
        this.proxy.lock.writeLock().lock();
        try {
            if (this.secondaryProtocol != null && !this.secondaryProtocol.isClosed()) {
                this.secondaryProtocol.close();
            }
            this.secondaryProtocol = newSecondaryProtocol;
            if (this.currentReadOnlyAsked.get() || this.jdbcUrl.getOptions().failOnReadOnly && !this.currentReadOnlyAsked.get() && this.isMasterHostFail()) {
                try {
                    this.syncConnection(this.currentProtocol, this.secondaryProtocol);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.currentProtocol = this.secondaryProtocol;
            }
            if (this.jdbcUrl.getOptions().assureReadOnly) {
                this.setSessionReadOnly(true, this.secondaryProtocol);
            }
            this.resetSecondaryFailoverData();
            if (!this.isMasterHostFail()) {
                this.stopFailover();
            }
        }
        finally {
            this.proxy.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchReadOnlyConnection(Boolean mustBeReadOnly) throws QueryException {
        if (mustBeReadOnly.booleanValue() != this.currentReadOnlyAsked.get() && this.currentProtocol.inTransaction()) {
            throw new QueryException("Trying to set to read-only mode during a transaction");
        }
        if (this.currentReadOnlyAsked.compareAndSet(mustBeReadOnly == false, mustBeReadOnly)) {
            if (this.currentReadOnlyAsked.get()) {
                if (this.currentProtocol.isMasterConnection()) {
                    if (!this.isSecondaryHostFail()) {
                        this.proxy.lock.writeLock().lock();
                        try {
                            this.syncConnection(this.masterProtocol, this.secondaryProtocol);
                            this.currentProtocol = this.secondaryProtocol;
                            return;
                        }
                        catch (QueryException e) {
                            if (this.setSecondaryHostFail()) {
                                this.addToBlacklist(this.secondaryProtocol.getHostAddress());
                            }
                        }
                        finally {
                            this.proxy.lock.writeLock().unlock();
                        }
                    }
                    this.launchFailLoopIfNotlaunched(false);
                    this.throwFailoverMessage(new QueryException("master " + this.masterProtocol.getHostAddress() + " connection failed"), false);
                }
            } else if (!this.currentProtocol.isMasterConnection()) {
                if (!this.isMasterHostFail()) {
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                        this.currentProtocol = this.masterProtocol;
                        return;
                    }
                    catch (QueryException e) {
                        if (this.setMasterHostFail()) {
                            this.addToBlacklist(this.masterProtocol.getHostAddress());
                        }
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                }
                if (this.jdbcUrl.getOptions().autoReconnect) {
                    this.reconnectFailedConnection(new SearchFilter(false, true, false, true));
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                        this.currentProtocol = this.masterProtocol;
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                    return;
                }
                this.launchFailLoopIfNotlaunched(false);
                this.throwFailoverMessage(new QueryException("master " + this.masterProtocol.getHostAddress() + " connection failed"), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleErrorResult primaryFail(Method method, Object[] args) throws Throwable {
        boolean alreadyClosed;
        block25: {
            block24: {
                alreadyClosed = !this.masterProtocol.isConnected();
                try {
                    if (this.masterProtocol != null && this.masterProtocol.isConnected() && this.masterProtocol.ping()) {
                        if (this.masterProtocol.inTransaction()) {
                            this.masterProtocol.rollback();
                        }
                        return new HandleErrorResult(true);
                    }
                }
                catch (QueryException e) {
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.masterProtocol.close();
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                    if (!this.setMasterHostFail()) break block24;
                    this.addToBlacklist(this.masterProtocol.getHostAddress());
                }
            }
            if (this.jdbcUrl.getOptions().failOnReadOnly && !this.isSecondaryHostFail()) {
                try {
                    if (this.secondaryProtocol == null || !this.secondaryProtocol.ping()) break block25;
                    this.syncConnection(this.masterProtocol, this.secondaryProtocol);
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.currentProtocol = this.secondaryProtocol;
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                    this.launchFailLoopIfNotlaunched(false);
                    try {
                        return this.relaunchOperation(method, args);
                    }
                    catch (Exception e) {
                        return new HandleErrorResult();
                    }
                }
                catch (Exception e) {
                    if (this.setSecondaryHostFail()) {
                        this.addToBlacklist(this.secondaryProtocol.getHostAddress());
                    }
                    if (!this.secondaryProtocol.isConnected()) break block25;
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.secondaryProtocol.close();
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                }
            }
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, this.jdbcUrl.getOptions().failOnReadOnly, true, this.jdbcUrl.getOptions().failOnReadOnly));
            if (this.isMasterHostFail()) {
                this.launchFailLoopIfNotlaunched(true);
            }
            if (alreadyClosed) {
                return this.relaunchOperation(method, args);
            }
            return new HandleErrorResult(true);
        }
        catch (Exception e) {
            this.launchFailLoopIfNotlaunched(true);
            return new HandleErrorResult();
        }
    }

    @Override
    public void reconnect() throws QueryException {
        SearchFilter filter = this.currentReadOnlyAsked.get() ? new SearchFilter(true, true, true, true) : new SearchFilter(true, this.jdbcUrl.getOptions().failOnReadOnly, true, this.jdbcUrl.getOptions().failOnReadOnly);
        this.reconnectFailedConnection(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleErrorResult secondaryFail(Method method, Object[] args) throws Throwable {
        block23: {
            block22: {
                try {
                    if (this.secondaryProtocol != null && this.secondaryProtocol.isConnected() && this.secondaryProtocol.ping()) {
                        return this.relaunchOperation(method, args);
                    }
                }
                catch (Exception e) {
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.secondaryProtocol.close();
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                    if (!this.setSecondaryHostFail()) break block22;
                    this.addToBlacklist(this.secondaryProtocol.getHostAddress());
                }
            }
            if (!this.isMasterHostFail()) {
                try {
                    if (this.masterProtocol == null) break block23;
                    this.masterProtocol.ping();
                    this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.currentProtocol = this.masterProtocol;
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                    this.launchFailLoopIfNotlaunched(true);
                    return this.relaunchOperation(method, args);
                }
                catch (Exception e) {
                    if (!this.setMasterHostFail()) break block23;
                    this.addToBlacklist(this.masterProtocol.getHostAddress());
                    if (!this.masterProtocol.isConnected()) break block23;
                    this.proxy.lock.writeLock().lock();
                    try {
                        this.masterProtocol.close();
                    }
                    finally {
                        this.proxy.lock.writeLock().unlock();
                    }
                }
            }
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, true, true, true));
            if (this.isSecondaryHostFail()) {
                this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                this.proxy.lock.writeLock().lock();
                try {
                    this.currentProtocol = this.masterProtocol;
                }
                finally {
                    this.proxy.lock.writeLock().unlock();
                }
            }
            return this.relaunchOperation(method, args);
        }
        catch (Exception ee) {
            this.launchFailLoopIfNotlaunched(false);
            return new HandleErrorResult();
        }
    }

    public void checkIfTypeHaveChanged(SearchFilter searchFilter) throws QueryException {
        if (this.masterProtocol == null || this.masterProtocol.ping()) {
            // empty if block
        }
    }

    @Override
    public void throwFailoverMessage(QueryException queryException, boolean reconnected) throws QueryException {
        HostAddress hostAddress;
        boolean connectionTypeMaster = true;
        HostAddress hostAddress2 = hostAddress = this.masterProtocol != null ? this.masterProtocol.getHostAddress() : null;
        if (this.currentReadOnlyAsked.get()) {
            connectionTypeMaster = false;
            hostAddress = this.secondaryProtocol != null ? this.secondaryProtocol.getHostAddress() : null;
        }
        String firstPart = "Communications link failure with " + (connectionTypeMaster ? "primary" : "secondary") + (hostAddress != null ? " host " + hostAddress.host + ":" + hostAddress.port : "") + ". ";
        String error = "";
        if (this.jdbcUrl.getOptions().autoReconnect || !this.isMasterHostFail() && !this.isSecondaryHostFail()) {
            error = connectionTypeMaster && this.isMasterHostFail() || !connectionTypeMaster && this.isSecondaryHostFail() ? error + "  Driver will reconnect automatically in a few millisecond or during next query if append before" : error + " Driver as successfully reconnect connection";
        } else if (reconnected) {
            error = error + " Driver as reconnect connection";
        } else if (this.currentConnectionAttempts.get() > this.jdbcUrl.getOptions().retriesAllDown) {
            error = error + " Driver will not try to reconnect (too much failure > " + this.jdbcUrl.getOptions().retriesAllDown + ")";
        } else if (this.shouldReconnect()) {
            error = error + " Driver will try to reconnect automatically in a few millisecond or during next query if append before";
        } else {
            long longestFail = this.isMasterHostFail() ? (this.isSecondaryHostFail() ? Math.min(this.getMasterHostFailTimestamp(), this.getSecondaryHostFailTimestamp()) : this.getMasterHostFailTimestamp()) : this.getSecondaryHostFailTimestamp();
            long nextReconnectionTime = (long)(this.jdbcUrl.getOptions().secondsBeforeRetryMaster * 1000) - (System.currentTimeMillis() - longestFail);
            error = this.jdbcUrl.getOptions().secondsBeforeRetryMaster > 0 ? (this.jdbcUrl.getOptions().queriesBeforeRetryMaster > 0 ? error + " Driver will try to reconnect " + (connectionTypeMaster ? "primary" : "secondary") + " after " + nextReconnectionTime + " milliseconds or after " + (this.jdbcUrl.getOptions().queriesBeforeRetryMaster - this.queriesSinceFailover.get()) + " query(s)" : error + " Driver will try to reconnect " + (connectionTypeMaster ? "primary" : "secondary") + " after " + nextReconnectionTime + " milliseconds") : (this.jdbcUrl.getOptions().queriesBeforeRetryMaster > 0 ? error + " Driver will try to reconnect " + (connectionTypeMaster ? "primary" : "secondary") + " after " + (this.jdbcUrl.getOptions().queriesBeforeRetryMaster - this.queriesSinceFailover.get()) + " query(s)" : error + " Driver will not try to reconnect automatically");
        }
        if (queryException == null) {
            throw new QueryException(firstPart + error, -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState());
        }
        error = queryException.getMessage() + ". " + error;
        queryException.setMessage(firstPart + error);
        throw queryException;
    }

    protected class PingLoop
    implements Runnable {
        MastersSlavesListener listener;

        public PingLoop(MastersSlavesListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            if (MastersSlavesListener.this.lastQueryTime + (long)(MastersSlavesListener.this.jdbcUrl.getOptions().validConnectionTimeout * 1000) < System.currentTimeMillis() && !MastersSlavesListener.this.isMasterHostFail()) {
                boolean masterFail = false;
                try {
                    if (MastersSlavesListener.this.masterProtocol != null && MastersSlavesListener.this.masterProtocol.isConnected()) {
                        MastersSlavesListener.this.checkIfTypeHaveChanged(null);
                    } else {
                        masterFail = true;
                    }
                }
                catch (QueryException e) {
                    masterFail = true;
                }
                if (masterFail && MastersSlavesListener.this.setMasterHostFail()) {
                    try {
                        this.listener.primaryFail(null, null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

