/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.packet;

import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacket;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;

public class ErrorPacket
extends ResultPacket {
    private final short errorNumber;
    private final byte sqlStateMarker;
    private final byte[] sqlState;
    private final String message;

    public ErrorPacket(RawPacket rawPacket) {
        Reader reader = new Reader(rawPacket);
        reader.readByte();
        this.errorNumber = reader.readShort();
        this.sqlStateMarker = reader.readByte();
        if (this.sqlStateMarker == 35) {
            this.sqlState = reader.readRawBytes(5);
            this.message = reader.readString(StandardCharsets.UTF_8);
        } else {
            byte b;
            byte[] msgBuf = new byte[reader.getRemainingSize() + 1];
            msgBuf[0] = this.sqlStateMarker;
            int cnt = 1;
            while (reader.getRemainingSize() > 0 && (b = reader.readByte()) != 0) {
                msgBuf[cnt++] = b;
            }
            this.message = new String(msgBuf, StandardCharsets.UTF_8);
            this.sqlState = "HY000".getBytes();
        }
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public ResultPacket.ResultType getResultType() {
        return ResultPacket.ResultType.ERROR;
    }

    @Override
    public byte getPacketSeq() {
        return 0;
    }

    public short getErrorNumber() {
        return this.errorNumber;
    }

    public String getSqlState() {
        return new String(this.sqlState);
    }

    public byte getSqlStateMarker() {
        return this.sqlStateMarker;
    }
}

