/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.query;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.common.query.IllegalParameterException;
import org.mariadb.jdbc.internal.common.query.ParameterizedQuery;
import org.mariadb.jdbc.internal.common.query.QueryType;
import org.mariadb.jdbc.internal.common.query.parameters.ParameterHolder;

public class MySQLClientParameterizedQuery
implements ParameterizedQuery {
    private ParameterHolder[] parameters;
    private int paramCount;
    private String query;
    private byte[][] queryPartsArray;
    private byte[] rewriteFirstPart = null;
    private byte[] rewriteRepeatLastPart = null;
    private byte[] rewriteNotRepeatLastPart = null;

    public MySQLClientParameterizedQuery(String query, boolean noBackslashEscapes, int rewriteOffset) {
        this.query = query;
        List<String> queryParts = Utils.createQueryParts(query, noBackslashEscapes);
        if (rewriteOffset != -1) {
            this.rewriteFirstPart = queryParts.get(0).substring(rewriteOffset + 1).getBytes(StandardCharsets.UTF_8);
            String lastPart = queryParts.get(queryParts.size() - 1);
            if (lastPart.indexOf(")") != -1) {
                this.rewriteRepeatLastPart = lastPart.substring(0, lastPart.indexOf(")")).getBytes(StandardCharsets.UTF_8);
                this.rewriteNotRepeatLastPart = lastPart.substring(lastPart.indexOf(")") + 1).getBytes(StandardCharsets.UTF_8);
            } else {
                this.rewriteRepeatLastPart = lastPart.getBytes(StandardCharsets.UTF_8);
                this.rewriteNotRepeatLastPart = new byte[0];
            }
        }
        this.queryPartsArray = new byte[queryParts.size()][];
        for (int i = 0; i < queryParts.size(); ++i) {
            this.queryPartsArray[i] = queryParts.get(i).getBytes(StandardCharsets.UTF_8);
        }
        this.paramCount = queryParts.size() - 1;
        this.parameters = new ParameterHolder[this.paramCount];
    }

    private MySQLClientParameterizedQuery() {
    }

    public MySQLClientParameterizedQuery cloneQuery() {
        MySQLClientParameterizedQuery q = new MySQLClientParameterizedQuery();
        q.parameters = new ParameterHolder[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            q.parameters[i] = this.parameters[i];
        }
        q.paramCount = this.paramCount;
        q.query = this.query;
        q.queryPartsArray = this.queryPartsArray;
        q.rewriteFirstPart = this.rewriteFirstPart;
        q.rewriteRepeatLastPart = this.rewriteRepeatLastPart;
        q.rewriteNotRepeatLastPart = this.rewriteNotRepeatLastPart;
        return q;
    }

    @Override
    public void setParameter(int position, ParameterHolder parameter) throws IllegalParameterException {
        if (position < 0 || position >= this.paramCount) {
            throw new IllegalParameterException("No '?' on that position");
        }
        this.parameters[position] = parameter;
    }

    @Override
    public ParameterHolder[] getParameters() {
        return this.parameters;
    }

    @Override
    public void clearParameters() {
        this.parameters = new ParameterHolder[this.paramCount];
    }

    @Override
    public void validate() throws QueryException {
        if (this.containsNull(this.parameters)) {
            throw new QueryException("You need to set exactly " + this.paramCount + " parameters on the prepared statement");
        }
    }

    @Override
    public void writeTo(OutputStream os) throws IOException, QueryException {
        if (this.queryPartsArray.length == 0) {
            throw new AssertionError((Object)"Invalid query, queryParts was empty");
        }
        os.write(this.queryPartsArray[0]);
        for (int i = 1; i < this.queryPartsArray.length; ++i) {
            this.parameters[i - 1].writeTo(os);
            if (this.queryPartsArray[i].length == 0) continue;
            os.write(this.queryPartsArray[i]);
        }
    }

    @Override
    public void writeFirstRewritePart(OutputStream os) throws IOException, QueryException {
        if (this.queryPartsArray.length == 0) {
            throw new AssertionError((Object)"Invalid query, queryParts was empty");
        }
        for (int i = 0; i < this.queryPartsArray.length - 1; ++i) {
            os.write(this.queryPartsArray[i]);
            this.parameters[i].writeTo(os);
        }
        if (this.rewriteRepeatLastPart != null) {
            os.write(this.rewriteRepeatLastPart);
        }
        os.write(41);
    }

    @Override
    public void writeLastRewritePart(OutputStream os) throws IOException, QueryException {
        if (this.rewriteNotRepeatLastPart != null) {
            os.write(this.rewriteNotRepeatLastPart);
        }
    }

    @Override
    public void writeToRewritablePart(OutputStream os, int rewriteOffset) throws IOException, QueryException {
        if (this.queryPartsArray.length == 0) {
            throw new AssertionError((Object)"Invalid query, queryParts was empty");
        }
        os.write(new byte[]{44, 40});
        os.write(this.rewriteFirstPart);
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i].writeTo(os);
            if (i < this.parameters.length - 1) {
                os.write(this.queryPartsArray[i + 1]);
                continue;
            }
            os.write(this.rewriteRepeatLastPart);
        }
        os.write(41);
    }

    private boolean containsNull(ParameterHolder[] parameters) {
        for (ParameterHolder ph : parameters) {
            if (ph != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public byte[][] getQueryPartsArray() {
        return this.queryPartsArray;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.classifyQuery(this.query);
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("sql : '" + this.query + "'");
        if (this.parameters.length > 0) {
            sb.append(", parameters : [");
            for (int i = 0; i < this.parameters.length; ++i) {
                if (this.parameters[i] == null) {
                    sb.append("null");
                } else {
                    sb.append(this.parameters[i].toString());
                }
                if (i == this.parameters.length - 1) continue;
                sb.append(",");
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

