/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.internal.failover.HandleErrorResult;
import org.mariadb.jdbc.internal.failover.Listener;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class FailoverProxy
implements InvocationHandler {
    public static final String METHOD_IS_EXPLICIT_CLOSED = "isExplicitClosed";
    public static final String METHOD_GET_OPTIONS = "getOptions";
    public static final String METHOD_GET_PROXY = "getProxy";
    public static final String METHOD_EXECUTE_QUERY = "executeQuery";
    public static final String METHOD_SET_READ_ONLY = "setReadonly";
    public static final String METHOD_IS_READ_ONLY = "isReadOnly";
    public static final String METHOD_CLOSED_EXPLICIT = "closeExplicit";
    public static final String METHOD_IS_CLOSED = "isClosed";
    public final ReentrantLock lock;
    private Listener listener;

    public FailoverProxy(Listener listener, ReentrantLock lock) throws QueryException {
        this.lock = lock;
        this.listener = listener;
        this.listener.setProxy(this);
        this.listener.initializeConnection();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "isExplicitClosed": {
                return this.listener.isExplicitClosed();
            }
            case "getOptions": {
                return this.listener.getUrlParser().getOptions();
            }
            case "getProxy": {
                return this;
            }
            case "isClosed": {
                return this.listener.isClosed();
            }
            case "executeQuery": {
                try {
                    this.listener.preExecute();
                    break;
                }
                catch (QueryException e) {
                    return this.handleFailOver(e, method, args);
                }
            }
            case "setReadonly": {
                this.listener.switchReadOnlyConnection((Boolean)args[0]);
                return null;
            }
            case "isReadOnly": {
                return this.listener.isReadOnly();
            }
            case "closeExplicit": {
                this.listener.preClose();
                return null;
            }
        }
        try {
            return this.listener.invoke(method, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof QueryException && this.hasToHandleFailover((QueryException)e.getTargetException())) {
                    return this.handleFailOver((QueryException)e.getTargetException(), method, args);
                }
                throw e.getTargetException();
            }
            throw e;
        }
    }

    private Object handleFailOver(QueryException qe, Method method, Object[] args) throws Throwable {
        HandleErrorResult handleErrorResult = this.listener.handleFailover(method, args);
        if (handleErrorResult.mustThrowError) {
            this.listener.throwFailoverMessage(qe, handleErrorResult.isReconnected);
        }
        return handleErrorResult.resultObject;
    }

    public boolean hasToHandleFailover(QueryException exception) {
        return exception.getSqlState() != null && exception.getSqlState().startsWith("08");
    }

    public void reconnect() throws SQLException {
        try {
            this.listener.reconnect();
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, null, null);
        }
    }

    public Listener getListener() {
        return this.listener;
    }
}

