/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.failover.HandleErrorResult;
import org.mariadb.jdbc.internal.failover.Listener;
import org.mariadb.jdbc.internal.failover.thread.ConnectionValidator;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.SqlStates;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;

public abstract class AbstractMastersListener
implements Listener {
    private static Logger logger = LoggerFactory.getLogger(AbstractMastersListener.class);
    private static final ConcurrentMap<HostAddress, Long> blacklist = new ConcurrentHashMap<HostAddress, Long>();
    private static final ConnectionValidator connectionValidationLoop = new ConnectionValidator();
    public final UrlParser urlParser;
    protected AtomicInteger currentConnectionAttempts = new AtomicInteger();
    protected volatile boolean currentReadOnlyAsked = false;
    protected Protocol currentProtocol = null;
    protected FailoverProxy proxy;
    protected long lastRetry = 0L;
    protected AtomicBoolean explicitClosed = new AtomicBoolean(false);
    private volatile long masterHostFailNanos = 0L;
    private AtomicBoolean masterHostFail = new AtomicBoolean();
    protected long lastQueryNanos = 0L;

    protected AbstractMastersListener(UrlParser urlParser) {
        this.urlParser = urlParser;
        this.masterHostFail.set(true);
        this.lastQueryNanos = System.nanoTime();
    }

    @Override
    public void initializeConnection() throws QueryException {
        long connectionTimeoutMillis = TimeUnit.SECONDS.toMillis(this.urlParser.getOptions().validConnectionTimeout);
        this.lastQueryNanos = System.nanoTime();
        if (connectionTimeoutMillis > 0L) {
            connectionValidationLoop.addListener(this, connectionTimeoutMillis);
        }
    }

    protected void removeListenerFromSchedulers() {
        connectionValidationLoop.removeListener(this);
    }

    protected void preAutoReconnect() throws QueryException {
        if (!this.isExplicitClosed()) {
            try {
                boolean currentReadOnlyAsked = this.currentReadOnlyAsked;
                this.reconnectFailedConnection(new SearchFilter(!currentReadOnlyAsked, currentReadOnlyAsked));
            }
            catch (QueryException queryException) {
                // empty catch block
            }
        } else {
            throw new QueryException("Connection is closed", -1, SqlStates.CONNECTION_EXCEPTION);
        }
        this.handleFailLoop();
    }

    @Override
    public FailoverProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(FailoverProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public Set<HostAddress> getBlacklistKeys() {
        return blacklist.keySet();
    }

    @Override
    public HandleErrorResult handleFailover(QueryException qe, Method method, Object[] args, Protocol protocol) throws Throwable {
        if (this.isExplicitClosed()) {
            throw new QueryException("Connection has been closed !");
        }
        if (this.setMasterHostFail()) {
            logger.warn("SQL Primary node [" + this.currentProtocol.getHostAddress().toString() + ", conn " + this.currentProtocol.getServerThreadId() + " ] connection fail. Reason : " + qe.getMessage());
            this.addToBlacklist(this.currentProtocol.getHostAddress());
        }
        return this.primaryFail(method, args);
    }

    @Override
    public void addToBlacklist(HostAddress hostAddress) {
        if (hostAddress != null && !this.isExplicitClosed()) {
            blacklist.putIfAbsent(hostAddress, System.nanoTime());
        }
    }

    @Override
    public void removeFromBlacklist(HostAddress hostAddress) {
        if (hostAddress != null) {
            blacklist.remove(hostAddress);
        }
    }

    public void resetOldsBlackListHosts() {
        long currentTimeNanos = System.nanoTime();
        Set entries = blacklist.entrySet();
        for (Map.Entry blEntry : entries) {
            long entryNanos = (Long)blEntry.getValue();
            long durationSeconds = TimeUnit.NANOSECONDS.toSeconds(currentTimeNanos - entryNanos);
            if (durationSeconds < (long)this.urlParser.getOptions().loadBalanceBlacklistTimeout) continue;
            blacklist.remove(blEntry.getKey(), entryNanos);
        }
    }

    protected void resetMasterFailoverData() {
        if (this.masterHostFail.compareAndSet(true, false)) {
            this.masterHostFailNanos = 0L;
        }
    }

    protected void setSessionReadOnly(boolean readOnly, Protocol protocol) throws QueryException {
        if (protocol.versionGreaterOrEqual(5, 6, 5)) {
            protocol.executeQuery("SET SESSION TRANSACTION " + (readOnly ? "READ ONLY" : "READ WRITE"));
        }
    }

    public abstract void handleFailLoop();

    @Override
    public Protocol getCurrentProtocol() {
        return this.currentProtocol;
    }

    public long getMasterHostFailNanos() {
        return this.masterHostFailNanos;
    }

    @Override
    public boolean setMasterHostFail() {
        if (this.masterHostFail.compareAndSet(false, true)) {
            this.masterHostFailNanos = System.nanoTime();
            this.currentConnectionAttempts.set(0);
            return true;
        }
        return false;
    }

    @Override
    public boolean isMasterHostFail() {
        return this.masterHostFail.get();
    }

    @Override
    public boolean hasHostFail() {
        return this.masterHostFail.get();
    }

    @Override
    public SearchFilter getFilterForFailedHost() {
        return new SearchFilter(this.isMasterHostFail(), false);
    }

    public HandleErrorResult relaunchOperation(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        HandleErrorResult handleErrorResult = new HandleErrorResult(true);
        if (method != null) {
            switch (method.getName()) {
                case "executeQuery": {
                    String query;
                    if (!(args[2] instanceof String) || (query = ((String)args[2]).toUpperCase()).equals("ALTER SYSTEM CRASH") || query.startsWith("KILL")) break;
                    logger.debug("relaunch query to new connection " + (this.currentProtocol != null ? "server thread id " + this.currentProtocol.getServerThreadId() : ""));
                    handleErrorResult.resultObject = method.invoke((Object)this.currentProtocol, args);
                    handleErrorResult.mustThrowError = false;
                    break;
                }
                case "prepareAndExecutesComMulti": 
                case "executePreparedQuery": {
                    try {
                        boolean mustBeOnMaster = (Boolean)args[0];
                        ServerPrepareResult oldServerPrepareResult = (ServerPrepareResult)args[1];
                        ServerPrepareResult serverPrepareResult = this.currentProtocol.prepare(oldServerPrepareResult.getSql(), mustBeOnMaster);
                        oldServerPrepareResult.failover(serverPrepareResult.getStatementId(), this.currentProtocol);
                        logger.debug("relaunch query to new connection " + (this.currentProtocol != null ? "server thread id " + this.currentProtocol.getServerThreadId() : ""));
                        handleErrorResult.resultObject = method.invoke((Object)this.currentProtocol, args);
                        handleErrorResult.mustThrowError = false;
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    handleErrorResult.resultObject = method.invoke((Object)this.currentProtocol, args);
                    handleErrorResult.mustThrowError = false;
                }
            }
        }
        return handleErrorResult;
    }

    public boolean isQueryRelaunchable(Method method, Object[] args) {
        if (method != null) {
            switch (method.getName()) {
                case "executeQuery": {
                    if (!((Boolean)args[0]).booleanValue()) {
                        return true;
                    }
                    if (args[2] instanceof String) {
                        return ((String)args[2]).toUpperCase().startsWith("SELECT");
                    }
                    if (!(args[2] instanceof ClientPrepareResult)) break;
                    String query = new String(((ClientPrepareResult)args[2]).getQueryParts().get(0)).toUpperCase();
                    return query.startsWith("SELECT");
                }
                case "executePreparedQuery": {
                    if (!((Boolean)args[0]).booleanValue()) {
                        return true;
                    }
                    ServerPrepareResult serverPrepareResult = (ServerPrepareResult)args[1];
                    return serverPrepareResult.getSql().toUpperCase().startsWith("SELECT");
                }
                case "prepareAndExecute": {
                    if (!((Boolean)args[0]).booleanValue()) {
                        return true;
                    }
                    return ((String)args[2]).toUpperCase().startsWith("SELECT");
                }
                case "executeBatch": 
                case "executeBatchMultiple": 
                case "executeBatchRewrite": 
                case "prepareAndExecutes": 
                case "executeBatchMulti": {
                    return (Boolean)args[0] == false;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public Object invoke(Method method, Object[] args, Protocol specificProtocol) throws Throwable {
        return method.invoke((Object)specificProtocol, args);
    }

    @Override
    public Object invoke(Method method, Object[] args) throws Throwable {
        return method.invoke((Object)this.currentProtocol, args);
    }

    @Override
    public void syncConnection(Protocol from, Protocol to) throws QueryException {
        if (from != null) {
            this.proxy.lock.lock();
            try {
                to.setMaxRows(from.getMaxRows());
                to.setInternalMaxRows(from.getMaxRows());
                if (from.getTransactionIsolationLevel() != 0) {
                    to.setTransactionIsolation(from.getTransactionIsolationLevel());
                }
                if (from.getDatabase() != null && !"".equals(from.getDatabase()) && !from.getDatabase().equals(to.getDatabase())) {
                    to.setCatalog(from.getDatabase());
                }
                if (from.getAutocommit() != to.getAutocommit()) {
                    to.executeQuery("set autocommit=" + (from.getAutocommit() ? "1" : "0"));
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.currentProtocol.isClosed();
    }

    @Override
    public boolean isReadOnly() {
        return this.currentReadOnlyAsked;
    }

    @Override
    public boolean isExplicitClosed() {
        return this.explicitClosed.get();
    }

    @Override
    public int getRetriesAllDown() {
        return this.urlParser.getOptions().retriesAllDown;
    }

    @Override
    public boolean isAutoReconnect() {
        return this.urlParser.getOptions().autoReconnect;
    }

    @Override
    public UrlParser getUrlParser() {
        return this.urlParser;
    }

    @Override
    public abstract void preExecute() throws QueryException;

    @Override
    public abstract void preClose() throws SQLException;

    @Override
    public abstract void reconnectFailedConnection(SearchFilter var1) throws QueryException;

    @Override
    public abstract void switchReadOnlyConnection(Boolean var1) throws QueryException;

    @Override
    public abstract HandleErrorResult primaryFail(Method var1, Object[] var2) throws Throwable;

    @Override
    public void throwFailoverMessage(HostAddress failHostAddress, boolean wasMaster, QueryException queryException, boolean reconnected) throws QueryException {
        String firstPart = "Communications link failure with " + (wasMaster ? "primary" : "secondary") + (failHostAddress != null ? " host " + failHostAddress.host + ":" + failHostAddress.port : "") + ". ";
        String error = "";
        if (reconnected) {
            error = error + " Driver has reconnect connection";
        } else if (this.currentConnectionAttempts.get() > this.urlParser.getOptions().retriesAllDown) {
            error = error + " Driver will not try to reconnect (too much failure > " + this.urlParser.getOptions().retriesAllDown + ")";
        }
        if (queryException == null) {
            queryException = new QueryException(firstPart + error, -1, SqlStates.CONNECTION_EXCEPTION);
        } else {
            error = queryException.getMessage() + ". " + error;
            queryException.setMessage(firstPart + error);
        }
        if (reconnected && queryException.getSqlState().startsWith("08")) {
            queryException.setSqlState("25S03");
        }
        throw queryException;
    }

    @Override
    public boolean canRetryFailLoop() {
        return this.currentConnectionAttempts.get() < this.urlParser.getOptions().failoverLoopRetries;
    }

    @Override
    public abstract void reconnect() throws QueryException;

    @Override
    public abstract boolean checkMasterStatus(SearchFilter var1);

    public static void clearBlacklist() {
        blacklist.clear();
    }

    @Override
    public long getLastQueryNanos() {
        return this.lastQueryNanos;
    }

    protected boolean pingMasterProtocol(Protocol protocol) {
        try {
            protocol.ping();
            return true;
        }
        catch (QueryException e) {
            this.proxy.lock.lock();
            try {
                protocol.close();
                if (this.setMasterHostFail()) {
                    this.addToBlacklist(protocol.getHostAddress());
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
            return false;
        }
    }

    public void closeConnection(Protocol protocol) {
        if (protocol != null && protocol.isConnected()) {
            protocol.close();
        }
    }
}

