/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.Results;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;
import org.mariadb.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;

public class MariaDbStatement
implements Statement,
Cloneable {
    private static Logger logger = LoggerFactory.getLogger(MariaDbStatement.class);
    private static final ScheduledExecutorService timeoutScheduler = SchedulerServiceProviderHolder.getTimeoutScheduler();
    protected Protocol protocol;
    protected MariaDbConnection connection;
    protected Future<?> timerTaskFuture;
    protected ResultSet batchResultSet = null;
    protected volatile boolean closed = false;
    boolean isTimedout;
    volatile boolean executing;
    protected List<String> batchQueries;
    private boolean warningsCleared;
    protected int queryTimeout;
    private int fetchSize;
    protected int maxRows;
    protected final ReentrantLock lock;
    protected Results results = null;
    protected int resultSetScrollType;
    protected boolean mustCloseOnCompletion = false;
    protected Options options;

    public MariaDbStatement(MariaDbConnection connection, int resultSetScrollType) {
        this.protocol = connection.getProtocol();
        this.connection = connection;
        this.resultSetScrollType = resultSetScrollType;
        this.lock = this.connection.lock;
        this.options = this.protocol.getOptions();
    }

    public MariaDbStatement clone() throws CloneNotSupportedException {
        MariaDbStatement clone = (MariaDbStatement)super.clone();
        clone.connection = this.connection;
        clone.protocol = this.protocol;
        clone.timerTaskFuture = null;
        clone.batchQueries = new ArrayList<String>();
        clone.results = null;
        clone.closed = false;
        clone.warningsCleared = true;
        clone.fetchSize = 0;
        clone.maxRows = 0;
        return clone;
    }

    public static void unloadDriver() {
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    protected void setTimerTask() {
        assert (this.timerTaskFuture == null);
        this.timerTaskFuture = timeoutScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    MariaDbStatement.this.isTimedout = true;
                    MariaDbStatement.this.protocol.cancelCurrentQuery();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, (long)this.queryTimeout, TimeUnit.SECONDS);
    }

    protected void executeQueryProlog() throws SQLException {
        if (this.closed) {
            throw new SQLException("execute() is called on closed statement");
        }
        this.protocol.prolog(this.results, this.maxRows, this.protocol.getProxy() != null, this.connection, this);
        if (this.queryTimeout != 0) {
            this.setTimerTask();
        }
    }

    protected void stopTimeoutTask() {
        if (this.timerTaskFuture != null) {
            if (!this.timerTaskFuture.cancel(true)) {
                try {
                    this.timerTaskFuture.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            this.timerTaskFuture = null;
        }
    }

    protected void executeQueryEpilog(QueryException queryException) throws SQLException {
        this.stopTimeoutTask();
        if (this.isTimedout) {
            this.isTimedout = false;
            queryException = new QueryException("Query timed out", 1317, "JZ0002", (Throwable)queryException);
        }
        if (queryException == null) {
            return;
        }
        if (queryException.getSqlState() != null && queryException.getSqlState().startsWith("08")) {
            this.close();
        }
        ExceptionMapper.throwAndLogException(queryException, this.connection, this, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeInternal(String sql, int fetchSize) throws SQLException {
        this.executing = true;
        QueryException exception = null;
        this.lock.lock();
        try {
            this.executeQueryProlog();
            this.batchResultSet = null;
            Results internalResults = new Results(this, fetchSize, false, 1, false, this.resultSetScrollType);
            this.protocol.executeQuery(this.protocol.isMasterConnection(), internalResults, Utils.nativeSql(sql, this.connection.noBackslashEscapes));
            internalResults.commandEnd();
            this.results = internalResults;
            boolean bl = this.results.getResultSet() != null;
            return bl;
        }
        catch (QueryException e) {
            exception = e;
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            this.executeQueryEpilog(exception);
            this.executing = false;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeInternal(sql, this.fetchSize);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeInternal(sql, this.fetchSize);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.executeInternal(sql, this.fetchSize);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.executeInternal(sql, this.fetchSize);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return this.results.getResultSet();
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public void close() throws SQLException {
        this.lock.lock();
        try {
            this.closed = true;
            if (this.results != null) {
                if (this.results.getFetchSize() != 0) {
                    this.skipMoreResults();
                }
                this.results = null;
            }
            this.protocol = null;
            if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
                return;
            }
            this.connection.pooledConnection.fireStatementClosed(this);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max rows cannot be negative : asked for " + max);
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    public void setLocalInfileInputStream(InputStream inputStream) throws SQLException {
        this.checkClose();
        this.protocol.setLocalInfileInputStream(inputStream);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClose();
        try {
            if (!this.executing) {
                return;
            }
            this.protocol.cancelCurrentQuery();
        }
        catch (QueryException e) {
            logger.error("error cancelling query", e);
            ExceptionMapper.throwException(e, this.connection, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClose();
        if (!this.warningsCleared) {
            return this.connection.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningsCleared = true;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Cursors are not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.results != null && this.results.getCmdInformation() != null) {
            return this.results.getCmdInformation().getGeneratedKeys(this.protocol);
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClose();
        if (this.results != null) {
            return this.results.getResultSet();
        }
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.results != null && this.results.getCmdInformation() != null) {
            return this.results.getCmdInformation().getUpdateCount();
        }
        return -1;
    }

    protected void skipMoreResults() throws SQLException {
        try {
            this.protocol.skip();
            this.warningsCleared = false;
            this.connection.reenableWarnings();
        }
        catch (QueryException e) {
            logger.debug("error skipMoreResults", e);
            ExceptionMapper.throwException(e, this.connection, this);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.results != null) {
            this.checkClose();
            return this.results.getMoreResults(current, this.protocol);
        }
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE) {
            throw new SQLException("invalid fetch size");
        }
        if (rows == Integer.MIN_VALUE) {
            this.fetchSize = 1;
            return;
        }
        this.fetchSize = rows;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetScrollType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList<String>();
        }
        if (sql == null) {
            throw ExceptionMapper.getSqlException("null cannot be set to addBatch( String sql)");
        }
        this.batchQueries.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchQueries != null) {
            this.batchQueries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int size;
        this.checkClose();
        if (this.batchQueries == null || (size = this.batchQueries.size()) == 0) {
            return new int[0];
        }
        Results internalResults = new Results(this, 0, true, size, false, this.resultSetScrollType);
        this.lock.lock();
        try {
            QueryException exception = null;
            this.executing = true;
            this.executeQueryProlog();
            try {
                if (this.options.rewriteBatchedStatements) {
                    boolean batchQueryMultiRewritable = true;
                    for (String query : this.batchQueries) {
                        if (ClientPrepareResult.isRewritableBatch(query, this.connection.noBackslashEscapes)) continue;
                        batchQueryMultiRewritable = false;
                        break;
                    }
                    if (batchQueryMultiRewritable) {
                        this.protocol.executeBatchMultiple(this.protocol.isMasterConnection(), internalResults, this.batchQueries);
                    } else {
                        this.protocol.executeBatch(this.protocol.isMasterConnection(), internalResults, this.batchQueries);
                    }
                } else {
                    this.protocol.executeBatch(this.protocol.isMasterConnection(), internalResults, this.batchQueries);
                }
            }
            catch (QueryException e) {
                exception = e;
            }
            finally {
                internalResults.commandEnd();
                this.results = internalResults;
                this.executing = false;
                this.executeQueryEpilog(exception);
            }
            int[] e = internalResults.getCmdInformation().getUpdateCounts();
            return e;
        }
        catch (SQLException sqle) {
            int[] ret;
            if (internalResults.getCmdInformation() == null) {
                ret = new int[size];
                Arrays.fill(ret, -3);
            } else {
                ret = internalResults.getCmdInformation().getUpdateCounts();
            }
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), ret, (Throwable)sqle);
        }
        finally {
            this.lock.unlock();
            this.clearBatch();
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaceOrWrapper) throws SQLException {
        return interfaceOrWrapper.isInstance(this);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.mustCloseOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.mustCloseOnCompletion;
    }

    public void checkCloseOnCompletion(ResultSet resultSet) throws SQLException {
        if (this.mustCloseOnCompletion && !this.closed && this.results != null && resultSet.equals(this.results.getResultSet())) {
            this.close();
        }
    }

    protected void checkClose() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot do an operation on a closed statement");
        }
    }

    public long getServerThreadId() {
        return this.protocol != null ? this.protocol.getServerThreadId() : -1L;
    }
}

