/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.Closeable;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.failover.Listener;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.protocol.AbstractQueryProtocol;

public class MasterProtocol
extends AbstractQueryProtocol
implements Closeable {
    public MasterProtocol(UrlParser urlParser, ReentrantLock lock) {
        super(urlParser, lock);
    }

    public static MasterProtocol getNewProtocol(FailoverProxy proxy, UrlParser urlParser) {
        MasterProtocol newProtocol = new MasterProtocol(urlParser, proxy.lock);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }

    public static void loop(Listener listener, List<HostAddress> addresses, SearchFilter searchFilter) throws SQLException {
        ArrayDeque<HostAddress> loopAddresses = new ArrayDeque<HostAddress>(addresses);
        if (loopAddresses.isEmpty()) {
            MasterProtocol.resetHostList(listener, loopAddresses);
        }
        Throwable lastQueryException = null;
        for (int maxConnectionTry = listener.getRetriesAllDown(); !loopAddresses.isEmpty() || !searchFilter.isFailoverLoop() && maxConnectionTry > 0; --maxConnectionTry) {
            MasterProtocol protocol = MasterProtocol.getNewProtocol(listener.getProxy(), listener.getUrlParser());
            if (listener.isExplicitClosed()) {
                return;
            }
            try {
                HostAddress host = (HostAddress)loopAddresses.pollFirst();
                if (host == null) {
                    loopAddresses.addAll(listener.getUrlParser().getHostAddresses());
                    host = (HostAddress)loopAddresses.pollFirst();
                }
                protocol.setHostAddress(host);
                protocol.connect();
                if (listener.isExplicitClosed()) {
                    protocol.close();
                    return;
                }
                listener.removeFromBlacklist(protocol.getHostAddress());
                listener.foundActiveMaster(protocol);
                return;
            }
            catch (SQLException e) {
                listener.addToBlacklist(protocol.getHostAddress());
                lastQueryException = e;
                if (!loopAddresses.isEmpty() || searchFilter.isFailoverLoop() || maxConnectionTry <= 0) continue;
                MasterProtocol.resetHostList(listener, loopAddresses);
                continue;
            }
        }
        if (lastQueryException != null) {
            throw new SQLException("No active connection found for master : " + lastQueryException.getMessage(), ((SQLException)lastQueryException).getSQLState(), ((SQLException)lastQueryException).getErrorCode(), lastQueryException);
        }
        throw new SQLException("No active connection found for master");
    }

    private static void resetHostList(Listener listener, Deque<HostAddress> loopAddresses) {
        ArrayList<HostAddress> servers = new ArrayList<HostAddress>();
        servers.addAll(listener.getUrlParser().getHostAddresses());
        Collections.shuffle(servers);
        loopAddresses.clear();
        loopAddresses.addAll(servers);
    }
}

