/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class MariaDbClob
extends MariaDbBlob
implements Clob,
NClob,
Serializable {
    private static final long serialVersionUID = -2006825230517923067L;

    public MariaDbClob(byte[] bytes) {
        super(bytes);
    }

    public MariaDbClob(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
    }

    public MariaDbClob() {
    }

    public String toString() {
        try {
            return new String(this.data, this.offset, this.length, Buffer.UTF_8);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw ExceptionMapper.getSqlException("position must be >= 1");
        }
        if (length < 0) {
            throw ExceptionMapper.getSqlException("length must be > 0");
        }
        try {
            String val = this.toString();
            return val.substring((int)pos - 1, Math.min((int)pos - 1 + length, val.length()));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.toString());
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        String val = this.toString();
        if ((long)val.length() < (long)((int)pos - 1) + length) {
            throw ExceptionMapper.getSqlException("pos + length is greater than the number of characters in the Clob");
        }
        String sub = val.substring((int)pos - 1, (int)pos - 1 + (int)length);
        return new StringReader(sub);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        int bytePosition = this.utf8Position((int)pos - 1);
        OutputStream stream = this.setBinaryStream(bytePosition + 1);
        return new OutputStreamWriter(stream, Buffer.UTF_8);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.getBinaryStream();
    }

    @Override
    public long position(String searchStr, long start) throws SQLException {
        return this.toString().indexOf(searchStr, (int)start - 1) + 1;
    }

    @Override
    public long position(Clob searchStr, long start) throws SQLException {
        return this.position(searchStr.toString(), start);
    }

    private int utf8Position(int charPosition) {
        int pos = this.offset;
        for (int i = 0; i < charPosition; ++i) {
            int byteValue = this.data[pos] & 0xFF;
            if (byteValue < 128) {
                ++pos;
                continue;
            }
            if (byteValue < 194) {
                throw new AssertionError((Object)"invalid UTF8");
            }
            if (byteValue < 224) {
                pos += 2;
                continue;
            }
            if (byteValue < 240) {
                pos += 3;
                continue;
            }
            if (byteValue < 248) {
                pos += 4;
                continue;
            }
            throw new AssertionError((Object)"invalid UTF8");
        }
        return pos;
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        int bytePosition = this.utf8Position((int)pos - 1);
        super.setBytes(bytePosition + 1 - this.offset, str.getBytes(Buffer.UTF_8));
        return str.length();
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        return this.setString(pos, str.substring(offset, offset + len));
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return this.setBinaryStream(this.utf8Position((int)pos - 1) + 1);
    }

    @Override
    public long length() {
        long len = 0L;
        int i = this.offset;
        while (i < this.offset + this.length) {
            int byteValue = this.data[i] & 0xFF;
            if (byteValue < 128) {
                ++i;
            } else {
                if (byteValue < 194) {
                    throw new AssertionError((Object)"invalid UTF8");
                }
                if (byteValue < 224) {
                    i += 2;
                } else if (byteValue < 240) {
                    i += 3;
                } else if (byteValue < 248) {
                    i += 4;
                } else {
                    throw new AssertionError((Object)"invalid UTF8");
                }
            }
            ++len;
        }
        return len;
    }

    @Override
    public void truncate(long len) throws SQLException {
        int pos = this.offset;
        while ((long)pos < (long)this.offset + Math.min((long)this.length, len)) {
            int byteValue = this.data[pos] & 0xFF;
            if (byteValue < 128) {
                ++pos;
                continue;
            }
            if (byteValue < 194) {
                throw new AssertionError((Object)"invalid UTF8");
            }
            if (byteValue < 224) {
                pos += 2;
                continue;
            }
            if (byteValue < 240) {
                pos += 3;
                continue;
            }
            if (byteValue < 248) {
                pos += 4;
                continue;
            }
            throw new AssertionError((Object)"invalid UTF8");
        }
        this.length = pos - this.offset;
    }
}

