/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.util.DefaultOptions;
import org.mariadb.jdbc.internal.util.Options;

public final class Driver
implements java.sql.Driver {
    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        UrlParser urlParser = UrlParser.parse(url, props);
        if (urlParser == null || urlParser.getHostAddresses() == null) {
            return null;
        }
        return MariaDbConnection.newConnection(urlParser, null);
    }

    @Override
    public boolean acceptsURL(String url) {
        return UrlParser.acceptsUrl(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (url != null) {
            UrlParser urlParser = UrlParser.parse(url, info);
            if (urlParser == null || urlParser.getOptions() == null) {
                return new DriverPropertyInfo[0];
            }
            ArrayList<DriverPropertyInfo> props = new ArrayList<DriverPropertyInfo>();
            for (DefaultOptions o : DefaultOptions.values()) {
                try {
                    Field field = Options.class.getField(o.getOptionName());
                    Object value = field.get(urlParser.getOptions());
                    DriverPropertyInfo propertyInfo = new DriverPropertyInfo(field.getName(), value == null ? null : value.toString());
                    propertyInfo.description = o.getDescription();
                    propertyInfo.required = o.isRequired();
                    props.add(propertyInfo);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return props.toArray(new DriverPropertyInfo[props.size()]);
        }
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 8;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Use logging parameters for enabling logging.");
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not register driver", e);
        }
    }
}

