/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class MariaDbClob
extends MariaDbBlob
implements Clob,
NClob,
Serializable {
    private static final long serialVersionUID = -3066501059817815286L;

    public MariaDbClob(byte[] bytes) {
        super(bytes);
    }

    public MariaDbClob(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
    }

    public MariaDbClob() {
    }

    public String toString() {
        return new String(this.data, this.offset, this.length, StandardCharsets.UTF_8);
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw ExceptionMapper.getSqlException("position must be >= 1");
        }
        if (length < 0) {
            throw ExceptionMapper.getSqlException("length must be > 0");
        }
        try {
            String val = this.toString();
            return val.substring((int)pos - 1, Math.min((int)pos - 1 + length, val.length()));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Reader getCharacterStream() {
        return new StringReader(this.toString());
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        String val = this.toString();
        if ((long)val.length() < (long)((int)pos - 1) + length) {
            throw ExceptionMapper.getSqlException("pos + length is greater than the number of characters in the Clob");
        }
        String sub = val.substring((int)pos - 1, (int)pos - 1 + (int)length);
        return new StringReader(sub);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        int bytePosition = this.utf8Position((int)pos - 1);
        OutputStream stream = this.setBinaryStream(bytePosition + 1);
        return new OutputStreamWriter(stream, StandardCharsets.UTF_8);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.getBinaryStream();
    }

    @Override
    public long position(String searchStr, long start) {
        return this.toString().indexOf(searchStr, (int)start - 1) + 1;
    }

    @Override
    public long position(Clob searchStr, long start) {
        return this.position(searchStr.toString(), start);
    }

    private int utf8Position(int charPosition) {
        int pos = this.offset;
        for (int i = 0; i < charPosition; ++i) {
            int byteValue = this.data[pos] & 0xFF;
            if (byteValue < 128) {
                ++pos;
                continue;
            }
            if (byteValue < 194) {
                throw new RuntimeException("invalid UTF8");
            }
            if (byteValue < 224) {
                pos += 2;
                continue;
            }
            if (byteValue < 240) {
                pos += 3;
                continue;
            }
            if (byteValue < 248) {
                pos += 4;
                continue;
            }
            throw new RuntimeException("invalid UTF8");
        }
        return pos;
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        int bytePosition = this.utf8Position((int)pos - 1);
        super.setBytes(bytePosition + 1 - this.offset, str.getBytes(StandardCharsets.UTF_8));
        return str.length();
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        return this.setString(pos, str.substring(offset, offset + len));
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return this.setBinaryStream(this.utf8Position((int)pos - 1) + 1);
    }

    @Override
    public long length() {
        long len = 0L;
        int pos = this.offset;
        while (len < (long)this.length && this.data[pos] >= 0) {
            ++len;
            ++pos;
        }
        while (pos < this.offset + this.length) {
            byte firstByte;
            if ((firstByte = this.data[pos++]) < 0) {
                if (firstByte >> 5 != -2 || (firstByte & 0x1E) == 0) {
                    if (firstByte >> 4 == -2) {
                        if (pos + 1 < this.offset + this.length) {
                            pos += 2;
                            ++len;
                            continue;
                        }
                        throw new RuntimeException("invalid UTF8", new CharacterCodingException());
                    }
                    if (firstByte >> 3 != -2) {
                        throw new RuntimeException("invalid UTF8", new CharacterCodingException());
                    }
                    if (pos + 2 < this.offset + this.length) {
                        pos += 3;
                        len += 2L;
                        continue;
                    }
                    pos += this.offset + this.length;
                    ++len;
                    continue;
                }
                ++pos;
                ++len;
                continue;
            }
            ++len;
        }
        return len;
    }

    @Override
    public void truncate(long truncateLen) {
        long len = 0L;
        int pos = this.offset;
        while (len < (long)this.length && len < truncateLen && this.data[pos] >= 0) {
            ++len;
            ++pos;
        }
        while (pos < this.offset + this.length && len < truncateLen) {
            byte firstByte;
            if ((firstByte = this.data[pos++]) < 0) {
                if (firstByte >> 5 != -2 || (firstByte & 0x1E) == 0) {
                    if (firstByte >> 4 == -2) {
                        if (pos + 1 < this.offset + this.length) {
                            pos += 2;
                            ++len;
                            continue;
                        }
                        throw new RuntimeException("invalid UTF8", new CharacterCodingException());
                    }
                    if (firstByte >> 3 != -2) {
                        throw new RuntimeException("invalid UTF8", new CharacterCodingException());
                    }
                    if (pos + 2 < this.offset + this.length) {
                        if (len + 2L <= truncateLen) {
                            pos += 3;
                            len += 2L;
                            continue;
                        }
                        ++pos;
                        len = truncateLen;
                        continue;
                    }
                    throw new RuntimeException("invalid UTF8", new CharacterCodingException());
                }
                ++pos;
                ++len;
                continue;
            }
            ++len;
        }
        this.length = pos - this.offset;
    }
}

