/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover.thread;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.mariadb.jdbc.internal.failover.Listener;
import org.mariadb.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;

public class ConnectionValidator {
    private static final ScheduledExecutorService fixedSizedScheduler = SchedulerServiceProviderHolder.getFixedSizeScheduler(1, "validator");
    private static final int MINIMUM_CHECK_DELAY_MILLIS = 100;
    private final ConcurrentLinkedQueue<Listener> queue = new ConcurrentLinkedQueue();
    private final AtomicLong currentScheduledFrequency = new AtomicLong(-1L);
    private final ListenerChecker checker = new ListenerChecker();

    public void addListener(Listener listener, long listenerCheckMillis) {
        this.queue.add(listener);
        long newFrequency = Math.min(100L, listenerCheckMillis);
        if (this.currentScheduledFrequency.get() == -1L) {
            if (this.currentScheduledFrequency.compareAndSet(-1L, newFrequency)) {
                fixedSizedScheduler.schedule(this.checker, listenerCheckMillis, TimeUnit.MILLISECONDS);
            }
        } else {
            long frequency = this.currentScheduledFrequency.get();
            if (frequency > newFrequency) {
                this.currentScheduledFrequency.compareAndSet(frequency, newFrequency);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        this.queue.remove(listener);
        if (this.queue.isEmpty()) {
            ConcurrentLinkedQueue<Listener> concurrentLinkedQueue = this.queue;
            synchronized (concurrentLinkedQueue) {
                if (this.currentScheduledFrequency.get() > 0L && this.queue.isEmpty()) {
                    this.currentScheduledFrequency.set(-1L);
                }
            }
        }
    }

    private class ListenerChecker
    implements Runnable {
        private ListenerChecker() {
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            finally {
                long delay = ConnectionValidator.this.currentScheduledFrequency.get();
                if (delay > 0L) {
                    fixedSizedScheduler.schedule(this, delay, TimeUnit.MILLISECONDS);
                }
            }
        }

        private void doRun() {
            Iterator tmpQueue = ConnectionValidator.this.queue.iterator();
            long now = -1L;
            while (tmpQueue.hasNext()) {
                long durationNanos;
                long durationSeconds;
                Listener listener = (Listener)tmpQueue.next();
                if (listener.isExplicitClosed() || (durationSeconds = TimeUnit.NANOSECONDS.toSeconds(durationNanos = (now == -1L ? System.nanoTime() : now) - listener.getLastQueryNanos())) < (long)listener.getUrlParser().getOptions().validConnectionTimeout || listener.isMasterHostFail()) continue;
                boolean masterFail = false;
                if (listener.isMasterConnected()) {
                    listener.checkMasterStatus(null);
                } else {
                    masterFail = true;
                }
                if (!masterFail || !listener.setMasterHostFail()) continue;
                try {
                    listener.primaryFail(null, null);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

