/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.NoLogger;
import org.mariadb.jdbc.internal.logging.Slf4JLogger;

public class LoggerFactory {
    private static final Logger NO_LOGGER = new NoLogger();
    private static Boolean hasToLog = null;
    private static Class loggerClass = null;
    private static Method method = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(boolean mustLog) {
        if (hasToLog != null && hasToLog == mustLog || !mustLog) return;
        Class<LoggerFactory> clazz = LoggerFactory.class;
        synchronized (LoggerFactory.class) {
            if (hasToLog != null && hasToLog == mustLog) return;
            try {
                loggerClass = Class.forName("org.slf4j.LoggerFactory");
                method = loggerClass.getMethod("getLogger", Class.class);
                hasToLog = Boolean.TRUE;
            }
            catch (ClassNotFoundException | NoSuchMethodException classNotFound) {
                System.out.println("Logging cannot be activated, missing slf4j dependency");
                hasToLog = Boolean.FALSE;
            }
            return;
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        if (hasToLog != null && hasToLog.booleanValue()) {
            try {
                return new Slf4JLogger((org.slf4j.Logger)method.invoke((Object)loggerClass, clazz));
            }
            catch (IllegalAccessException | InvocationTargetException illegalAccess) {
                return NO_LOGGER;
            }
        }
        return NO_LOGGER;
    }
}

