/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.plugin.Codec;
import org.mariadb.jdbc.plugin.codec.LocalDateTimeCodec;
import org.mariadb.jdbc.plugin.codec.LocalTimeCodec;

public class TimeCodec
implements Codec<Time> {
    public static final TimeCodec INSTANCE = new TimeCodec();
    private static final LocalDate EPOCH_DATE = LocalDate.of(1970, 1, 1);
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TIME, new DataType[]{DataType.DATETIME, DataType.TIMESTAMP, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Time.class.getName();
    }

    @Override
    public boolean canDecode(Column column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(Time.class) && !type.equals(Date.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Time;
    }

    @Override
    public Time decodeText(ReadableByteBuf buf, int length, Column column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case VARSTRING: 
            case STRING: 
            case TIME: {
                Calendar c = cal == null ? Calendar.getInstance() : cal;
                int offset = c.getTimeZone().getOffset(0L);
                int[] parts = LocalTimeCodec.parseTime(buf, length, column);
                long timeInMillis = ((long)parts[1] * 3600000L + (long)parts[2] * 60000L + (long)parts[3] * 1000L + (long)(parts[4] / 1000000)) * (long)parts[0] - (long)offset;
                return new Time(timeInMillis);
            }
            case TIMESTAMP: 
            case DATETIME: {
                LocalDateTime lt = LocalDateTimeCodec.INSTANCE.decodeText(buf, length, column, cal);
                if (lt == null) {
                    return null;
                }
                Calendar cc = cal == null ? Calendar.getInstance() : cal;
                ZonedDateTime d = EPOCH_DATE.atTime(lt.toLocalTime()).atZone(cc.getTimeZone().toZoneId());
                return new Time(d.toEpochSecond() * 1000L + (long)(d.getNano() / 1000000));
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{column.getType()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time decodeBinary(ReadableByteBuf buf, int length, Column column, Calendar calParam) throws SQLDataException {
        Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        long microseconds = 0L;
        switch (column.getType()) {
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case VARSTRING: 
            case STRING: {
                Time t;
                int[] parts = LocalTimeCodec.parseTime(buf, length, column);
                Calendar calendar = cal;
                synchronized (calendar) {
                    cal.clear();
                    cal.setLenient(true);
                    if (parts[0] == -1) {
                        cal.set(1970, 0, 1, parts[0] * parts[1], parts[0] * parts[2], parts[0] * parts[3] - 1);
                        t = new Time(cal.getTimeInMillis() + (long)(1000 - parts[4]));
                    } else {
                        cal.set(1970, 0, 1, parts[1], parts[2], parts[3]);
                        t = new Time(cal.getTimeInMillis() + (long)(parts[4] / 1000000));
                    }
                }
                return t;
            }
            case TIME: {
                boolean negate = buf.readByte() == 1;
                long dayOfMonth = buf.readUnsignedInt();
                hour = buf.readByte();
                minutes = buf.readByte();
                seconds = buf.readByte();
                if (length > 8) {
                    microseconds = buf.readUnsignedInt();
                }
                int offset = cal.getTimeZone().getOffset(0L);
                long timeInMillis = ((24L * dayOfMonth + (long)hour) * 3600000L + (long)(minutes * 60000) + (long)(seconds * 1000) + microseconds / 1000L) * (long)(negate ? -1 : 1) - (long)offset;
                return new Time(timeInMillis);
            }
            case TIMESTAMP: 
            case DATETIME: {
                if (length == 0) {
                    return null;
                }
                buf.skip(3);
                buf.readByte();
                if (length > 4) {
                    hour = buf.readByte();
                    minutes = buf.readByte();
                    seconds = buf.readByte();
                    if (length > 7) {
                        microseconds = buf.readUnsignedInt();
                    }
                }
                Calendar calendar = cal;
                synchronized (calendar) {
                    cal.clear();
                    cal.set(1970, 0, 1, hour, minutes, seconds);
                    return new Time(cal.getTimeInMillis() + microseconds / 1000L);
                }
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object val, Calendar providedCal, Long maxLen) throws IOException {
        Calendar cal = providedCal == null ? Calendar.getInstance() : providedCal;
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
        sdf.setTimeZone(cal.getTimeZone());
        String dateString = sdf.format(val);
        encoder.writeByte(39);
        encoder.writeAscii(dateString);
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar providedCal, Long maxLength) throws IOException {
        Calendar cal = providedCal == null ? Calendar.getInstance() : providedCal;
        cal.setTime((Time)value);
        cal.set(5, 1);
        if (cal.get(14) > 0) {
            encoder.writeByte(12);
            encoder.writeByte(0);
            encoder.writeInt(0);
            encoder.writeByte((byte)cal.get(11));
            encoder.writeByte((byte)cal.get(12));
            encoder.writeByte((byte)cal.get(13));
            encoder.writeInt(cal.get(14) * 1000);
        } else {
            encoder.writeByte(8);
            encoder.writeByte(0);
            encoder.writeInt(0);
            encoder.writeByte((byte)cal.get(11));
            encoder.writeByte((byte)cal.get(12));
            encoder.writeByte((byte)cal.get(13));
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.TIME.get();
    }
}

