/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.plugin.Codec;
import org.mariadb.jdbc.plugin.codec.LongCodec;

public class ByteCodec
implements Codec<Byte> {
    public static final ByteCodec INSTANCE = new ByteCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TINYINT, new DataType[]{DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.BIGINT, DataType.YEAR, DataType.BIT, DataType.FLOAT, DataType.DOUBLE, DataType.OLDDECIMAL, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB, DataType.DECIMAL, DataType.ENUM, DataType.VARSTRING, DataType.STRING, DataType.VARCHAR});

    public static long parseBit(ReadableByteBuf buf, int length) {
        if (length == 1) {
            return buf.readUnsignedByte();
        }
        long val = 0L;
        int idx = 0;
        do {
            val += (long)buf.readUnsignedByte() << 8 * length;
        } while (++idx < length);
        return val;
    }

    @Override
    public String className() {
        return Byte.class.getName();
    }

    @Override
    public boolean canDecode(Column column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Byte.TYPE || type.isAssignableFrom(Byte.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Byte;
    }

    @Override
    public Byte decodeText(ReadableByteBuf buffer, int length, Column column, Calendar cal) throws SQLDataException {
        return this.decodeTextByte(buffer, length, column);
    }

    public byte decodeTextByte(ReadableByteBuf buf, int length, Column column) throws SQLDataException {
        long result;
        switch (column.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INTEGER: 
            case BIGINT: 
            case YEAR: {
                result = LongCodec.parseNotEmpty(buf, length);
                break;
            }
            case BIT: {
                byte val = buf.readByte();
                if (length > 1) {
                    buf.skip(length - 1);
                }
                return val;
            }
            case FLOAT: 
            case DOUBLE: 
            case OLDDECIMAL: 
            case DECIMAL: 
            case ENUM: 
            case VARCHAR: 
            case VARSTRING: 
            case STRING: {
                String str = buf.readString(length);
                try {
                    result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).byteValueExact();
                    break;
                }
                catch (ArithmeticException | NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{str, column.getType()}));
                }
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (!column.isBinary()) {
                    String str2 = buf.readString(length);
                    try {
                        result = new BigDecimal(str2).setScale(0, RoundingMode.DOWN).byteValueExact();
                        break;
                    }
                    catch (ArithmeticException | NumberFormatException nfe) {
                        throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{str2, column.getType()}));
                    }
                }
                if (length > 0) {
                    byte b = buf.readByte();
                    buf.skip(length - 1);
                    return b;
                }
                throw new SQLDataException("empty String value cannot be decoded as Byte");
            }
            default: {
                buf.skip(length);
                throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{column.getType()}));
            }
        }
        if ((long)((byte)result) != result || result < 0L && !column.isSigned()) {
            throw new SQLDataException("byte overflow");
        }
        return (byte)result;
    }

    @Override
    public Byte decodeBinary(ReadableByteBuf buffer, int length, Column column, Calendar cal) throws SQLDataException {
        return this.decodeBinaryByte(buffer, length, column);
    }

    public byte decodeBinaryByte(ReadableByteBuf buf, int length, Column column) throws SQLDataException {
        long result;
        switch (column.getType()) {
            case TINYINT: {
                result = column.isSigned() ? (long)buf.readByte() : (long)buf.readUnsignedByte();
                break;
            }
            case SMALLINT: 
            case YEAR: {
                result = column.isSigned() ? (long)buf.readShort() : (long)buf.readUnsignedShort();
                break;
            }
            case MEDIUMINT: {
                result = column.isSigned() ? (long)buf.readMedium() : (long)buf.readUnsignedMedium();
                buf.skip();
                break;
            }
            case INTEGER: {
                result = column.isSigned() ? (long)buf.readInt() : buf.readUnsignedInt();
                break;
            }
            case BIGINT: {
                if (column.isSigned()) {
                    result = buf.readLong();
                    break;
                }
                byte[] bb = new byte[8];
                for (int i = 7; i >= 0; --i) {
                    bb[i] = buf.readByte();
                }
                BigInteger val = new BigInteger(1, bb);
                try {
                    result = val.longValueExact();
                    break;
                }
                catch (ArithmeticException | NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{val, column.getType()}));
                }
            }
            case BIT: {
                byte val = buf.readByte();
                if (length > 1) {
                    buf.skip(length - 1);
                }
                return val;
            }
            case FLOAT: {
                result = (long)buf.readFloat();
                break;
            }
            case DOUBLE: {
                result = (long)buf.readDouble();
                break;
            }
            case OLDDECIMAL: 
            case DECIMAL: 
            case ENUM: 
            case VARCHAR: 
            case VARSTRING: 
            case STRING: {
                String str = buf.readString(length);
                try {
                    result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValue();
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{str, column.getType()}));
                }
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (!column.isBinary()) {
                    String str2 = buf.readString(length);
                    try {
                        result = new BigDecimal(str2).setScale(0, RoundingMode.DOWN).longValue();
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{str2, column.getType()}));
                    }
                }
                if (length > 0) {
                    byte b = buf.readByte();
                    buf.skip(length - 1);
                    return b;
                }
                throw new SQLDataException("empty String value cannot be decoded as Byte");
            }
            default: {
                buf.skip(length);
                throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{column.getType()}));
            }
        }
        if ((long)((byte)result) != result) {
            throw new SQLDataException("byte overflow");
        }
        return (byte)result;
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeAscii(Integer.toString(((Byte)value).byteValue()));
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeByte(((Byte)value).byteValue());
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.TINYINT.get();
    }
}

