/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.column;

import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.column.UnsignedSmallIntColumn;

public class YearColumn
extends UnsignedSmallIntColumn {
    public YearColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return conf.yearIsDateType() ? Date.class.getName() : Short.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return conf.yearIsDateType() ? 91 : 5;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return "YEAR";
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        if (conf.yearIsDateType()) {
            short y = (short)buf.atoull(length);
            if (this.columnLength == 2L) {
                y = y <= 69 ? (short)(y + 2000) : (short)(y + 1900);
            }
            return Date.valueOf(y + "-01-01");
        }
        return this.decodeShortText(buf, length);
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        if (conf.yearIsDateType()) {
            int v = buf.readShort();
            if (this.columnLength == 2L) {
                v = v <= 69 ? (v += 2000) : (v += 1900);
            }
            return Date.valueOf(v + "-01-01");
        }
        return this.decodeShortText(buf, length);
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        short y = (short)buf.atoll(length);
        if (this.columnLength == 2L) {
            y = y <= 69 ? (short)(y + 2000) : (short)(y + 1900);
        }
        return Date.valueOf(y + "-01-01");
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        int v = buf.readShort();
        if (this.columnLength == 2L) {
            v = v <= 69 ? (v += 2000) : (v += 1900);
        }
        return Date.valueOf(v + "-01-01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, int length, Calendar calParam) throws SQLDataException {
        Calendar cal1 = calParam == null ? Calendar.getInstance() : calParam;
        int year = Integer.parseInt(buf.readAscii(length));
        if (this.columnLength <= 2L) {
            year += year >= 70 ? 1900 : 2000;
        }
        Calendar calendar = cal1;
        synchronized (calendar) {
            cal1.clear();
            cal1.set(year, 0, 1);
            return new Timestamp(cal1.getTimeInMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, int length, Calendar calParam) throws SQLDataException {
        Timestamp timestamp;
        Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
        int year = buf.readUnsignedShort();
        if (this.columnLength <= 2L) {
            year += year >= 70 ? 1900 : 2000;
        }
        Calendar calendar = cal;
        synchronized (calendar) {
            cal.clear();
            cal.set(year, 0, 1, 0, 0, 0);
            timestamp = new Timestamp(cal.getTimeInMillis());
        }
        timestamp.setNanos(0);
        return timestamp;
    }
}

