/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.Connection;
import org.mariadb.jdbc.Statement;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ServerVersion;
import org.mariadb.jdbc.client.result.CompleteResult;
import org.mariadb.jdbc.util.VersionFactory;
import org.mariadb.jdbc.util.constants.CatalogTerm;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    public static final String DRIVER_NAME = "MariaDB Connector/J";
    private final Connection connection;
    private final Configuration conf;

    public DatabaseMetaData(Connection connection, Configuration conf) {
        this.connection = connection;
        this.conf = conf;
    }

    private static String DataTypeClause(Configuration conf) {
        String upperCaseWithoutSize = " UCASE(IF( COLUMN_TYPE LIKE '%(%)%', CONCAT(SUBSTRING( COLUMN_TYPE,1, LOCATE('(',COLUMN_TYPE) - 1 ), SUBSTRING(COLUMN_TYPE ,1+locate(')', COLUMN_TYPE))), COLUMN_TYPE))";
        if (conf.tinyInt1isBit()) {
            upperCaseWithoutSize = " IF(COLUMN_TYPE like 'tinyint(1)%', '" + (conf.transformedBitIsBoolean() ? "BOOLEAN" : "BIT") + "', " + upperCaseWithoutSize + ")";
        }
        if (!conf.yearIsDateType()) {
            return " IF(COLUMN_TYPE IN ('year(2)', 'year(4)'), 'SMALLINT', " + upperCaseWithoutSize + ")";
        }
        return upperCaseWithoutSize;
    }

    private static int skipWhiteSpace(char[] part, int startPos) {
        for (int i = startPos; i < part.length; ++i) {
            if (Character.isWhitespace(part[i])) continue;
            return i;
        }
        return part.length;
    }

    private static int parseIdentifier(char[] part, int startPos, Identifier identifier) throws ParseException {
        int pos = DatabaseMetaData.skipWhiteSpace(part, startPos);
        if (part[pos] != '`') {
            throw new ParseException(new String(part), pos);
        }
        ++pos;
        StringBuilder sb = new StringBuilder();
        int quotes = 0;
        while (pos < part.length) {
            char ch = part[pos];
            if (ch == '`') {
                ++quotes;
            } else {
                for (int j = 0; j < quotes / 2; ++j) {
                    sb.append('`');
                }
                if (quotes % 2 == 1) {
                    if (ch == '.') {
                        if (identifier.schema != null) {
                            throw new ParseException(new String(part), pos);
                        }
                        identifier.schema = sb.toString();
                        return DatabaseMetaData.parseIdentifier(part, pos + 1, identifier);
                    }
                    identifier.name = sb.toString();
                    return pos;
                }
                quotes = 0;
                sb.append(ch);
            }
            ++pos;
        }
        throw new ParseException(new String(part), startPos);
    }

    private static int skipKeyword(char[] part, int startPos, String keyword) throws ParseException {
        int pos = DatabaseMetaData.skipWhiteSpace(part, startPos);
        int i = 0;
        while (i < keyword.length()) {
            if (part[pos] != keyword.charAt(i)) {
                throw new ParseException(new String(part), pos);
            }
            ++i;
            ++pos;
        }
        return pos;
    }

    private static int getImportedKeyAction(String actionKey) {
        if (actionKey == null) {
            return 1;
        }
        switch (actionKey) {
            case "NO ACTION": {
                return 3;
            }
            case "CASCADE": {
                return 0;
            }
            case "SET NULL": {
                return 2;
            }
            case "SET DEFAULT": {
                return 4;
            }
            case "RESTRICT": {
                return 1;
            }
        }
        throw new IllegalArgumentException("Illegal key action '" + actionKey + "' specified.");
    }

    private static String quoteIdentifier(String string) {
        return "`" + string.replaceAll("`", "``") + "`";
    }

    public static String escapeString(String value, boolean noBackslashEscapes) {
        if (noBackslashEscapes) {
            return value.replace("'", "''");
        }
        return value.replace("\\", "\\\\").replace("'", "\\'").replace("\u0000", "\\0").replace("\"", "\\\"");
    }

    private int parseIdentifierList(char[] part, int startPos, List<Identifier> list) throws ParseException {
        int pos = DatabaseMetaData.skipWhiteSpace(part, startPos);
        if (part[pos] != '(') {
            throw new ParseException(new String(part), pos);
        }
        ++pos;
        block5: while (true) {
            pos = DatabaseMetaData.skipWhiteSpace(part, pos);
            char ch = part[pos];
            switch (ch) {
                case ')': {
                    return pos + 1;
                }
                case '`': {
                    Identifier id = new Identifier();
                    pos = DatabaseMetaData.parseIdentifier(part, pos, id);
                    list.add(id);
                    continue block5;
                }
                case ',': {
                    ++pos;
                    continue block5;
                }
            }
            break;
        }
        throw new ParseException(new String(part, startPos, part.length - startPos), startPos);
    }

    private ResultSet getImportedKeys(String tableDef, String tableName, String database, Connection connection) throws Exception {
        boolean importedKeysWithConstraintNames = Boolean.parseBoolean(this.conf.nonMappedOptions().getProperty("importedKeysWithConstraintNames", "true"));
        String[] columnNames = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        DataType[] dataTypes = new DataType[]{DataType.VARCHAR, DataType.NULL, DataType.VARCHAR, DataType.VARCHAR, DataType.VARCHAR, DataType.NULL, DataType.VARCHAR, DataType.VARCHAR, DataType.SMALLINT, DataType.SMALLINT, DataType.SMALLINT, DataType.VARCHAR, DataType.VARCHAR, DataType.SMALLINT};
        String[] parts = tableDef.split("\n");
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (String part : parts) {
            if (!(part = part.trim()).toUpperCase(Locale.ROOT).startsWith("CONSTRAINT") && !part.toUpperCase(Locale.ROOT).contains("FOREIGN KEY")) continue;
            char[] partChar = part.toCharArray();
            Identifier constraintName = new Identifier();
            int pos = DatabaseMetaData.skipKeyword(partChar, 0, "CONSTRAINT");
            pos = DatabaseMetaData.parseIdentifier(partChar, pos, constraintName);
            pos = DatabaseMetaData.skipKeyword(partChar, pos, "FOREIGN KEY");
            ArrayList<Identifier> foreignKeyCols = new ArrayList<Identifier>();
            pos = this.parseIdentifierList(partChar, pos, foreignKeyCols);
            pos = DatabaseMetaData.skipKeyword(partChar, pos, "REFERENCES");
            Identifier pkTable = new Identifier();
            pos = DatabaseMetaData.parseIdentifier(partChar, pos, pkTable);
            ArrayList<Identifier> primaryKeyCols = new ArrayList<Identifier>();
            this.parseIdentifierList(partChar, pos, primaryKeyCols);
            int onUpdateReferenceAction = 1;
            int onDeleteReferenceAction = 1;
            for (String referenceAction : new String[]{"RESTRICT", "CASCADE", "SET NULL", "NO ACTION", "SET DEFAULT"}) {
                if (part.toUpperCase(Locale.ROOT).contains("ON UPDATE " + referenceAction)) {
                    onUpdateReferenceAction = DatabaseMetaData.getImportedKeyAction(referenceAction);
                }
                if (!part.toUpperCase(Locale.ROOT).contains("ON DELETE " + referenceAction)) continue;
                onDeleteReferenceAction = DatabaseMetaData.getImportedKeyAction(referenceAction);
            }
            HashMap<String, Map<String[], String>> externalInfos = new HashMap<String, Map<String[], String>>();
            for (int i = 0; i < primaryKeyCols.size(); ++i) {
                String[] row = new String[columnNames.length];
                String string = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? (pkTable.schema == null ? database : pkTable.schema) : (row[0] = "def");
                row[1] = this.conf.useCatalogTerm() == CatalogTerm.UseSchema ? (pkTable.schema == null ? database : pkTable.schema) : null;
                row[2] = pkTable.name;
                row[3] = ((Identifier)primaryKeyCols.get((int)i)).name;
                row[4] = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? database : "def";
                row[5] = this.conf.useCatalogTerm() == CatalogTerm.UseSchema ? database : null;
                row[6] = tableName;
                row[7] = ((Identifier)foreignKeyCols.get((int)i)).name;
                row[8] = Integer.toString(i + 1);
                row[9] = Integer.toString(onUpdateReferenceAction);
                row[10] = Integer.toString(onDeleteReferenceAction);
                row[11] = constraintName.name;
                if (importedKeysWithConstraintNames) {
                    String ext = (pkTable.schema == null ? "" : DatabaseMetaData.quoteIdentifier(pkTable.schema) + ".") + DatabaseMetaData.quoteIdentifier(pkTable.name);
                    if (!externalInfos.containsKey(ext)) {
                        externalInfos.put(ext, this.getExtImportedKeys(ext, connection));
                    }
                    row[12] = null;
                    Map externalInfo = (Map)externalInfos.get(ext);
                    if (externalInfo != null) {
                        for (Map.Entry entry : externalInfo.entrySet()) {
                            boolean foundAll = true;
                            for (String keyPart : (String[])entry.getKey()) {
                                boolean foundKey = false;
                                for (Identifier keyCol : primaryKeyCols) {
                                    if (!keyCol.name.equals(keyPart)) continue;
                                    foundKey = true;
                                    break;
                                }
                                if (foundKey) continue;
                                foundAll = false;
                                break;
                            }
                            if (!foundAll) continue;
                            row[12] = (String)entry.getValue();
                        }
                    }
                } else {
                    row[12] = null;
                }
                row[13] = Integer.toString(7);
                data.add(row);
            }
        }
        String[][] arr = (String[][])data.toArray((T[])new String[0][]);
        Arrays.sort(arr, (row1, row2) -> {
            int result = 0;
            if (row1[0] != null) {
                result = row1[0].compareTo(row2[0]);
            }
            if (result == 0) {
                if (row1[1] != null) {
                    result = row1[1].compareTo(row2[1]);
                }
                if (result == 0 && (result = row1[2].compareTo(row2[2])) == 0 && (result = row1[8].length() - row2[8].length()) == 0) {
                    result = row1[8].compareTo(row2[8]);
                }
            }
            return result;
        });
        return CompleteResult.createResultSet(columnNames, dataTypes, arr, connection.getContext(), 2, 1004);
    }

    private Map<String[], String> getExtImportedKeys(String tableName, Connection connection) throws SQLException {
        ResultSet rs = connection.createStatement().executeQuery("SHOW CREATE TABLE " + tableName);
        rs.next();
        String refTableDef = rs.getString(2);
        HashMap<String[], String> res = new HashMap<String[], String>();
        String[] parts = refTableDef.split("\n");
        for (int i = 1; i < parts.length - 1; ++i) {
            String part = parts[i].trim();
            if (part.startsWith("`") || !part.startsWith("PRIMARY KEY") && !part.startsWith("UNIQUE KEY")) continue;
            String name = "PRIMARY";
            if (part.indexOf("`") < part.indexOf("(")) {
                int offset = part.indexOf("`");
                name = part.substring(offset + 1, part.indexOf("`", offset + 1));
            }
            String subPart = part.substring(part.indexOf("(") + 1, part.lastIndexOf(")"));
            ArrayList<String> cols = new ArrayList<String>();
            int pos = 0;
            while (pos < subPart.length()) {
                pos = subPart.indexOf("`", pos);
                int endpos = subPart.indexOf("`", pos + 1);
                cols.add(subPart.substring(pos + 1, endpos));
                pos = endpos + 1;
            }
            res.put(cols.toArray(new String[0]), name);
        }
        return res;
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String database;
        if (table == null) {
            throw new SQLException("'table' parameter in getImportedKeys cannot be null");
        }
        String string = database = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? catalog : schema;
        if (database == null || database.isEmpty()) {
            return this.getImportedKeysUsingInformationSchema(database, table);
        }
        try {
            return this.getImportedKeysUsingShowCreateTable(database, table);
        }
        catch (Exception e) {
            return this.getImportedKeysUsingInformationSchema(database, table);
        }
    }

    private String dataTypeClause(String fullTypeColumnName) {
        return " CASE data_type WHEN 'bit' THEN -7 WHEN 'tinyblob' THEN -3 WHEN 'mediumblob' THEN -4 WHEN 'longblob' THEN -4 WHEN 'blob' THEN -4 WHEN 'tinytext' THEN 12 WHEN 'mediumtext' THEN -1 WHEN 'longtext' THEN -1 WHEN 'text' THEN -1 WHEN 'date' THEN 91 WHEN 'datetime' THEN 93 WHEN 'decimal' THEN 3 WHEN 'double' THEN 8 WHEN 'enum' THEN 12 WHEN 'float' THEN 7 WHEN 'int' THEN IF( " + fullTypeColumnName + " like '%unsigned%', " + 4 + "," + 4 + ") WHEN 'bigint' THEN " + -5 + " WHEN 'mediumint' THEN " + 4 + " WHEN 'null' THEN " + 0 + " WHEN 'set' THEN " + 12 + " WHEN 'smallint' THEN IF( " + fullTypeColumnName + " like '%unsigned%', " + 5 + "," + 5 + ") WHEN 'varchar' THEN " + 12 + " WHEN 'varbinary' THEN " + -3 + " WHEN 'char' THEN " + 1 + " WHEN 'binary' THEN " + -2 + " WHEN 'time' THEN " + 92 + " WHEN 'timestamp' THEN " + 93 + " WHEN 'tinyint' THEN " + (this.conf.tinyInt1isBit() ? "IF(" + fullTypeColumnName + " like 'tinyint(1)%'," + (this.conf.transformedBitIsBoolean() ? 16 : -7) + "," + -6 + ") " : Integer.valueOf(-6)) + " WHEN 'year' THEN " + (this.conf.yearIsDateType() ? 91 : 5) + " ELSE " + 1111 + " END ";
    }

    private ResultSet executeQuery(String sql) throws SQLException {
        Statement stmt = this.connection.createStatement(1004, 1007);
        CompleteResult rs = (CompleteResult)stmt.executeQuery(sql);
        rs.setStatement(null);
        rs.useAliasAsName();
        return rs;
    }

    private String escapeQuote(String value) {
        return value == null ? "null" : "'" + DatabaseMetaData.escapeString(value, (this.connection.getContext().getServerStatus() & 0x200) > 0) + "'";
    }

    private boolean databaseCond(boolean firstCondition, StringBuilder sb, String columnName, String database, boolean usePattern) {
        if (database == null || "%".equals(database) && usePattern) {
            return firstCondition;
        }
        if (database.isEmpty()) {
            sb.append(firstCondition ? " WHERE " : " AND ").append(columnName).append(" = database()");
            return false;
        }
        sb.append(firstCondition ? " WHERE " : " AND ").append(columnName).append(!usePattern || database.indexOf(37) == -1 && database.indexOf(95) == -1 ? "=" : " LIKE ").append(this.escapeQuote(database));
        return false;
    }

    private boolean patternCond(boolean firstCondition, StringBuilder sb, String columnName, String tableName) {
        if (tableName == null || "%".equals(tableName)) {
            return firstCondition;
        }
        sb.append(firstCondition ? " WHERE " : " AND ").append(columnName).append(tableName.indexOf(37) == -1 && tableName.indexOf(95) == -1 ? "=" : " LIKE ").append("'").append(DatabaseMetaData.escapeString(tableName, (this.connection.getContext().getServerStatus() & 0x200) != 0)).append("'");
        return false;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        StringBuilder sb = new StringBuilder("SELECT ").append(this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? "A.TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM" : "A.TABLE_CATALOG TABLE_CAT, A.TABLE_SCHEMA TABLE_SCHEM").append(", A.TABLE_NAME, A.COLUMN_NAME, B.SEQ_IN_INDEX KEY_SEQ, B.INDEX_NAME PK_NAME  FROM INFORMATION_SCHEMA.COLUMNS A, INFORMATION_SCHEMA.STATISTICS B WHERE A.COLUMN_KEY in ('PRI','pri') AND B.INDEX_NAME='PRIMARY'");
        String database = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? catalog : schema;
        this.databaseCond(false, sb, "A.TABLE_SCHEMA", database, false);
        this.databaseCond(false, sb, "B.TABLE_SCHEMA", database, false);
        this.patternCond(false, sb, "A.TABLE_NAME", table);
        this.patternCond(false, sb, "B.TABLE_NAME", table);
        sb.append(" AND A.TABLE_SCHEMA = B.TABLE_SCHEMA AND A.TABLE_NAME = B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME ORDER BY A.COLUMN_NAME");
        return this.executeQuery(sb.toString());
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        StringBuilder sb = new StringBuilder("SELECT TABLE_SCHEMA TABLE_CAT, NULL  TABLE_SCHEM,  TABLE_NAME, IF(TABLE_TYPE='BASE TABLE' or TABLE_TYPE='SYSTEM VERSIONED', 'TABLE', IF(TABLE_TYPE='TEMPORARY', 'LOCAL TEMPORARY', TABLE_TYPE)) as TABLE_TYPE, TABLE_COMMENT REMARKS, NULL TYPE_CAT, NULL TYPE_SCHEM, NULL TYPE_NAME, NULL SELF_REFERENCING_COL_NAME,  NULL REF_GENERATION FROM INFORMATION_SCHEMA.TABLES");
        String database = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? catalog : schemaPattern;
        boolean firstCondition = this.databaseCond(true, sb, "TABLE_SCHEMA", database, this.conf.useCatalogTerm() == CatalogTerm.UseSchema);
        firstCondition = this.patternCond(firstCondition, sb, "TABLE_NAME", tableNamePattern);
        if (types != null && types.length > 0) {
            boolean mustAddType = false;
            StringBuilder sqlType = new StringBuilder((firstCondition ? " WHERE " : " AND ") + " TABLE_TYPE IN (");
            block8: for (String s : types) {
                if (s == null) continue;
                if (mustAddType) {
                    sqlType.append(",");
                }
                mustAddType = true;
                switch (s) {
                    case "TABLE": {
                        sqlType.append("'BASE TABLE','SYSTEM VERSIONED'");
                        continue block8;
                    }
                    case "LOCAL TEMPORARY": {
                        sqlType.append("'TEMPORARY'");
                        continue block8;
                    }
                    default: {
                        sqlType.append(this.escapeQuote(s));
                    }
                }
            }
            sqlType.append(")");
            if (mustAddType) {
                sb.append((CharSequence)sqlType);
            }
        }
        sb.append(" ORDER BY TABLE_TYPE, TABLE_SCHEMA, TABLE_NAME");
        return this.executeQuery(sb.toString());
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ServerVersion version = this.connection.getContext().getVersion();
        boolean supportsFractionalSeconds = version.isMariaDBServer() ? version.versionGreaterOrEqual(5, 3, 0) : version.versionGreaterOrEqual(5, 6, 4);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? "TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM" : "TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM").append(", TABLE_NAME, COLUMN_NAME,").append(this.dataTypeClause("COLUMN_TYPE")).append(" DATA_TYPE,").append(DatabaseMetaData.DataTypeClause(this.conf)).append(" TYPE_NAME, CASE DATA_TYPE WHEN 'date' THEN 10");
        if (supportsFractionalSeconds) {
            sb.append("  WHEN 'time' THEN IF(DATETIME_PRECISION = 0, 10, CAST(11 + DATETIME_PRECISION as signed integer))  WHEN 'datetime' THEN IF(DATETIME_PRECISION = 0, 19, CAST(20 + DATETIME_PRECISION as signed integer))  WHEN 'timestamp' THEN IF(DATETIME_PRECISION = 0, 19, CAST(20 + DATETIME_PRECISION as signed integer))");
        } else {
            sb.append(" WHEN 'time' THEN 10 WHEN 'datetime' THEN 19 WHEN 'timestamp' THEN 19");
        }
        sb.append(this.conf.yearIsDateType() ? "" : " WHEN 'year' THEN 5").append("  ELSE   IF(NUMERIC_PRECISION IS NULL, LEAST(CHARACTER_MAXIMUM_LENGTH,2147483647), NUMERIC_PRECISION)  END COLUMN_SIZE, 65535 BUFFER_LENGTH,  CONVERT (CASE DATA_TYPE WHEN 'year' THEN ").append(this.conf.yearIsDateType() ? "NUMERIC_SCALE" : "0").append(" WHEN 'tinyint' THEN ").append(this.conf.tinyInt1isBit() ? "0" : "NUMERIC_SCALE").append(" ELSE NUMERIC_SCALE END, UNSIGNED INTEGER) DECIMAL_DIGITS, 10 NUM_PREC_RADIX, IF(IS_NULLABLE = 'yes',1,0) NULLABLE,COLUMN_COMMENT REMARKS, COLUMN_DEFAULT COLUMN_DEF, 0 SQL_DATA_TYPE, 0 SQL_DATETIME_SUB,   LEAST(CHARACTER_OCTET_LENGTH,2147483647) CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE, NULL SCOPE_CATALOG, NULL SCOPE_SCHEMA, NULL SCOPE_TABLE, NULL SOURCE_DATA_TYPE, IF(EXTRA = 'auto_increment','YES','NO') IS_AUTOINCREMENT,  IF(EXTRA in ('VIRTUAL', 'PERSISTENT', 'VIRTUAL GENERATED', 'STORED GENERATED') ,'YES','NO') IS_GENERATEDCOLUMN  FROM INFORMATION_SCHEMA.COLUMNS");
        String database = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? catalog : schemaPattern;
        boolean firstCondition = this.databaseCond(true, sb, "TABLE_SCHEMA", database, this.conf.useCatalogTerm() == CatalogTerm.UseSchema);
        firstCondition = this.patternCond(firstCondition, sb, "TABLE_NAME", tableNamePattern);
        this.patternCond(firstCondition, sb, "COLUMN_NAME", columnNamePattern);
        sb.append(" ORDER BY TABLE_CAT, TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION");
        return this.executeQuery(sb.toString());
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        StringBuilder sb = new StringBuilder("SELECT ").append(this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? "KCU.REFERENCED_TABLE_SCHEMA PKTABLE_CAT, NULL PKTABLE_SCHEM" : "KCU.CONSTRAINT_CATALOG PKTABLE_CAT, KCU.REFERENCED_TABLE_SCHEMA PKTABLE_SCHEM").append(",  KCU.REFERENCED_TABLE_NAME PKTABLE_NAME, KCU.REFERENCED_COLUMN_NAME PKCOLUMN_NAME, ").append(this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? "KCU.TABLE_SCHEMA FKTABLE_CAT, NULL FKTABLE_SCHEM" : " TABLE_CATALOG FKTABLE_CAT, KCU.TABLE_SCHEMA FKTABLE_SCHEM").append(", KCU.TABLE_NAME FKTABLE_NAME, KCU.COLUMN_NAME FKCOLUMN_NAME, KCU.POSITION_IN_UNIQUE_CONSTRAINT KEY_SEQ, CASE update_rule    WHEN 'RESTRICT' THEN 1   WHEN 'NO ACTION' THEN 3   WHEN 'CASCADE' THEN 0   WHEN 'SET NULL' THEN 2   WHEN 'SET DEFAULT' THEN 4 END UPDATE_RULE, CASE DELETE_RULE  WHEN 'RESTRICT' THEN 1  WHEN 'NO ACTION' THEN 3  WHEN 'CASCADE' THEN 0  WHEN 'SET NULL' THEN 2  WHEN 'SET DEFAULT' THEN 4 END DELETE_RULE, RC.CONSTRAINT_NAME FK_NAME, RC.UNIQUE_CONSTRAINT_NAME PK_NAME,7 DEFERRABILITY FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE KCU INNER JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS RC ON KCU.CONSTRAINT_SCHEMA = RC.CONSTRAINT_SCHEMA AND KCU.CONSTRAINT_NAME = RC.CONSTRAINT_NAME");
        String database = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? catalog : schema;
        boolean firstCondition = this.databaseCond(true, sb, "KCU.REFERENCED_TABLE_SCHEMA", database, this.conf.useCatalogTerm() == CatalogTerm.UseSchema);
        this.patternCond(firstCondition, sb, "KCU.REFERENCED_TABLE_NAME", table);
        sb.append(" ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
        return this.executeQuery(sb.toString());
    }

    public ResultSet getImportedKeysUsingInformationSchema(String database, String table) throws SQLException {
        if (table == null) {
            throw new SQLException("'table' parameter in getImportedKeys cannot be null");
        }
        StringBuilder sb = new StringBuilder("SELECT ").append(this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? "KCU.REFERENCED_TABLE_SCHEMA PKTABLE_CAT, NULL PKTABLE_SCHEM" : "KCU.TABLE_CATALOG PKTABLE_CAT, KCU.REFERENCED_TABLE_SCHEMA PKTABLE_SCHEM").append(",  KCU.REFERENCED_TABLE_NAME PKTABLE_NAME, KCU.REFERENCED_COLUMN_NAME PKCOLUMN_NAME, ").append(this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? "KCU.TABLE_SCHEMA FKTABLE_CAT, NULL FKTABLE_SCHEM" : "KCU.TABLE_CATALOG FKTABLE_CAT, KCU.TABLE_SCHEMA FKTABLE_SCHEM").append(", KCU.TABLE_NAME FKTABLE_NAME, KCU.COLUMN_NAME FKCOLUMN_NAME, KCU.POSITION_IN_UNIQUE_CONSTRAINT KEY_SEQ, CASE update_rule    WHEN 'RESTRICT' THEN 1   WHEN 'NO ACTION' THEN 3   WHEN 'CASCADE' THEN 0   WHEN 'SET NULL' THEN 2   WHEN 'SET DEFAULT' THEN 4 END UPDATE_RULE, CASE DELETE_RULE  WHEN 'RESTRICT' THEN 1  WHEN 'NO ACTION' THEN 3  WHEN 'CASCADE' THEN 0  WHEN 'SET NULL' THEN 2  WHEN 'SET DEFAULT' THEN 4 END DELETE_RULE, RC.CONSTRAINT_NAME FK_NAME, RC.UNIQUE_CONSTRAINT_NAME PK_NAME,7 DEFERRABILITY FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE KCU INNER JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS RC ON KCU.CONSTRAINT_SCHEMA = RC.CONSTRAINT_SCHEMA AND KCU.CONSTRAINT_NAME = RC.CONSTRAINT_NAME ");
        boolean firstCondition = this.databaseCond(true, sb, "KCU.TABLE_SCHEMA", database, false);
        sb.append(firstCondition ? " WHERE " : " AND ").append("KCU.TABLE_NAME = ").append(this.escapeQuote(table));
        sb.append(" ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ");
        return this.executeQuery(sb.toString());
    }

    public ResultSet getImportedKeysUsingShowCreateTable(String database, String table) throws Exception {
        ResultSet rs = this.connection.createStatement().executeQuery("SHOW CREATE TABLE " + DatabaseMetaData.quoteIdentifier(database) + "." + DatabaseMetaData.quoteIdentifier(table));
        rs.next();
        String tableDef = rs.getString(2);
        return this.getImportedKeys(tableDef, table, database, this.connection);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        if (table == null) {
            throw new SQLException("'table' parameter cannot be null in getBestRowIdentifier()");
        }
        boolean hasIsGeneratedCol = this.connection.getContext().getVersion().isMariaDBServer() && this.connection.getContext().getVersion().versionGreaterOrEqual(10, 2, 0);
        StringBuilder sbInner = new StringBuilder("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE COLUMN_KEY = 'PRI'");
        String database = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? catalog : schema;
        this.databaseCond(false, sbInner, "TABLE_SCHEMA", database, false);
        sbInner.append(" AND TABLE_NAME = ").append(this.escapeQuote(table));
        StringBuilder sb = new StringBuilder("SELECT 2 SCOPE, COLUMN_NAME," + this.dataTypeClause("COLUMN_TYPE") + " DATA_TYPE, DATA_TYPE TYPE_NAME, IF(NUMERIC_PRECISION IS NULL, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION) COLUMN_SIZE, 0 BUFFER_LENGTH, NUMERIC_SCALE DECIMAL_DIGITS," + (hasIsGeneratedCol ? "IF(IS_GENERATED='NEVER',1,2)" : Integer.valueOf(1)) + " PSEUDO_COLUMN FROM INFORMATION_SCHEMA.COLUMNS WHERE (COLUMN_KEY  = 'PRI' OR (COLUMN_KEY = 'UNI' AND NOT EXISTS (" + sbInner + " )))");
        this.databaseCond(false, sb, "TABLE_SCHEMA", database, false);
        sb.append(" AND TABLE_NAME = ").append(this.escapeQuote(table));
        if (!nullable) {
            sb.append(" AND IS_NULLABLE = 'NO'");
        }
        return this.executeQuery(sb.toString());
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return true;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.connection.createStatement().executeQuery("SELECT ' ' TABLE_CAT, ' ' TABLE_SCHEM, ' ' TABLE_NAME, ' ' COLUMN_NAME, 0 DATA_TYPE, 0 COLUMN_SIZE, 0 DECIMAL_DIGITS, 10 NUM_PREC_RADIX, ' ' COLUMN_USAGE,  ' ' REMARKS, 0 CHAR_OCTET_LENGTH, 'YES' IS_NULLABLE FROM DUAL WHERE 1=0");
    }

    @Override
    public boolean allProceduresAreCallable() {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public String getURL() {
        return this.conf.initialUrl();
    }

    @Override
    public String getUserName() {
        return this.conf.user();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        Statement st = this.connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT @@READ_ONLY");
        rs.next();
        return rs.getInt(1) == 1;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return true;
    }

    @Override
    public String getDatabaseProductName() {
        if (!this.conf.useMysqlMetadata() && this.connection.getContext().getVersion().isMariaDBServer()) {
            return "MariaDB";
        }
        return "MySQL";
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.connection.getContext().getVersion().getVersion();
    }

    @Override
    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    public String getDriverVersion() {
        return VersionFactory.getInstance().getVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return VersionFactory.getInstance().getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return VersionFactory.getInstance().getMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.connection.getLowercaseTableNames() == 0;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.connection.getLowercaseTableNames() == 1;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.connection.getLowercaseTableNames() == 2;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.supportsMixedCaseIdentifiers();
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return this.storesUpperCaseIdentifiers();
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.storesLowerCaseIdentifiers();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.storesMixedCaseIdentifiers();
    }

    @Override
    public String getIdentifierQuoteString() {
        return "`";
    }

    @Override
    public String getSQLKeywords() {
        return "ACCESSIBLE,ANALYZE,ASENSITIVE,BEFORE,BIGINT,BINARY,BLOB,CALL,CHANGE,CONDITION,DATABASE,DATABASES,DAY_HOUR,DAY_MICROSECOND,DAY_MINUTE,DAY_SECOND,DELAYED,DETERMINISTIC,DISTINCTROW,DIV,DUAL,EACH,ELSEIF,ENCLOSED,ESCAPED,EXIT,EXPLAIN,FLOAT4,FLOAT8,FORCE,FULLTEXT,GENERAL,HIGH_PRIORITY,HOUR_MICROSECOND,HOUR_MINUTE,HOUR_SECOND,IF,IGNORE,IGNORE_SERVER_IDS,INDEX,INFILE,INOUT,INT1,INT2,INT3,INT4,INT8,ITERATE,KEY,KEYS,KILL,LEAVE,LIMIT,LINEAR,LINES,LOAD,LOCALTIME,LOCALTIMESTAMP,LOCK,LONG,LONGBLOB,LONGTEXT,LOOP,LOW_PRIORITY,MASTER_HEARTBEAT_PERIOD,MASTER_SSL_VERIFY_SERVER_CERT,MAXVALUE,MEDIUMBLOB,MEDIUMINT,MEDIUMTEXT,MIDDLEINT,MINUTE_MICROSECOND,MINUTE_SECOND,MOD,MODIFIES,NO_WRITE_TO_BINLOG,OPTIMIZE,OPTIONALLY,OUT,OUTFILE,PURGE,RANGE,READ_WRITE,READS,REGEXP,RELEASE,RENAME,REPEAT,REPLACE,REQUIRE,RESIGNAL,RESTRICT,RETURN,RLIKE,SCHEMAS,SECOND_MICROSECOND,SENSITIVE,SEPARATOR,SHOW,SIGNAL,SLOW,SPATIAL,SPECIFIC,SQL_BIG_RESULT,SQL_CALC_FOUND_ROWS,SQL_SMALL_RESULT,SQLEXCEPTION,SSL,STARTING,STRAIGHT_JOIN,TERMINATED,TINYBLOB,TINYINT,TINYTEXT,TRIGGER,UNDO,UNLOCK,UNSIGNED,USE,UTC_DATE,UTC_TIME,UTC_TIMESTAMP,VARBINARY,VARCHARACTER,WHILE,XOR,YEAR_MONTH,ZEROFILL";
    }

    @Override
    public String getNumericFunctions() {
        return "DIV,ABS,ACOS,ASIN,ATAN,ATAN2,CEIL,CEILING,CONV,COS,COT,CRC32,DEGREES,EXP,FLOOR,GREATEST,LEAST,LN,LOG,LOG10,LOG2,MOD,OCT,PI,POW,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    @Override
    public String getStringFunctions() {
        return "ASCII,BIN,BIT_LENGTH,CAST,CHARACTER_LENGTH,CHAR_LENGTH,CONCAT,CONCAT_WS,CONVERT,ELT,EXPORT_SET,EXTRACTVALUE,FIELD,FIND_IN_SET,FORMAT,FROM_BASE64,HEX,INSTR,LCASE,LEFT,LENGTH,LIKE,LOAD_FILE,LOCATE,LOWER,LPAD,LTRIM,MAKE_SET,MATCH AGAINST,MID,NOT LIKE,NOT REGEXP,OCTET_LENGTH,ORD,POSITION,QUOTE,REPEAT,REPLACE,REVERSE,RIGHT,RPAD,RTRIM,SOUNDEX,SOUNDS LIKE,SPACE,STRCMP,SUBSTR,SUBSTRING,SUBSTRING_INDEX,TO_BASE64,TRIM,UCASE,UNHEX,UPDATEXML,UPPER,WEIGHT_STRING";
    }

    @Override
    public String getSystemFunctions() {
        return "DATABASE,USER,SYSTEM_USER,SESSION_USER,LAST_INSERT_ID,VERSION";
    }

    @Override
    public String getTimeDateFunctions() {
        return "ADDDATE,ADDTIME,CONVERT_TZ,CURDATE,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURTIME,DATEDIFF,DATE_ADD,DATE_FORMAT,DATE_SUB,DAY,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,EXTRACT,FROM_DAYS,FROM_UNIXTIME,GET_FORMAT,HOUR,LAST_DAY,LOCALTIME,LOCALTIMESTAMP,MAKEDATE,MAKETIME,MICROSECOND,MINUTE,MONTH,MONTHNAME,NOW,PERIOD_ADD,PERIOD_DIFF,QUARTER,SECOND,SEC_TO_TIME,STR_TO_DATE,SUBDATE,SUBTIME,SYSDATE,TIMEDIFF,TIMESTAMPADD,TIMESTAMPDIFF,TIME_FORMAT,TIME_TO_SEC,TO_DAYS,TO_SECONDS,UNIX_TIMESTAMP,UTC_DATE,UTC_TIME,UTC_TIMESTAMP,WEEK,WEEKDAY,WEEKOFYEAR,YEAR,YEARWEEK";
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "#@";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        switch (fromType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                switch (toType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: {
                        return true;
                    }
                }
                return false;
            }
            case 2004: {
                switch (toType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: {
                        return true;
                    }
                }
                return false;
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                switch (toType) {
                    case -16: 
                    case -15: 
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2004: 
                    case 2005: 
                    case 2011: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 92: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 64;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 64;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 16;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 64;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 256;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 64;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 64;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 256;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 4;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        StringBuilder sb = new StringBuilder("SELECT ").append(this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? "ROUTINE_SCHEMA PROCEDURE_CAT, NULL PROCEDURE_SCHEM" : "ROUTINE_CATALOG PROCEDURE_CAT, ROUTINE_SCHEMA PROCEDURE_SCHEM").append(", ROUTINE_NAME PROCEDURE_NAME, NULL RESERVED1, NULL RESERVED2, NULL RESERVED3, ROUTINE_COMMENT REMARKS, CASE ROUTINE_TYPE   WHEN 'FUNCTION' THEN 2  WHEN 'PROCEDURE' THEN 1  ELSE 0 END PROCEDURE_TYPE, SPECIFIC_NAME  FROM INFORMATION_SCHEMA.ROUTINES ");
        String database = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? catalog : schemaPattern;
        boolean firstCondition = this.databaseCond(true, sb, "ROUTINE_SCHEMA", database, this.conf.useCatalogTerm() == CatalogTerm.UseSchema);
        this.patternCond(firstCondition, sb, "ROUTINE_NAME", procedureNamePattern);
        return this.executeQuery(sb.toString());
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        StringBuilder sb = new StringBuilder("SELECT SPECIFIC_SCHEMA PROCEDURE_CAT, NULL PROCEDURE_SCHEM, SPECIFIC_NAME PROCEDURE_NAME, PARAMETER_NAME COLUMN_NAME,  CASE PARAMETER_MODE   WHEN 'IN' THEN 1  WHEN 'OUT' THEN 4  WHEN 'INOUT' THEN 2  ELSE IF(PARAMETER_MODE IS NULL,5,0) END COLUMN_TYPE," + this.dataTypeClause("DTD_IDENTIFIER") + " DATA_TYPE,DATA_TYPE TYPE_NAME, CASE DATA_TYPE  WHEN 'time' THEN IF(DATETIME_PRECISION = 0, 10, CAST(11 + DATETIME_PRECISION as signed integer))  WHEN 'date' THEN 10  WHEN 'datetime' THEN IF(DATETIME_PRECISION = 0, 19, CAST(20 + DATETIME_PRECISION as signed integer))  WHEN 'timestamp' THEN IF(DATETIME_PRECISION = 0, 19, CAST(20 + DATETIME_PRECISION as signed integer))  ELSE   IF(NUMERIC_PRECISION IS NULL, LEAST(CHARACTER_MAXIMUM_LENGTH," + Integer.MAX_VALUE + "), NUMERIC_PRECISION)  END `PRECISION`, CASE DATA_TYPE  WHEN 'time' THEN IF(DATETIME_PRECISION = 0, 10, CAST(11 + DATETIME_PRECISION as signed integer))  WHEN 'date' THEN 10  WHEN 'datetime' THEN IF(DATETIME_PRECISION = 0, 19, CAST(20 + DATETIME_PRECISION as signed integer))  WHEN 'timestamp' THEN IF(DATETIME_PRECISION = 0, 19, CAST(20 + DATETIME_PRECISION as signed integer))  ELSE   IF(NUMERIC_PRECISION IS NULL, LEAST(CHARACTER_MAXIMUM_LENGTH," + Integer.MAX_VALUE + "), NUMERIC_PRECISION)  END `LENGTH`, CASE DATA_TYPE  WHEN 'time' THEN CAST(DATETIME_PRECISION as signed integer)  WHEN 'datetime' THEN CAST(DATETIME_PRECISION as signed integer)  WHEN 'timestamp' THEN CAST(DATETIME_PRECISION as signed integer)  ELSE NUMERIC_SCALE  END `SCALE`,10 RADIX," + 2 + " NULLABLE,NULL REMARKS,NULL COLUMN_DEF,0 SQL_DATA_TYPE,0 SQL_DATETIME_SUB,CHARACTER_OCTET_LENGTH CHAR_OCTET_LENGTH ,ORDINAL_POSITION, '' IS_NULLABLE, SPECIFIC_NAME  FROM INFORMATION_SCHEMA.PARAMETERS");
        String database = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? catalog : schemaPattern;
        boolean firstCondition = this.databaseCond(true, sb, "SPECIFIC_SCHEMA", database, this.conf.useCatalogTerm() == CatalogTerm.UseCatalog);
        firstCondition = this.patternCond(firstCondition, sb, "SPECIFIC_NAME", procedureNamePattern);
        this.patternCond(firstCondition, sb, "PARAMETER_NAME", columnNamePattern);
        sb.append(" ORDER BY SPECIFIC_SCHEMA, SPECIFIC_NAME, ORDINAL_POSITION");
        return this.executeQuery(sb.toString());
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        StringBuilder sb = new StringBuilder("SELECT ").append(this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? "SPECIFIC_SCHEMA `FUNCTION_CAT`, NULL `FUNCTION_SCHEM`" : "SPECIFIC_CATALOG `FUNCTION_CAT`, SPECIFIC_SCHEMA `FUNCTION_SCHEM`").append(", SPECIFIC_NAME FUNCTION_NAME, PARAMETER_NAME COLUMN_NAME,  CASE PARAMETER_MODE   WHEN 'IN' THEN 1  WHEN 'OUT' THEN 3  WHEN 'INOUT' THEN 2  ELSE 4 END COLUMN_TYPE,").append(this.dataTypeClause("DTD_IDENTIFIER")).append(" DATA_TYPE,DATA_TYPE TYPE_NAME,NUMERIC_PRECISION `PRECISION`,CHARACTER_MAXIMUM_LENGTH LENGTH,NUMERIC_SCALE SCALE,10 RADIX,2 NULLABLE,NULL REMARKS,CHARACTER_OCTET_LENGTH CHAR_OCTET_LENGTH ,ORDINAL_POSITION, '' IS_NULLABLE, SPECIFIC_NAME  FROM INFORMATION_SCHEMA.PARAMETERS");
        String database = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? catalog : schemaPattern;
        boolean firstCondition = this.databaseCond(true, sb, "SPECIFIC_SCHEMA", database, this.conf.useCatalogTerm() == CatalogTerm.UseSchema);
        firstCondition = this.patternCond(firstCondition, sb, "SPECIFIC_NAME", functionNamePattern);
        firstCondition = this.patternCond(firstCondition, sb, "PARAMETER_NAME", columnNamePattern);
        sb.append(firstCondition ? " WHERE " : " AND ").append(" ROUTINE_TYPE='FUNCTION' ORDER BY FUNCTION_CAT, SPECIFIC_NAME, ORDINAL_POSITION");
        return this.executeQuery(sb.toString());
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        if (this.conf.useCatalogTerm() == CatalogTerm.UseSchema) {
            return this.executeQuery("SELECT SCHEMA_NAME as TABLE_SCHEM, CATALOG_NAME as TABLE_CATALOG FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME");
        }
        return this.executeQuery("SELECT '' TABLE_SCHEM, '' TABLE_CATALOG  FROM DUAL WHERE 1=0");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (this.conf.useCatalogTerm() == CatalogTerm.UseSchema) {
            StringBuilder sb = new StringBuilder("SELECT SCHEMA_NAME as TABLE_SCHEM, CATALOG_NAME as TABLE_CATALOG FROM information_schema.SCHEMATA ");
            this.databaseCond(true, sb, "SCHEMA_NAME", schemaPattern, true);
            sb.append(" ORDER BY SCHEMA_NAME");
            return this.executeQuery(sb.toString());
        }
        return this.executeQuery("SELECT  '' table_schem, '' table_catalog FROM DUAL WHERE 1=0");
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        if (this.conf.useCatalogTerm() == CatalogTerm.UseSchema) {
            return this.executeQuery("SELECT null TABLE_CAT FROM DUAL WHERE 1=0");
        }
        return this.executeQuery("SELECT SCHEMA_NAME TABLE_CAT FROM INFORMATION_SCHEMA.SCHEMATA  ORDER BY SCHEMA_NAME");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.executeQuery("SELECT 'TABLE' TABLE_TYPE UNION SELECT 'SYSTEM VIEW' TABLE_TYPE UNION SELECT 'VIEW' TABLE_TYPE UNION SELECT 'LOCAL TEMPORARY' TABLE_TYPE");
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        if (table == null) {
            throw new SQLException("'table' parameter must not be null");
        }
        StringBuilder sb = new StringBuilder("SELECT TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, NULL AS GRANTOR, GRANTEE, PRIVILEGE_TYPE AS PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.COLUMN_PRIVILEGES");
        String database = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? catalog : schema;
        boolean firstCondition = this.databaseCond(true, sb, "TABLE_SCHEMA", database, false);
        sb.append(firstCondition ? " WHERE " : " AND ").append(" TABLE_NAME = ").append(this.escapeQuote(table));
        this.patternCond(false, sb, "COLUMN_NAME", columnNamePattern);
        sb.append(" ORDER BY COLUMN_NAME, PRIVILEGE_TYPE");
        return this.executeQuery(sb.toString());
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        StringBuilder sb = new StringBuilder("SELECT TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM, TABLE_NAME, NULL GRANTOR,GRANTEE, PRIVILEGE_TYPE PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES");
        String database = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? catalog : schemaPattern;
        boolean firstCondition = this.databaseCond(true, sb, "TABLE_SCHEMA", database, this.conf.useCatalogTerm() == CatalogTerm.UseSchema);
        this.patternCond(firstCondition, sb, "TABLE_NAME", tableNamePattern);
        sb.append(" ORDER BY TABLE_SCHEMA, TABLE_NAME,  PRIVILEGE_TYPE ");
        return this.executeQuery(sb.toString());
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String sql = "SELECT 0 SCOPE, ' ' COLUMN_NAME, 0 DATA_TYPE, ' ' TYPE_NAME, 0 COLUMN_SIZE, 0 BUFFER_LENGTH, 0 DECIMAL_DIGITS, 0 PSEUDO_COLUMN  FROM DUAL WHERE 1 = 0";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        StringBuilder sb = new StringBuilder("SELECT ").append(this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? "KCU.REFERENCED_TABLE_SCHEMA PKTABLE_CAT, NULL PKTABLE_SCHEM" : "KCU.TABLE_CATALOG PKTABLE_CAT, KCU.REFERENCED_TABLE_SCHEMA PKTABLE_SCHEM").append(", KCU.REFERENCED_TABLE_NAME PKTABLE_NAME, KCU.REFERENCED_COLUMN_NAME PKCOLUMN_NAME, ").append(this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? "KCU.TABLE_SCHEMA FKTABLE_CAT, NULL FKTABLE_SCHEM" : "KCU.TABLE_CATALOG FKTABLE_CAT, KCU.TABLE_SCHEMA FKTABLE_SCHEM").append(", KCU.TABLE_NAME FKTABLE_NAME, KCU.COLUMN_NAME FKCOLUMN_NAME, KCU.POSITION_IN_UNIQUE_CONSTRAINT KEY_SEQ, CASE update_rule    WHEN 'RESTRICT' THEN 1   WHEN 'NO ACTION' THEN 3   WHEN 'CASCADE' THEN 0   WHEN 'SET NULL' THEN 2   WHEN 'SET DEFAULT' THEN 4 END UPDATE_RULE, CASE DELETE_RULE  WHEN 'RESTRICT' THEN 1  WHEN 'NO ACTION' THEN 3  WHEN 'CASCADE' THEN 0  WHEN 'SET NULL' THEN 2  WHEN 'SET DEFAULT' THEN 4 END DELETE_RULE, RC.CONSTRAINT_NAME FK_NAME, RC.UNIQUE_CONSTRAINT_NAME PK_NAME,7 DEFERRABILITY FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE KCU INNER JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS RC ON KCU.CONSTRAINT_SCHEMA = RC.CONSTRAINT_SCHEMA AND KCU.CONSTRAINT_NAME = RC.CONSTRAINT_NAME ");
        String parentDatabase = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? parentCatalog : parentSchema;
        String foreignDatabase = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? foreignCatalog : foreignSchema;
        boolean firstCondition = this.databaseCond(true, sb, "KCU.REFERENCED_TABLE_SCHEMA", parentDatabase, false);
        firstCondition = this.databaseCond(firstCondition, sb, "KCU.TABLE_SCHEMA", foreignDatabase, false);
        firstCondition = this.patternCond(firstCondition, sb, "KCU.REFERENCED_TABLE_NAME", parentTable);
        this.patternCond(firstCondition, sb, "KCU.TABLE_NAME", foreignTable);
        sb.append("ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
        return this.executeQuery(sb.toString());
    }

    @Override
    public ResultSet getTypeInfo() {
        String[] columnNames = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
        DataType[] dataTypes = new DataType[]{DataType.VARCHAR, DataType.INTEGER, DataType.INTEGER, DataType.VARCHAR, DataType.VARCHAR, DataType.VARCHAR, DataType.INTEGER, DataType.BIT, DataType.SMALLINT, DataType.BIT, DataType.BIT, DataType.BIT, DataType.VARCHAR, DataType.SMALLINT, DataType.SMALLINT, DataType.INTEGER, DataType.INTEGER, DataType.INTEGER};
        String[][] data = new String[][]{{"BIT", "-7", "1", "", "", "", "1", "1", "3", "\u0000", "0", "0", "BIT", "0", "0", "0", "0", "10"}, {"BOOL", "-7", "1", "", "", "", "1", "1", "3", "\u0000", "0", "0", "BOOL", "0", "0", "0", "0", "10"}, {"TINYINT", "-6", "3", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "\u0000", "0", "1", "TINYINT", "0", "0", "0", "0", "10"}, {"TINYINT UNSIGNED", "-6", "3", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "\u0001", "0", "1", "TINYINT UNSIGNED", "0", "0", "0", "0", "10"}, {"BIGINT", "-5", "19", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "\u0000", "0", "1", "BIGINT", "0", "0", "0", "0", "10"}, {"BIGINT UNSIGNED", "-5", "20", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "\u0001", "0", "1", "BIGINT UNSIGNED", "0", "0", "0", "0", "10"}, {"LONG VARBINARY", "-4", "16777215", "'", "'", "", "1", "1", "3", "\u0000", "0", "0", "LONG VARBINARY", "0", "0", "0", "0", "10"}, {"MEDIUMBLOB", "-4", "16777215", "'", "'", "", "1", "1", "3", "\u0000", "0", "0", "MEDIUMBLOB", "0", "0", "0", "0", "10"}, {"LONGBLOB", "-4", "2147483647", "'", "'", "", "1", "1", "3", "\u0000", "0", "0", "LONGBLOB", "0", "0", "0", "0", "10"}, {"BLOB", "-4", "65535", "'", "'", "", "1", "1", "3", "\u0000", "0", "0", "BLOB", "0", "0", "0", "0", "10"}, {"TINYBLOB", "-4", "255", "'", "'", "", "1", "1", "3", "\u0000", "0", "0", "TINYBLOB", "0", "0", "0", "0", "10"}, {"VARBINARY", "-3", "255", "'", "'", "(M)", "1", "1", "3", "\u0000", "0", "0", "VARBINARY", "0", "0", "0", "0", "10"}, {"BINARY", "-2", "255", "'", "'", "(M)", "1", "1", "3", "\u0000", "0", "0", "BINARY", "0", "0", "0", "0", "10"}, {"LONG VARCHAR", "-1", "16777215", "'", "'", "", "1", "0", "3", "\u0000", "0", "0", "LONG VARCHAR", "0", "0", "0", "0", "10"}, {"MEDIUMTEXT", "-1", "16777215", "'", "'", "", "1", "0", "3", "\u0000", "0", "0", "MEDIUMTEXT", "0", "0", "0", "0", "10"}, {"LONGTEXT", "-1", "2147483647", "'", "'", "", "1", "0", "3", "\u0000", "0", "0", "LONGTEXT", "0", "0", "0", "0", "10"}, {"TEXT", "-1", "65535", "'", "'", "", "1", "0", "3", "\u0000", "0", "0", "TEXT", "0", "0", "0", "0", "10"}, {"TINYTEXT", "-1", "255", "'", "'", "", "1", "0", "3", "\u0000", "0", "0", "TINYTEXT", "0", "0", "0", "0", "10"}, {"CHAR", "1", "255", "'", "'", "(M)", "1", "0", "3", "\u0000", "0", "0", "CHAR", "0", "0", "0", "0", "10"}, {"NUMERIC", "2", "65", "", "", "[(M,D])] [ZEROFILL]", "1", "0", "3", "\u0000", "0", "1", "NUMERIC", "-308", "308", "0", "0", "10"}, {"DECIMAL", "3", "65", "", "", "[(M,D])] [ZEROFILL]", "1", "0", "3", "\u0000", "0", "1", "DECIMAL", "-308", "308", "0", "0", "10"}, {"INTEGER", "4", "10", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "\u0000", "0", "1", "INTEGER", "0", "0", "0", "0", "10"}, {"INTEGER UNSIGNED", "4", "10", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "\u0001", "0", "1", "INTEGER UNSIGNED", "0", "0", "0", "0", "10"}, {"INT", "4", "10", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "\u0000", "0", "1", "INT", "0", "0", "0", "0", "10"}, {"INT UNSIGNED", "4", "10", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "\u0001", "0", "1", "INT UNSIGNED", "0", "0", "0", "0", "10"}, {"MEDIUMINT", "4", "7", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "\u0000", "0", "1", "MEDIUMINT", "0", "0", "0", "0", "10"}, {"MEDIUMINT UNSIGNED", "4", "8", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "\u0001", "0", "1", "MEDIUMINT UNSIGNED", "0", "0", "0", "0", "10"}, {"SMALLINT", "5", "5", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "\u0000", "0", "1", "SMALLINT", "0", "0", "0", "0", "10"}, {"SMALLINT UNSIGNED", "5", "5", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "\u0001", "0", "1", "SMALLINT UNSIGNED", "0", "0", "0", "0", "10"}, {"FLOAT", "7", "10", "", "", "[(M|D)] [ZEROFILL]", "1", "0", "3", "\u0000", "0", "1", "FLOAT", "-38", "38", "0", "0", "10"}, {"DOUBLE", "8", "17", "", "", "[(M|D)] [ZEROFILL]", "1", "0", "3", "\u0000", "0", "1", "DOUBLE", "-308", "308", "0", "0", "10"}, {"DOUBLE PRECISION", "8", "17", "", "", "[(M,D)] [ZEROFILL]", "1", "0", "3", "\u0000", "0", "1", "DOUBLE PRECISION", "-308", "308", "0", "0", "10"}, {"REAL", "8", "17", "", "", "[(M,D)] [ZEROFILL]", "1", "0", "3", "\u0000", "0", "1", "REAL", "-308", "308", "0", "0", "10"}, {"VARCHAR", "12", "255", "'", "'", "(M)", "1", "0", "3", "\u0000", "0", "0", "VARCHAR", "0", "0", "0", "0", "10"}, {"ENUM", "12", "65535", "'", "'", "", "1", "0", "3", "\u0000", "0", "0", "ENUM", "0", "0", "0", "0", "10"}, {"SET", "12", "64", "'", "'", "", "1", "0", "3", "\u0000", "0", "0", "SET", "0", "0", "0", "0", "10"}, {"DATE", "91", "10", "'", "'", "", "1", "0", "3", "\u0000", "0", "0", "DATE", "0", "0", "0", "0", "10"}, {"TIME", "92", "18", "'", "'", "[(M)]", "1", "0", "3", "\u0000", "0", "0", "TIME", "0", "0", "0", "0", "10"}, {"DATETIME", "93", "27", "'", "'", "[(M)]", "1", "0", "3", "\u0000", "0", "0", "DATETIME", "0", "0", "0", "0", "10"}, {"TIMESTAMP", "93", "27", "'", "'", "[(M)]", "1", "0", "3", "\u0000", "0", "0", "TIMESTAMP", "0", "0", "0", "0", "10"}};
        return CompleteResult.createResultSet(columnNames, dataTypes, data, this.connection.getContext(), 0, 1004);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (table == null) {
            throw new SQLException("'table' parameter must not be null");
        }
        StringBuilder sb = new StringBuilder("SELECT ").append(this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? "TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM" : "TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM").append(", TABLE_NAME, NON_UNIQUE, ").append(this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? "TABLE_SCHEMA INDEX_QUALIFIER" : "TABLE_CATALOG INDEX_QUALIFIER").append(", INDEX_NAME, 3 TYPE, SEQ_IN_INDEX ORDINAL_POSITION, COLUMN_NAME, COLLATION ASC_OR_DESC, CARDINALITY, NULL PAGES, NULL FILTER_CONDITION FROM INFORMATION_SCHEMA.STATISTICS");
        String database = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? catalog : schema;
        boolean firstCondition = this.databaseCond(true, sb, "TABLE_SCHEMA", database, false);
        sb.append(firstCondition ? " WHERE " : " AND ").append("TABLE_NAME = ").append(this.escapeQuote(table));
        if (unique) {
            sb.append(" AND NON_UNIQUE = 0");
        }
        sb.append(" ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION");
        return this.executeQuery(sb.toString());
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1004 || type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return type == 1004 || type == 1003;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return this.supportsResultSetType(type);
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return this.supportsResultSetType(type);
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return this.supportsResultSetType(type);
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String sql = "SELECT ' ' TYPE_CAT, NULL TYPE_SCHEM, ' ' TYPE_NAME, ' ' CLASS_NAME, 0 DATA_TYPE, ' ' REMARKS, 0 BASE_TYPE FROM DUAL WHERE 1=0";
        return this.executeQuery(sql);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        String sql = "SELECT  ' ' TYPE_CAT, NULL TYPE_SCHEM, ' ' TYPE_NAME, ' ' SUPERTYPE_CAT, ' ' SUPERTYPE_SCHEM, ' '  SUPERTYPE_NAME FROM DUAL WHERE 1=0";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String sql = "SELECT  ' ' TABLE_CAT, ' ' TABLE_SCHEM, ' ' TABLE_NAME, ' ' SUPERTABLE_NAME FROM DUAL WHERE 1=0";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        String sql = "SELECT ' ' TYPE_CAT, ' ' TYPE_SCHEM, ' ' TYPE_NAME, ' ' ATTR_NAME, 0 DATA_TYPE, ' ' ATTR_TYPE_NAME, 0 ATTR_SIZE, 0 DECIMAL_DIGITS, 0 NUM_PREC_RADIX, 0 NULLABLE, ' ' REMARKS, ' ' ATTR_DEF,  0 SQL_DATA_TYPE, 0 SQL_DATETIME_SUB, 0 CHAR_OCTET_LENGTH, 0 ORDINAL_POSITION, ' ' IS_NULLABLE, ' ' SCOPE_CATALOG, ' ' SCOPE_SCHEMA, ' ' SCOPE_TABLE, 0 SOURCE_DATA_TYPE FROM DUAL  WHERE 1=0";
        return this.executeQuery(sql);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() {
        return this.connection.getContext().getVersion().getMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() {
        return this.connection.getContext().getVersion().getMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() {
        String[] columnNames = new String[]{"NAME", "MAX_LEN", "DEFAULT_VALUE", "DESCRIPTION"};
        DataType[] types = new DataType[]{DataType.VARSTRING, DataType.INTEGER, DataType.VARSTRING, DataType.VARSTRING};
        String[][] data = new String[][]{{"ApplicationName", "16777215", "", "The name of the application currently utilizing the connection"}, {"ClientUser", "16777215", "", "The name of the user that the application using the connection is performing work for. This may not be the same as the user name that was used in establishing the connection."}, {"ClientHostname", "16777215", "", "The hostname of the computer the application using the connection is running on"}};
        return CompleteResult.createResultSet(columnNames, types, data, this.connection.getContext(), 0, 1004);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        StringBuilder sb = new StringBuilder("SELECT ROUTINE_SCHEMA FUNCTION_CAT,NULL FUNCTION_SCHEM, ROUTINE_NAME FUNCTION_NAME, ROUTINE_COMMENT REMARKS, 1 FUNCTION_TYPE, SPECIFIC_NAME  FROM INFORMATION_SCHEMA.ROUTINES");
        String database = this.conf.useCatalogTerm() == CatalogTerm.UseCatalog ? catalog : schemaPattern;
        boolean firstCondition = this.databaseCond(true, sb, "ROUTINE_SCHEMA", database, this.conf.useCatalogTerm() == CatalogTerm.UseSchema);
        firstCondition = this.patternCond(firstCondition, sb, "ROUTINE_NAME", functionNamePattern);
        sb.append(firstCondition ? " WHERE " : " AND ").append(" ROUTINE_TYPE='FUNCTION'");
        return this.executeQuery(sb.toString());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("The receiver is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public long getMaxLogicalLobSize() {
        return 0xFFFFFFFFL;
    }

    private static class Identifier {
        public String schema;
        public String name;

        private Identifier() {
        }
    }
}

