/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.MariadbResult;
import org.mariadb.r2dbc.api.MariadbStatement;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.Codecs;
import org.mariadb.r2dbc.codec.Parameter;
import org.mariadb.r2dbc.message.client.QueryWithParametersPacket;
import org.mariadb.r2dbc.message.server.ServerMessage;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.ClientPrepareResult;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.util.annotation.Nullable;

final class MariadbClientParameterizedQueryStatement
implements MariadbStatement {
    private final Client client;
    private final String sql;
    private final ClientPrepareResult prepareResult;
    private final MariadbConnectionConfiguration configuration;
    private Parameter<?>[] parameters;
    private List<Parameter<?>[]> batchingParameters;
    private String[] generatedColumns;

    MariadbClientParameterizedQueryStatement(Client client, String sql, MariadbConnectionConfiguration configuration) {
        this.client = client;
        this.configuration = configuration;
        this.sql = Assert.requireNonNull(sql, "sql must not be null");
        this.prepareResult = ClientPrepareResult.parameterParts(this.sql, this.client.noBackslashEscapes());
        this.parameters = new Parameter[this.prepareResult.getParamCount()];
    }

    @Override
    public MariadbClientParameterizedQueryStatement add() {
        for (int i = 0; i < this.prepareResult.getParamCount(); ++i) {
            if (this.parameters[i] != null) continue;
            throw new IllegalArgumentException(String.format("Parameter at position %s is not set", i));
        }
        if (this.batchingParameters == null) {
            this.batchingParameters = new ArrayList<Parameter<?>[]>();
        }
        this.batchingParameters.add(this.parameters);
        this.parameters = new Parameter[this.prepareResult.getParamCount()];
        return this;
    }

    @Override
    public MariadbClientParameterizedQueryStatement bind(@Nullable String identifier, @Nullable Object value) {
        Assert.requireNonNull(identifier, "identifier cannot be null");
        return this.bind(this.getColumn(identifier), value);
    }

    @Override
    public MariadbClientParameterizedQueryStatement bind(int index, @Nullable Object value) {
        if (value == null) {
            return this.bindNull(index, (Class)null);
        }
        if (index >= this.prepareResult.getParamCount() || index < 0) {
            throw new IndexOutOfBoundsException(String.format("index must be in 0-%d range but value is %d", this.prepareResult.getParamCount() - 1, index));
        }
        for (Codec<?> codec : Codecs.LIST) {
            if (!codec.canEncode(value.getClass())) continue;
            this.parameters[index] = new Parameter<Object>(codec, value);
            return this;
        }
        throw new IllegalArgumentException(String.format("No encoder for class %s (parameter at index %s) ", value.getClass().getName(), index));
    }

    @Override
    public MariadbClientParameterizedQueryStatement bindNull(@Nullable String identifier, @Nullable Class<?> type) {
        Assert.requireNonNull(identifier, "identifier cannot be null");
        return this.bindNull(this.getColumn(identifier), (Class)type);
    }

    @Override
    public MariadbClientParameterizedQueryStatement bindNull(int index, @Nullable Class<?> type) {
        if (index >= this.prepareResult.getParamCount() || index < 0) {
            throw new IndexOutOfBoundsException(String.format("index must be in 0-%d range but value is %d", this.prepareResult.getParamCount() - 1, index));
        }
        this.parameters[index] = Parameter.NULL_PARAMETER;
        return this;
    }

    private int getColumn(String name) {
        for (int i = 0; i < this.prepareResult.getParamNameList().size(); ++i) {
            if (!name.equals(this.prepareResult.getParamNameList().get(i))) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("No parameter with name '%s' found (possible values %s)", name, this.prepareResult.getParamNameList().toString()));
    }

    @Override
    public Flux<org.mariadb.r2dbc.api.MariadbResult> execute() {
        for (int i = 0; i < this.prepareResult.getParamCount(); ++i) {
            if (this.parameters[i] != null) continue;
            throw new IllegalArgumentException(String.format("Parameter at position %s is not set", i));
        }
        if (this.batchingParameters == null) {
            return this.execute(this.sql, this.prepareResult, this.generatedColumns);
        }
        this.add();
        Flux fluxMsg = this.client.sendCommand(new QueryWithParametersPacket(this.prepareResult, this.batchingParameters.get(0), this.generatedColumns != null && this.client.getVersion().supportReturning() ? this.generatedColumns : null));
        int index = 1;
        while (index < this.batchingParameters.size()) {
            fluxMsg = fluxMsg.concatWith(this.client.sendCommand(new QueryWithParametersPacket(this.prepareResult, this.batchingParameters.get(index++), this.generatedColumns != null && this.client.getVersion().supportReturning() ? this.generatedColumns : null)));
        }
        this.batchingParameters.clear();
        this.parameters = new Parameter[this.prepareResult.getParamCount()];
        return fluxMsg.windowUntil(it -> it.resultSetEnd()).map(dataRow -> new MariadbResult(true, (Flux<ServerMessage>)dataRow, ExceptionFactory.INSTANCE, this.generatedColumns, this.client.getVersion().supportReturning()));
    }

    @Override
    public MariadbClientParameterizedQueryStatement fetchSize(int rows) {
        return this;
    }

    @Override
    public MariadbClientParameterizedQueryStatement returnGeneratedValues(String ... columns) {
        Assert.requireNonNull(columns, "columns must not be null");
        if (!this.client.getVersion().supportReturning() && columns.length > 1) {
            throw new IllegalArgumentException("returnGeneratedValues can have only one column before MariaDB 10.5.1");
        }
        this.prepareResult.validateAddingReturning();
        this.generatedColumns = columns;
        return this;
    }

    private Flux<org.mariadb.r2dbc.api.MariadbResult> execute(String sql, ClientPrepareResult prepareResult, String[] generatedColumns) {
        ExceptionFactory factory = ExceptionFactory.withSql(sql);
        Flux response = this.client.sendCommand(new QueryWithParametersPacket(prepareResult, this.parameters, generatedColumns != null && this.client.getVersion().supportReturning() ? generatedColumns : null)).windowUntil(it -> it.resultSetEnd()).map(dataRow -> new MariadbResult(true, (Flux<ServerMessage>)dataRow, factory, generatedColumns, this.client.getVersion().supportReturning()));
        return response.concatWith((Publisher)Flux.create(sink -> {
            sink.complete();
            this.parameters = new Parameter[prepareResult.getParamCount()];
        }));
    }

    public String toString() {
        return "MariadbClientParameterizedQueryStatement{client=" + this.client + ", sql='" + this.sql + '\'' + ", prepareResult=" + this.prepareResult + ", parameters=" + Arrays.toString(this.parameters) + ", configuration=" + this.configuration + ", generatedColumns=" + Arrays.toString(this.generatedColumns) + '}';
    }
}

