/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.IsolationLevel;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mariadb.r2dbc.MariadbConnectionFactoryProvider;
import org.mariadb.r2dbc.SslMode;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.SslConfig;
import reactor.util.annotation.Nullable;

public final class MariadbConnectionConfiguration {
    public static final int DEFAULT_PORT = 3306;
    private final String database;
    private final String host;
    private final Duration connectTimeout;
    private final Duration socketTimeout;
    private final boolean tcpKeepAlive;
    private final boolean tcpAbortiveClose;
    private final CharSequence password;
    private final CharSequence[] pamOtherPwd;
    private final int port;
    private final int prepareCacheSize;
    private final String socket;
    private final String username;
    private final boolean allowMultiQueries;
    private final boolean allowPipelining;
    private final Map<String, String> connectionAttributes;
    private final Map<String, String> sessionVariables;
    private final SslConfig sslConfig;
    private final String rsaPublicKey;
    private final String cachingRsaPublicKey;
    private final boolean allowPublicKeyRetrieval;
    private IsolationLevel isolationLevel;
    private final boolean useServerPrepStmts;

    private MariadbConnectionConfiguration(@Nullable Duration connectTimeout, @Nullable Duration socketTimeout, @Nullable Boolean tcpKeepAlive, @Nullable Boolean tcpAbortiveClose, @Nullable String database, @Nullable String host, @Nullable Map<String, String> connectionAttributes, @Nullable Map<String, String> sessionVariables, @Nullable CharSequence password, int port, @Nullable String socket, @Nullable String username, boolean allowMultiQueries, boolean allowPipelining, @Nullable List<String> tlsProtocol, @Nullable String serverSslCert, @Nullable String clientSslCert, @Nullable String clientSslKey, @Nullable CharSequence clientSslPassword, SslMode sslMode, @Nullable String rsaPublicKey, @Nullable String cachingRsaPublicKey, boolean allowPublicKeyRetrieval, boolean useServerPrepStmts, @Nullable Integer prepareCacheSize, @Nullable CharSequence[] pamOtherPwd) {
        this.connectTimeout = connectTimeout == null ? Duration.ofSeconds(10L) : connectTimeout;
        this.socketTimeout = socketTimeout;
        this.tcpKeepAlive = tcpKeepAlive == null ? Boolean.FALSE : tcpKeepAlive;
        this.tcpAbortiveClose = tcpAbortiveClose == null ? Boolean.FALSE : tcpAbortiveClose;
        this.database = database;
        this.host = host;
        this.connectionAttributes = connectionAttributes;
        this.sessionVariables = sessionVariables;
        this.password = password;
        this.port = port;
        this.socket = socket;
        this.username = username;
        this.allowMultiQueries = allowMultiQueries;
        this.allowPipelining = allowPipelining;
        this.sslConfig = sslMode == SslMode.DISABLED ? SslConfig.DISABLE_INSTANCE : new SslConfig(sslMode, serverSslCert, clientSslCert, clientSslKey, clientSslPassword, tlsProtocol);
        this.rsaPublicKey = rsaPublicKey;
        this.cachingRsaPublicKey = cachingRsaPublicKey;
        this.allowPublicKeyRetrieval = allowPublicKeyRetrieval;
        this.useServerPrepStmts = useServerPrepStmts;
        this.prepareCacheSize = prepareCacheSize == null ? 250 : prepareCacheSize;
        this.pamOtherPwd = pamOtherPwd;
    }

    static boolean boolValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean(value.toString());
        }
        throw new IllegalArgumentException(String.format("Option %s wrong boolean format", value));
    }

    static Duration durationValue(Object value) {
        if (value instanceof Duration) {
            return (Duration)value;
        }
        if (value instanceof String) {
            return Duration.parse(value.toString());
        }
        throw new IllegalArgumentException(String.format("Option %s wrong duration format", value));
    }

    static int intValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt(value.toString());
        }
        throw new IllegalArgumentException(String.format("Option %s wrong integer format", value));
    }

    public static Builder fromOptions(ConnectionFactoryOptions connectionFactoryOptions) {
        Builder builder = new Builder();
        builder.database((String)connectionFactoryOptions.getValue(ConnectionFactoryOptions.DATABASE));
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.SOCKET)) {
            builder.socket((String)connectionFactoryOptions.getRequiredValue(MariadbConnectionFactoryProvider.SOCKET));
        } else {
            builder.host((String)connectionFactoryOptions.getRequiredValue(ConnectionFactoryOptions.HOST));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.ALLOW_MULTI_QUERIES)) {
            builder.allowMultiQueries(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.ALLOW_MULTI_QUERIES)));
        }
        if (connectionFactoryOptions.hasOption(ConnectionFactoryOptions.CONNECT_TIMEOUT)) {
            builder.connectTimeout(MariadbConnectionConfiguration.durationValue(connectionFactoryOptions.getValue(ConnectionFactoryOptions.CONNECT_TIMEOUT)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.SOCKET_TIMEOUT)) {
            builder.socketTimeout(MariadbConnectionConfiguration.durationValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.SOCKET_TIMEOUT)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.TCP_KEEP_ALIVE)) {
            builder.tcpKeepAlive(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.TCP_KEEP_ALIVE)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.TCP_ABORTIVE_CLOSE)) {
            builder.tcpAbortiveClose(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.TCP_ABORTIVE_CLOSE)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.ALLOW_PIPELINING)) {
            builder.allowPipelining(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.ALLOW_PIPELINING)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.USE_SERVER_PREPARE)) {
            builder.useServerPrepStmts(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.USE_SERVER_PREPARE)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.CONNECTION_ATTRIBUTES)) {
            HashMap<String, String> myMap = new HashMap<String, String>();
            String s = (String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.CONNECTION_ATTRIBUTES);
            String[] pairs = s.split(",");
            for (int i = 0; i < pairs.length; ++i) {
                String pair = pairs[i];
                String[] keyValue = pair.split("=");
                myMap.put(keyValue[0], keyValue.length > 1 ? keyValue[1] : "");
            }
            builder.connectionAttributes(myMap);
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.PREPARE_CACHE_SIZE)) {
            builder.prepareCacheSize(MariadbConnectionConfiguration.intValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.PREPARE_CACHE_SIZE)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.SSL_MODE)) {
            builder.sslMode(Enum.valueOf(SslMode.class, (String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.SSL_MODE)));
        }
        builder.serverSslCert((String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.SERVER_SSL_CERT));
        builder.clientSslCert((String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.CLIENT_SSL_CERT));
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.TLS_PROTOCOL)) {
            String[] protocols = ((String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.TLS_PROTOCOL)).split("[,;\\s]+");
            builder.tlsProtocol(protocols);
        }
        builder.password((CharSequence)connectionFactoryOptions.getValue(ConnectionFactoryOptions.PASSWORD));
        builder.username((String)connectionFactoryOptions.getRequiredValue(ConnectionFactoryOptions.USER));
        if (connectionFactoryOptions.hasOption(ConnectionFactoryOptions.PORT)) {
            builder.port(MariadbConnectionConfiguration.intValue(connectionFactoryOptions.getValue(ConnectionFactoryOptions.PORT)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.PAM_OTHER_PASSWORD)) {
            String s = (String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.CONNECTION_ATTRIBUTES);
            CharSequence[] pairs = s.split(",");
            try {
                for (int i = 0; i < pairs.length; ++i) {
                    pairs[i] = URLDecoder.decode((String)pairs[i], StandardCharsets.UTF_8.toString());
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            builder.pamOtherPwd(pairs);
        }
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    protected void setIsolationLevel(IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    @Nullable
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public CharSequence[] getPamOtherPwd() {
        return this.pamOtherPwd;
    }

    @Nullable
    public String getDatabase() {
        return this.database;
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    @Nullable
    public Map<String, String> getConnectionAttributes() {
        return this.connectionAttributes;
    }

    @Nullable
    public Map<String, String> getSessionVariables() {
        return this.sessionVariables;
    }

    @Nullable
    public CharSequence getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public String getSocket() {
        return this.socket;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean allowMultiQueries() {
        return this.allowMultiQueries;
    }

    public boolean allowPipelining() {
        return this.allowPipelining;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public String getRsaPublicKey() {
        return this.rsaPublicKey;
    }

    public String getCachingRsaPublicKey() {
        return this.cachingRsaPublicKey;
    }

    public boolean allowPublicKeyRetrieval() {
        return this.allowPublicKeyRetrieval;
    }

    public boolean useServerPrepStmts() {
        return this.useServerPrepStmts;
    }

    public int getPrepareCacheSize() {
        return this.prepareCacheSize;
    }

    public Duration getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public boolean isTcpAbortiveClose() {
        return this.tcpAbortiveClose;
    }

    public String toString() {
        StringBuilder hiddenPwd = new StringBuilder();
        if (this.password != null) {
            for (int i = 0; i < this.password.length(); ++i) {
                hiddenPwd.append("*");
            }
        }
        StringBuilder hiddenPamPwd = new StringBuilder();
        if (this.pamOtherPwd != null) {
            for (CharSequence s : this.pamOtherPwd) {
                for (int i = 0; i < s.length(); ++i) {
                    hiddenPamPwd.append("*");
                }
                hiddenPamPwd.append(",");
            }
            hiddenPamPwd.deleteCharAt(hiddenPamPwd.length() - 1);
        }
        return "MariadbConnectionConfiguration{database='" + this.database + '\'' + ", host='" + this.host + '\'' + ", connectTimeout=" + this.connectTimeout + ", socketTimeout=" + this.socketTimeout + ", tcpKeepAlive=" + this.tcpKeepAlive + ", tcpAbortiveClose=" + this.tcpAbortiveClose + ", password=" + hiddenPwd + ", port=" + this.port + ", prepareCacheSize=" + this.prepareCacheSize + ", socket='" + this.socket + '\'' + ", username='" + this.username + '\'' + ", allowMultiQueries=" + this.allowMultiQueries + ", allowPipelining=" + this.allowPipelining + ", connectionAttributes=" + this.connectionAttributes + ", sessionVariables=" + this.sessionVariables + ", sslConfig=" + this.sslConfig + ", rsaPublicKey='" + this.rsaPublicKey + '\'' + ", cachingRsaPublicKey='" + this.cachingRsaPublicKey + '\'' + ", allowPublicKeyRetrieval=" + this.allowPublicKeyRetrieval + ", isolationLevel=" + this.isolationLevel + ", useServerPrepStmts=" + this.useServerPrepStmts + ", pamOtherPwd=" + hiddenPamPwd + '}';
    }

    public static final class Builder
    implements Cloneable {
        @Nullable
        private String rsaPublicKey;
        @Nullable
        private String cachingRsaPublicKey;
        private boolean allowPublicKeyRetrieval;
        @Nullable
        private String username;
        @Nullable
        private Duration connectTimeout;
        @Nullable
        private Duration socketTimeout;
        @Nullable
        private Boolean tcpKeepAlive;
        @Nullable
        private Boolean tcpAbortiveClose;
        @Nullable
        private String database;
        @Nullable
        private String host;
        @Nullable
        private Map<String, String> sessionVariables;
        @Nullable
        private Map<String, String> connectionAttributes;
        @Nullable
        private CharSequence password;
        private int port = 3306;
        @Nullable
        private String socket;
        private boolean allowMultiQueries = false;
        private boolean allowPipelining = true;
        private boolean useServerPrepStmts = false;
        @Nullable
        Integer prepareCacheSize;
        @Nullable
        private List<String> tlsProtocol;
        @Nullable
        private String serverSslCert;
        @Nullable
        private String clientSslCert;
        @Nullable
        private String clientSslKey;
        @Nullable
        private CharSequence clientSslPassword;
        private SslMode sslMode = SslMode.DISABLED;
        private CharSequence[] pamOtherPwd;

        private Builder() {
        }

        public MariadbConnectionConfiguration build() {
            if (this.host == null && this.socket == null) {
                throw new IllegalArgumentException("host or socket must not be null");
            }
            if (this.host != null && this.socket != null) {
                throw new IllegalArgumentException("Connection must be configured for either host/port or socket usage but not both");
            }
            if (this.username == null) {
                throw new IllegalArgumentException("username must not be null");
            }
            return new MariadbConnectionConfiguration(this.connectTimeout, this.socketTimeout, this.tcpKeepAlive, this.tcpAbortiveClose, this.database, this.host, this.connectionAttributes, this.sessionVariables, this.password, this.port, this.socket, this.username, this.allowMultiQueries, this.allowPipelining, this.tlsProtocol, this.serverSslCert, this.clientSslCert, this.clientSslKey, this.clientSslPassword, this.sslMode, this.rsaPublicKey, this.cachingRsaPublicKey, this.allowPublicKeyRetrieval, this.useServerPrepStmts, this.prepareCacheSize, this.pamOtherPwd);
        }

        public Builder connectTimeout(@Nullable Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder socketTimeout(@Nullable Duration socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder tcpKeepAlive(@Nullable Boolean tcpKeepAlive) {
            this.tcpKeepAlive = tcpKeepAlive;
            return this;
        }

        public Builder tcpAbortiveClose(@Nullable Boolean tcpAbortiveClose) {
            this.tcpAbortiveClose = tcpAbortiveClose;
            return this;
        }

        public Builder connectionAttributes(@Nullable Map<String, String> connectionAttributes) {
            this.connectionAttributes = connectionAttributes;
            return this;
        }

        public Builder sessionVariables(@Nullable Map<String, String> sessionVariables) {
            this.sessionVariables = sessionVariables;
            return this;
        }

        public Builder pamOtherPwd(@Nullable CharSequence[] pamOtherPwd) {
            this.pamOtherPwd = pamOtherPwd;
            return this;
        }

        public Builder database(@Nullable String database) {
            this.database = database;
            return this;
        }

        public Builder host(String host) {
            this.host = Assert.requireNonNull(host, "host must not be null");
            return this;
        }

        public Builder password(@Nullable CharSequence password) {
            this.password = password;
            return this;
        }

        public Builder tlsProtocol(String ... tlsProtocol) {
            if (tlsProtocol == null) {
                this.tlsProtocol = null;
                return this;
            }
            this.tlsProtocol = new ArrayList<String>();
            for (String protocol : tlsProtocol) {
                this.tlsProtocol.add(protocol);
            }
            return this;
        }

        public Builder serverSslCert(String serverSslCert) {
            this.serverSslCert = serverSslCert;
            return this;
        }

        public Builder prepareCacheSize(Integer prepareCacheSize) {
            this.prepareCacheSize = prepareCacheSize;
            return this;
        }

        public Builder clientSslCert(String clientSslCert) {
            this.clientSslCert = clientSslCert;
            return this;
        }

        public Builder clientSslKey(String clientSslKey) {
            this.clientSslKey = clientSslKey;
            return this;
        }

        public Builder clientSslPassword(CharSequence clientSslPassword) {
            this.clientSslPassword = clientSslPassword;
            return this;
        }

        public Builder sslMode(SslMode sslMode) {
            this.sslMode = sslMode;
            if (sslMode == null) {
                this.sslMode = SslMode.DISABLED;
            }
            return this;
        }

        public Builder rsaPublicKey(String rsaPublicKey) {
            this.rsaPublicKey = rsaPublicKey;
            return this;
        }

        public Builder cachingRsaPublicKey(String cachingRsaPublicKey) {
            this.cachingRsaPublicKey = cachingRsaPublicKey;
            return this;
        }

        public Builder allowPublicKeyRetrieval(boolean allowPublicKeyRetrieval) {
            this.allowPublicKeyRetrieval = allowPublicKeyRetrieval;
            return this;
        }

        public Builder useServerPrepStmts(boolean useServerPrepStmts) {
            this.useServerPrepStmts = useServerPrepStmts;
            return this;
        }

        public Builder allowPipelining(boolean allowPipelining) {
            this.allowPipelining = allowPipelining;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder allowMultiQueries(boolean allowMultiQueries) {
            this.allowMultiQueries = allowMultiQueries;
            return this;
        }

        public Builder socket(String socket) {
            this.socket = Assert.requireNonNull(socket, "host must not be null");
            return this;
        }

        public Builder username(String username) {
            this.username = Assert.requireNonNull(username, "username must not be null");
            return this;
        }

        public Builder clone() throws CloneNotSupportedException {
            return (Builder)super.clone();
        }

        public String toString() {
            StringBuilder hiddenPwd = new StringBuilder();
            if (this.password != null) {
                for (int i = 0; i < this.password.length(); ++i) {
                    hiddenPwd.append("*");
                }
            }
            StringBuilder hiddenPamPwd = new StringBuilder();
            if (this.pamOtherPwd != null) {
                for (CharSequence s : this.pamOtherPwd) {
                    for (int i = 0; i < s.length(); ++i) {
                        hiddenPamPwd.append("*");
                    }
                    hiddenPamPwd.append(",");
                }
                hiddenPamPwd.deleteCharAt(hiddenPamPwd.length() - 1);
            }
            return "Builder{rsaPublicKey='" + this.rsaPublicKey + '\'' + ", cachingRsaPublicKey='" + this.cachingRsaPublicKey + '\'' + ", allowPublicKeyRetrieval=" + this.allowPublicKeyRetrieval + ", username='" + this.username + '\'' + ", connectTimeout=" + this.connectTimeout + ", socketTimeout=" + this.socketTimeout + ", tcpKeepAlive=" + this.tcpKeepAlive + ", tcpAbortiveClose=" + this.tcpAbortiveClose + ", database='" + this.database + '\'' + ", host='" + this.host + '\'' + ", sessionVariables=" + this.sessionVariables + ", connectionAttributes=" + this.connectionAttributes + ", password=" + hiddenPwd + ", port=" + this.port + ", socket='" + this.socket + '\'' + ", allowMultiQueries=" + this.allowMultiQueries + ", allowPipelining=" + this.allowPipelining + ", useServerPrepStmts=" + this.useServerPrepStmts + ", prepareCacheSize=" + this.prepareCacheSize + ", tlsProtocol=" + this.tlsProtocol + ", serverSslCert='" + this.serverSslCert + '\'' + ", clientSslCert='" + this.clientSslCert + '\'' + ", clientSslKey='" + this.clientSslKey + '\'' + ", clientSslPassword=" + this.clientSslPassword + ", sslMode=" + (Object)((Object)this.sslMode) + ", pamOtherPwd=" + hiddenPamPwd + '}';
        }
    }
}

