/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec;

import io.netty.buffer.ByteBuf;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.Codecs;
import org.mariadb.r2dbc.codec.RowDecoder;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;

public class BinaryRowDecoder
extends RowDecoder {
    private int columnNumber;
    private ColumnDefinitionPacket[] columns;
    private byte[] nullBitmap;

    public BinaryRowDecoder(int columnNumber, ColumnDefinitionPacket[] columns) {
        this.columns = columns;
        this.columnNumber = columnNumber;
    }

    @Override
    public <T> T get(int index, ColumnDefinitionPacket column, Class<T> type) throws IllegalArgumentException {
        if ((this.nullBitmap[(index + 2) / 8] & 1 << (index + 2) % 8) != 0) {
            if (type.isPrimitive()) {
                throw new IllegalArgumentException(String.format("Cannot return null for primitive %s", type.getName()));
            }
            return null;
        }
        this.setPosition(index);
        if (Object.class == type || type == null) {
            Codec<?> defaultCodec = column.getDefaultCodec();
            return (T)defaultCodec.decodeBinary(this.buf, this.length, column, type);
        }
        for (Codec<T> codec : Codecs.LIST) {
            if (!codec.canDecode(column, type)) continue;
            return (T)codec.decodeBinary(this.buf, this.length, column, type);
        }
        this.buf.skipBytes(this.length);
        throw this.noDecoderException(column, type);
    }

    @Override
    public void resetRow(ByteBuf buf) {
        buf.skipBytes(1);
        this.nullBitmap = new byte[(this.columnNumber + 9) / 8];
        buf.readBytes(this.nullBitmap);
        super.resetRow(buf);
    }

    @Override
    public void setPosition(int newIndex) {
        if (this.index >= newIndex) {
            this.index = 0;
            this.buf.resetReaderIndex();
        } else {
            ++this.index;
        }
        while (this.index <= newIndex) {
            if ((this.nullBitmap[(this.index + 2) / 8] & 1 << (this.index + 2) % 8) == 0) {
                if (this.index != newIndex) {
                    block0 : switch (this.columns[this.index].getType()) {
                        case BIGINT: 
                        case DOUBLE: {
                            this.buf.skipBytes(8);
                            break;
                        }
                        case INTEGER: 
                        case MEDIUMINT: 
                        case FLOAT: {
                            this.buf.skipBytes(4);
                            break;
                        }
                        case SMALLINT: 
                        case YEAR: {
                            this.buf.skipBytes(2);
                            break;
                        }
                        case TINYINT: {
                            this.buf.skipBytes(1);
                            break;
                        }
                        default: {
                            short type = this.buf.readUnsignedByte();
                            switch (type) {
                                case 251: {
                                    break block0;
                                }
                                case 252: {
                                    this.buf.skipBytes(this.buf.readUnsignedShortLE());
                                    break block0;
                                }
                                case 253: {
                                    this.buf.skipBytes(this.buf.readUnsignedMediumLE());
                                    break block0;
                                }
                                case 254: {
                                    this.buf.skipBytes((int)this.buf.readLongLE());
                                    break block0;
                                }
                            }
                            this.buf.skipBytes((int)type);
                            break;
                        }
                    }
                } else {
                    switch (this.columns[this.index].getType()) {
                        case BIGINT: 
                        case DOUBLE: {
                            this.length = 8;
                            return;
                        }
                        case INTEGER: 
                        case MEDIUMINT: 
                        case FLOAT: {
                            this.length = 4;
                            return;
                        }
                        case SMALLINT: 
                        case YEAR: {
                            this.length = 2;
                            return;
                        }
                        case TINYINT: {
                            this.length = 1;
                            return;
                        }
                    }
                    short len = this.buf.readUnsignedByte();
                    switch (len) {
                        case 251: {
                            throw new IllegalStateException("null data is encoded in binary protocol but NULL-Bitmap is not set");
                        }
                        case 252: {
                            this.length = this.buf.readUnsignedShortLE();
                            return;
                        }
                        case 253: {
                            this.length = this.buf.readUnsignedMediumLE();
                            return;
                        }
                        case 254: {
                            this.length = (int)this.buf.readLongLE();
                            return;
                        }
                    }
                    this.length = len;
                    return;
                }
            }
            ++this.index;
        }
    }
}

