/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.BufferUtils;

public class DoubleCodec
implements Codec<Double> {
    public static final DoubleCodec INSTANCE = new DoubleCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TINYINT, new DataType[]{DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.FLOAT, DataType.DOUBLE, DataType.BIGINT, DataType.YEAR, DataType.OLDDECIMAL, DataType.DECIMAL, DataType.VARCHAR, DataType.VARSTRING, DataType.STRING});

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Double.TYPE || type.isAssignableFrom(Double.class));
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return Double.class.isAssignableFrom(value);
    }

    @Override
    public Double decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Double> type) {
        switch (column.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case OLDDECIMAL: 
            case DECIMAL: 
            case YEAR: {
                return Double.valueOf(buf.readCharSequence(length, StandardCharsets.US_ASCII).toString());
            }
        }
        String str2 = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
        try {
            return Double.valueOf(str2);
        }
        catch (NumberFormatException nfe) {
            throw new R2dbcNonTransientResourceException(String.format("value '%s' cannot be decoded as Double", str2));
        }
    }

    @Override
    public Double decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Double> type) {
        switch (column.getType()) {
            case TINYINT: {
                if (!column.isSigned()) {
                    return buf.readUnsignedByte();
                }
                return buf.readByte();
            }
            case SMALLINT: 
            case YEAR: {
                if (!column.isSigned()) {
                    return buf.readUnsignedShortLE();
                }
                return buf.readShortLE();
            }
            case MEDIUMINT: {
                if (!column.isSigned()) {
                    return buf.readUnsignedMediumLE();
                }
                return buf.readMediumLE();
            }
            case INTEGER: {
                if (!column.isSigned()) {
                    return buf.readUnsignedIntLE();
                }
                return buf.readIntLE();
            }
            case BIGINT: {
                if (column.isSigned()) {
                    return buf.readLongLE();
                }
                byte[] bb = new byte[8];
                for (int i = 7; i >= 0; --i) {
                    bb[i] = buf.readByte();
                }
                return new BigInteger(1, bb).doubleValue();
            }
            case FLOAT: {
                return buf.readFloatLE();
            }
            case OLDDECIMAL: 
            case DECIMAL: {
                return new BigDecimal(buf.readCharSequence(length, StandardCharsets.US_ASCII).toString()).doubleValue();
            }
            case VARCHAR: 
            case VARSTRING: 
            case STRING: {
                String str2 = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
                try {
                    return Double.valueOf(str2);
                }
                catch (NumberFormatException nfe) {
                    throw new R2dbcNonTransientResourceException(String.format("value '%s' cannot be decoded as Double", str2));
                }
            }
        }
        return buf.readDoubleLE();
    }

    @Override
    public void encodeText(ByteBuf buf, Context context, Double value) {
        BufferUtils.writeAscii(buf, String.valueOf(value));
    }

    @Override
    public void encodeBinary(ByteBuf buf, Context context, Double value) {
        buf.writeDoubleLE(value.doubleValue());
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.DOUBLE;
    }
}

