/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.codec.list.LongCodec;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.BufferUtils;

public class IntCodec
implements Codec<Integer> {
    public static final IntCodec INSTANCE = new IntCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.FLOAT, new DataType[]{DataType.DOUBLE, DataType.OLDDECIMAL, DataType.VARCHAR, DataType.DECIMAL, DataType.ENUM, DataType.VARSTRING, DataType.STRING, DataType.TINYINT, DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.BIGINT, DataType.BIT, DataType.YEAR});

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Integer.TYPE || type.isAssignableFrom(Integer.class));
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return Integer.class.isAssignableFrom(value);
    }

    @Override
    public Integer decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Integer> type) {
        long result;
        switch (column.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INTEGER: 
            case YEAR: {
                result = LongCodec.parse(buf, length);
                break;
            }
            case BIGINT: {
                result = LongCodec.parse(buf, length);
                if (!(result < 0L & !column.isSigned())) break;
                throw new R2dbcNonTransientResourceException("integer overflow");
            }
            case BIT: {
                result = 0L;
                for (int i = 0; i < length; ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                break;
            }
            default: {
                String str = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
                try {
                    result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValueExact();
                    break;
                }
                catch (ArithmeticException | NumberFormatException nfe) {
                    throw new R2dbcNonTransientResourceException(String.format("value '%s' cannot be decoded as Integer", str));
                }
            }
        }
        if ((long)((int)result) != result) {
            throw new R2dbcNonTransientResourceException("integer overflow");
        }
        return (int)result;
    }

    @Override
    public Integer decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Integer> type) {
        long result;
        switch (column.getType()) {
            case TINYINT: {
                result = column.isSigned() ? (long)buf.readByte() : (long)buf.readUnsignedByte();
                break;
            }
            case SMALLINT: 
            case YEAR: {
                result = column.isSigned() ? (long)buf.readShortLE() : (long)buf.readUnsignedShortLE();
                break;
            }
            case MEDIUMINT: {
                result = column.isSigned() ? (long)buf.readMediumLE() : (long)buf.readUnsignedMediumLE();
                break;
            }
            case BIGINT: {
                if (column.isSigned()) {
                    result = buf.readLongLE();
                    break;
                }
                byte[] bb = new byte[8];
                for (int i = 7; i >= 0; --i) {
                    bb[i] = buf.readByte();
                }
                BigInteger val = new BigInteger(1, bb);
                try {
                    return val.intValueExact();
                }
                catch (ArithmeticException ae) {
                    throw new R2dbcNonTransientResourceException("integer overflow");
                }
            }
            case BIT: {
                result = 0L;
                for (int i = 0; i < length; ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                break;
            }
            case FLOAT: {
                result = (long)buf.readFloatLE();
                break;
            }
            case DOUBLE: {
                result = (long)buf.readDoubleLE();
                break;
            }
            case OLDDECIMAL: 
            case VARCHAR: 
            case DECIMAL: 
            case ENUM: 
            case VARSTRING: 
            case STRING: {
                String str = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
                try {
                    result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValueExact();
                    break;
                }
                catch (ArithmeticException | NumberFormatException nfe) {
                    throw new R2dbcNonTransientResourceException(String.format("value '%s' cannot be decoded as Integer", str));
                }
            }
            default: {
                long l = result = column.isSigned() ? (long)buf.readIntLE() : buf.readUnsignedIntLE();
            }
        }
        if ((long)((int)result) != result || result < 0L && !column.isSigned()) {
            throw new R2dbcNonTransientResourceException("integer overflow");
        }
        return (int)result;
    }

    @Override
    public void encodeText(ByteBuf buf, Context context, Integer value) {
        BufferUtils.writeAscii(buf, String.valueOf(value));
    }

    @Override
    public void encodeBinary(ByteBuf buf, Context context, Integer value) {
        buf.writeIntLE(value.intValue());
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.INTEGER;
    }
}

