/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.EnumSet;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.BufferUtils;

public class StringCodec
implements Codec<String> {
    public static final StringCodec INSTANCE = new StringCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.BIT, new DataType[]{DataType.OLDDECIMAL, DataType.TINYINT, DataType.SMALLINT, DataType.INTEGER, DataType.FLOAT, DataType.DOUBLE, DataType.TIMESTAMP, DataType.BIGINT, DataType.MEDIUMINT, DataType.DATE, DataType.TIME, DataType.DATETIME, DataType.YEAR, DataType.NEWDATE, DataType.JSON, DataType.DECIMAL, DataType.ENUM, DataType.SET, DataType.VARCHAR, DataType.VARSTRING, DataType.STRING});

    public static String zeroFilling(String value, ColumnDefinitionPacket col) {
        StringBuilder zeroAppendStr = new StringBuilder();
        long zeroToAdd = col.getDisplaySize() - value.length();
        while (zeroToAdd-- > 0L) {
            zeroAppendStr.append("0");
        }
        return zeroAppendStr.append(value).toString();
    }

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(String.class);
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return String.class.isAssignableFrom(value);
    }

    @Override
    public String decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends String> type) {
        if (column.getType() == DataType.BIT) {
            byte[] bytes = new byte[length];
            buf.readBytes(bytes);
            StringBuilder sb = new StringBuilder(bytes.length * 8 + 3);
            sb.append("b'");
            boolean firstByteNonZero = false;
            for (int i = 0; i < 8 * bytes.length; ++i) {
                boolean b;
                boolean bl = b = (bytes[i / 8] & 1 << 7 - i % 8) > 0;
                if (b) {
                    sb.append('1');
                    firstByteNonZero = true;
                    continue;
                }
                if (!firstByteNonZero) continue;
                sb.append('0');
            }
            sb.append("'");
            return sb.toString();
        }
        return buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
    }

    @Override
    public String decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends String> type) {
        switch (column.getType()) {
            case BIT: {
                byte[] bytes = new byte[length];
                buf.readBytes(bytes);
                StringBuilder sb = new StringBuilder(bytes.length * 8 + 3);
                sb.append("b'");
                boolean firstByteNonZero = false;
                for (int i = 0; i < 8 * bytes.length; ++i) {
                    boolean b;
                    boolean bl = b = (bytes[i / 8] & 1 << 7 - i % 8) > 0;
                    if (b) {
                        sb.append('1');
                        firstByteNonZero = true;
                        continue;
                    }
                    if (!firstByteNonZero) continue;
                    sb.append('0');
                }
                sb.append("'");
                return sb.toString();
            }
            case TINYINT: {
                String rawValue = String.valueOf(column.isSigned() ? buf.readByte() : buf.readUnsignedByte());
                if (column.isZeroFill()) {
                    return StringCodec.zeroFilling(rawValue, column);
                }
                return rawValue;
            }
            case YEAR: {
                String s = String.valueOf(buf.readUnsignedShortLE());
                while ((long)s.length() < column.getLength()) {
                    s = "0" + s;
                }
                return s;
            }
            case SMALLINT: {
                String rawValue = String.valueOf(column.isSigned() ? buf.readShortLE() : buf.readUnsignedShortLE());
                if (column.isZeroFill()) {
                    return StringCodec.zeroFilling(rawValue, column);
                }
                return rawValue;
            }
            case MEDIUMINT: {
                String rawValue = String.valueOf(column.isSigned() ? buf.readMediumLE() : buf.readUnsignedMediumLE());
                if (column.isZeroFill()) {
                    return StringCodec.zeroFilling(rawValue, column);
                }
                return rawValue;
            }
            case INTEGER: {
                String rawValue = String.valueOf(column.isSigned() ? (long)buf.readIntLE() : buf.readUnsignedIntLE());
                if (column.isZeroFill()) {
                    return StringCodec.zeroFilling(rawValue, column);
                }
                return rawValue;
            }
            case BIGINT: {
                BigInteger val;
                if (column.isSigned()) {
                    val = BigInteger.valueOf(buf.readLongLE());
                } else {
                    byte[] bb = new byte[8];
                    for (int ii = 7; ii >= 0; --ii) {
                        bb[ii] = buf.readByte();
                    }
                    val = new BigInteger(1, bb);
                }
                String rawValue = String.valueOf(val);
                if (column.isZeroFill()) {
                    rawValue = StringCodec.zeroFilling(rawValue, column);
                }
                return rawValue;
            }
            case FLOAT: {
                return String.valueOf(buf.readFloatLE());
            }
            case DOUBLE: {
                return String.valueOf(buf.readDoubleLE());
            }
            case TIME: {
                long tDays = 0L;
                int tHours = 0;
                byte tMinutes = 0;
                byte tSeconds = 0;
                long tMicroseconds = 0L;
                boolean negate = false;
                if (length > 0) {
                    boolean bl = negate = buf.readByte() == 1;
                    if (length > 4) {
                        tDays = buf.readUnsignedIntLE();
                        if (length > 7) {
                            tHours = buf.readByte();
                            tMinutes = buf.readByte();
                            tSeconds = buf.readByte();
                            if (length > 8) {
                                tMicroseconds = buf.readIntLE();
                            }
                        }
                    }
                }
                int totalHour = (int)(tDays * 24L + (long)tHours);
                String stTime = (negate ? "-" : "") + (totalHour < 10 ? "0" : "") + totalHour + ":" + (tMinutes < 10 ? "0" : "") + tMinutes + ":" + (tSeconds < 10 ? "0" : "") + tSeconds;
                if (column.getDecimals() == 0) {
                    return stTime;
                }
                String stMicro = String.valueOf(tMicroseconds);
                while (stMicro.length() < column.getDecimals()) {
                    stMicro = "0" + stMicro;
                }
                return stTime + "." + stMicro;
            }
            case DATE: {
                int dateYear = buf.readUnsignedShortLE();
                byte dateMonth = buf.readByte();
                byte dateDay = buf.readByte();
                return LocalDate.of(dateYear, dateMonth, (int)dateDay).toString();
            }
            case DATETIME: 
            case TIMESTAMP: {
                int year = buf.readUnsignedShortLE();
                byte month = buf.readByte();
                byte day = buf.readByte();
                byte hour = 0;
                byte minutes = 0;
                int seconds = 0;
                long microseconds = 0L;
                if (length > 4) {
                    hour = buf.readByte();
                    minutes = buf.readByte();
                    seconds = buf.readByte();
                    if (length > 7) {
                        microseconds = buf.readUnsignedIntLE();
                    }
                }
                LocalDateTime dateTime = LocalDateTime.of(year, month, (int)day, (int)hour, (int)minutes, seconds).plusNanos(microseconds * 1000L);
                return dateTime.toLocalDate().toString() + ' ' + dateTime.toLocalTime().toString();
            }
        }
        return buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
    }

    @Override
    public void encodeText(ByteBuf buf, Context context, String value) {
        BufferUtils.write(buf, value, true, context);
    }

    @Override
    public void encodeBinary(ByteBuf buf, Context context, String value) {
        byte[] b = value.getBytes(StandardCharsets.UTF_8);
        BufferUtils.writeLengthEncode(b.length, buf);
        buf.writeBytes(b);
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.VARSTRING;
    }
}

