/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.util;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.message.client.ClosePreparePacket;

public class ServerPrepareResult {
    private final int statementId;
    private final int numColumns;
    private final int numParams;
    private final AtomicBoolean closing = new AtomicBoolean();
    private final AtomicInteger use = new AtomicInteger(1);
    private final AtomicBoolean cached = new AtomicBoolean(false);

    public ServerPrepareResult(int statementId, int numColumns, int numParams) {
        this.statementId = statementId;
        this.numColumns = numColumns;
        this.numParams = numParams;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int getNumParams() {
        return this.numParams;
    }

    public void close(Client client) {
        if (!this.cached.get() && this.closing.compareAndSet(false, true)) {
            client.sendCommandWithoutResult(new ClosePreparePacket(this.statementId));
        }
    }

    public void decrementUse(Client client) {
        if (this.use.decrementAndGet() <= 0 && !this.cached.get()) {
            this.close(client);
        }
    }

    public boolean incrementUse() {
        if (this.closing.get()) {
            return false;
        }
        this.use.getAndIncrement();
        return true;
    }

    public void unCache(Client client) {
        this.cached.set(false);
        if (this.use.get() <= 0) {
            this.close(client);
        }
    }

    public boolean cache() {
        if (this.closing.get()) {
            return false;
        }
        return this.cached.compareAndSet(false, true);
    }

    public String toString() {
        return "ServerPrepareResult{statementId=" + this.statementId + ", numColumns=" + this.numColumns + ", numParams=" + this.numParams + ", closing=" + this.closing + ", use=" + this.use + ", cached=" + this.cached + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerPrepareResult that = (ServerPrepareResult)o;
        return this.statementId == that.statementId;
    }

    public int hashCode() {
        return Objects.hash(this.statementId);
    }
}

