/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import java.util.ArrayList;
import java.util.List;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.MariadbResult;
import org.mariadb.r2dbc.MariadbSimpleQueryStatement;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.message.client.QueryPacket;
import org.mariadb.r2dbc.message.server.ServerMessage;
import org.mariadb.r2dbc.util.Assert;
import reactor.core.publisher.Flux;

final class MariadbBatch
implements org.mariadb.r2dbc.api.MariadbBatch {
    private final Client client;
    private final MariadbConnectionConfiguration configuration;
    private final List<String> statements = new ArrayList<String>();

    MariadbBatch(Client client, MariadbConnectionConfiguration configuration) {
        this.client = client;
        this.configuration = configuration;
    }

    @Override
    public MariadbBatch add(String sql) {
        Assert.requireNonNull(sql, "sql must not be null");
        if (!MariadbSimpleQueryStatement.supports(sql, this.client)) {
            throw new IllegalArgumentException(String.format("Statement with parameters cannot be batched (sql:'%s')", sql));
        }
        this.statements.add(sql);
        return this;
    }

    @Override
    public Flux<org.mariadb.r2dbc.api.MariadbResult> execute() {
        if (this.configuration.allowMultiQueries()) {
            return new MariadbSimpleQueryStatement(this.client, String.join((CharSequence)";", this.statements)).execute();
        }
        Flux fluxMsg = Flux.create(sink -> {
            for (String sql : this.statements) {
                Flux<ServerMessage> in = this.client.sendCommand(new QueryPacket(sql));
                sink.next(in);
                in.subscribe();
            }
            sink.complete();
        });
        return fluxMsg.flatMap(Flux::from).windowUntil(it -> it.resultSetEnd()).map(dataRow -> new MariadbResult(true, (Flux<ServerMessage>)dataRow, ExceptionFactory.INSTANCE, null, this.client.getVersion().supportReturning()));
    }
}

