/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.MariadbResult;
import org.mariadb.r2dbc.api.MariadbStatement;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.client.DecoderState;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.Codecs;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.codec.Parameter;
import org.mariadb.r2dbc.message.client.ExecutePacket;
import org.mariadb.r2dbc.message.client.PreparePacket;
import org.mariadb.r2dbc.message.server.PrepareResultPacket;
import org.mariadb.r2dbc.message.server.ServerMessage;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.ServerPrepareResult;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

final class MariadbServerParameterizedQueryStatement
implements MariadbStatement {
    private final Client client;
    private final String initialSql;
    private final MariadbConnectionConfiguration configuration;
    private Map<Integer, Parameter<?>> parameters;
    private List<Map<Integer, Parameter<?>>> batchingParameters;
    private String[] generatedColumns;
    private ServerPrepareResult prepareResult;

    MariadbServerParameterizedQueryStatement(Client client, String sql, MariadbConnectionConfiguration configuration) {
        this.client = client;
        this.configuration = configuration;
        this.initialSql = Assert.requireNonNull(sql, "sql must not be null");
        this.parameters = new HashMap();
        this.prepareResult = (ServerPrepareResult)client.getPrepareCache().get(sql);
    }

    static boolean supports(String sql) {
        Assert.requireNonNull(sql, "sql must not be null");
        return !sql.trim().isEmpty();
    }

    @Override
    public MariadbServerParameterizedQueryStatement add() {
        if (this.prepareResult != null) {
            for (int i = 0; i < this.prepareResult.getNumParams(); ++i) {
                if (this.parameters.get(i) != null) continue;
                throw new IllegalArgumentException(String.format("Parameter at position %s is not set", i));
            }
        }
        if (this.batchingParameters == null) {
            this.batchingParameters = new ArrayList();
        }
        this.batchingParameters.add(this.parameters);
        this.parameters = new HashMap();
        return this;
    }

    @Override
    public MariadbServerParameterizedQueryStatement bind(@Nullable String identifier, @Nullable Object value) {
        Assert.requireNonNull(identifier, "identifier cannot be null");
        return this.bind(this.getColumn(identifier), value);
    }

    @Override
    public MariadbServerParameterizedQueryStatement bind(int index, @Nullable Object value) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.format("wrong index value %d, index must be positive", index));
        }
        if (this.prepareResult != null && index >= this.prepareResult.getNumParams()) {
            throw new IndexOutOfBoundsException(String.format("index must be in 0-%d range but value is %d", this.prepareResult.getNumParams() - 1, index));
        }
        if (value == null) {
            return this.bindNull(index, (Class)null);
        }
        for (Codec<?> codec : Codecs.LIST) {
            if (!codec.canEncode(value.getClass())) continue;
            this.parameters.put(index, new Parameter<Object>(codec, value));
            return this;
        }
        throw new IllegalArgumentException(String.format("No encoder for class %s (parameter at index %s) ", value.getClass().getName(), index));
    }

    @Override
    public MariadbServerParameterizedQueryStatement bindNull(@Nullable String identifier, @Nullable Class<?> type) {
        Assert.requireNonNull(identifier, "identifier cannot be null");
        return this.bindNull(this.getColumn(identifier), (Class)type);
    }

    @Override
    public MariadbServerParameterizedQueryStatement bindNull(int index, @Nullable Class<?> type) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.format("wrong index value %d, index must be positive", index));
        }
        if (this.prepareResult != null && index >= this.prepareResult.getNumParams()) {
            throw new IndexOutOfBoundsException(String.format("index must be in 0-%d range but value is %d", this.prepareResult.getNumParams() - 1, index));
        }
        Parameter parameter = null;
        if (type != null) {
            for (Codec<?> codec : Codecs.LIST) {
                if (!codec.canEncode(type)) continue;
                parameter = new Parameter(codec, null){

                    @Override
                    public DataType getBinaryEncodeType() {
                        return DataType.VARCHAR;
                    }

                    @Override
                    public boolean isNull() {
                        return true;
                    }
                };
                break;
            }
        }
        if (parameter == null) {
            parameter = Parameter.NULL_PARAMETER;
        }
        this.parameters.put(index, parameter);
        return this;
    }

    private int getColumn(String name) {
        throw new IllegalArgumentException("Cannot use getColumn(name) with prepared statement");
    }

    private void validateParameters() {
        if (this.prepareResult != null) {
            for (int i = 0; i < this.prepareResult.getNumParams(); ++i) {
                if (this.parameters.get(i) != null) continue;
                this.prepareResult.close(this.client);
                throw new IllegalArgumentException(String.format("Parameter at position %s is not set", i));
            }
        }
    }

    @Override
    public Flux<org.mariadb.r2dbc.api.MariadbResult> execute() {
        String sql = this.initialSql;
        if (this.client.getVersion().supportReturning() && this.generatedColumns != null) {
            sql = sql + (this.generatedColumns.length == 0 ? " RETURNING *" : " RETURNING " + String.join((CharSequence)", ", this.generatedColumns));
            this.prepareResult = null;
            this.prepareResult = (ServerPrepareResult)this.client.getPrepareCache().get(sql);
        }
        if (this.batchingParameters == null) {
            this.validateParameters();
            return this.execute(sql, this.parameters, this.generatedColumns);
        }
        if (this.prepareResult == null) {
            this.prepareResult = (ServerPrepareResult)this.client.getPrepareCache().get(sql);
            if (this.prepareResult == null) {
                this.sendPrepare(sql).block();
            }
        }
        Flux fluxMsg = this.client.sendCommand(new ExecutePacket(this.prepareResult.getStatementId(), this.batchingParameters.get(0)));
        int index = 1;
        while (index < this.batchingParameters.size()) {
            fluxMsg = fluxMsg.concatWith(this.client.sendCommand(new ExecutePacket(this.prepareResult.getStatementId(), this.batchingParameters.get(index++))));
        }
        fluxMsg = fluxMsg.concatWith((Publisher)Flux.create(sink -> {
            this.prepareResult.decrementUse(this.client);
            sink.complete();
        }));
        this.batchingParameters.clear();
        this.parameters = new HashMap();
        return fluxMsg.windowUntil(it -> it.resultSetEnd()).map(dataRow -> new MariadbResult(false, (Flux<ServerMessage>)dataRow, ExceptionFactory.INSTANCE, null, this.client.getVersion().supportReturning()));
    }

    @Override
    public MariadbServerParameterizedQueryStatement fetchSize(int rows) {
        return this;
    }

    @Override
    public MariadbServerParameterizedQueryStatement returnGeneratedValues(String ... columns) {
        Assert.requireNonNull(columns, "columns must not be null");
        if (!this.client.getVersion().supportReturning() && columns.length > 1) {
            throw new IllegalArgumentException("returnGeneratedValues can have only one column before MariaDB 10.5.1");
        }
        this.generatedColumns = columns;
        return this;
    }

    private Flux<org.mariadb.r2dbc.api.MariadbResult> execute(String sql, Map<Integer, Parameter<?>> parameters, String[] generatedColumns) {
        ExceptionFactory factory = ExceptionFactory.withSql(sql);
        if (this.prepareResult == null && this.client.getPrepareCache() != null) {
            this.prepareResult = (ServerPrepareResult)this.client.getPrepareCache().get(sql);
        }
        if (this.prepareResult != null) {
            ServerPrepareResult res;
            this.validateParameters();
            if (this.client.getPrepareCache() != null && (res = (ServerPrepareResult)this.client.getPrepareCache().get(sql)) != null && !res.equals(this.prepareResult)) {
                this.prepareResult.decrementUse(this.client);
                this.prepareResult = res;
            } else if (!this.prepareResult.incrementUse()) {
                this.prepareResult = null;
            }
            if (this.prepareResult != null) {
                return this.sendExecuteCmd(factory, parameters, generatedColumns).concatWith((Publisher)Flux.create(sink -> {
                    this.prepareResult.decrementUse(this.client);
                    sink.complete();
                    parameters.clear();
                }));
            }
        }
        Flux<org.mariadb.r2dbc.api.MariadbResult> flux = this.configuration.allowPipelining() && this.client.getVersion().isMariaDBServer() && this.client.getVersion().versionGreaterOrEqual(10, 2, 0) ? this.sendPrepareAndExecute(sql, factory, parameters, generatedColumns) : this.sendPrepare(sql).flatMapMany(prepareResult1 -> {
            this.prepareResult = prepareResult1;
            return this.sendExecuteCmd(factory, parameters, generatedColumns);
        });
        return flux.concatWith((Publisher)Flux.create(sink -> {
            this.prepareResult = (ServerPrepareResult)this.client.getPrepareCache().get(sql);
            if (this.prepareResult != null) {
                this.prepareResult.decrementUse(this.client);
            }
            sink.complete();
            parameters.clear();
        }));
    }

    private Flux<org.mariadb.r2dbc.api.MariadbResult> sendPrepareAndExecute(String sql, ExceptionFactory factory, Map<Integer, Parameter<?>> parameters, String[] generatedColumns) {
        return this.client.sendCommand(new PreparePacket(sql), new ExecutePacket(-1, parameters)).windowUntil(it -> it.resultSetEnd()).map(dataRow -> new MariadbResult(false, (Flux<ServerMessage>)dataRow, factory, generatedColumns, this.client.getVersion().supportReturning()));
    }

    private Mono<ServerPrepareResult> sendPrepare(String sql) {
        Flux f = this.client.sendCommand(new PreparePacket(sql), DecoderState.PREPARE_RESPONSE, sql).handle((it, sink) -> {
            if (it instanceof PrepareResultPacket) {
                PrepareResultPacket packet = (PrepareResultPacket)it;
                this.prepareResult = new ServerPrepareResult(packet.getStatementId(), packet.getNumColumns(), packet.getNumParams());
                sink.next((Object)this.prepareResult);
            }
            if (it.ending()) {
                sink.complete();
            }
        });
        return f.singleOrEmpty();
    }

    private Flux<org.mariadb.r2dbc.api.MariadbResult> sendExecuteCmd(ExceptionFactory factory, Map<Integer, Parameter<?>> parameters, String[] generatedColumns) {
        return this.client.sendCommand(new ExecutePacket(this.prepareResult != null ? this.prepareResult.getStatementId() : -1, parameters)).windowUntil(it -> it.resultSetEnd()).map(dataRow -> new MariadbResult(false, (Flux<ServerMessage>)dataRow, factory, generatedColumns, this.client.getVersion().supportReturning()));
    }

    public String toString() {
        return "MariadbServerParameterizedQueryStatement{client=" + this.client + ", sql='" + this.initialSql + '\'' + ", configuration=" + this.configuration + ", parameters=" + this.parameters + ", batchingParameters=" + this.batchingParameters + ", generatedColumns=" + (this.generatedColumns != null ? Arrays.toString(this.generatedColumns) : null) + ", prepareResult=" + this.prepareResult + '}';
    }
}

