/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.message.client.ClientMessage;
import org.mariadb.r2dbc.message.server.Sequencer;

public final class NativePasswordPacket
implements ClientMessage {
    private Sequencer sequencer;
    private CharSequence password;
    private byte[] seed;

    public NativePasswordPacket(Sequencer sequencer, CharSequence password, byte[] seed) {
        this.sequencer = sequencer;
        this.password = password;
        this.seed = seed;
    }

    public static byte[] encrypt(CharSequence authenticationData, byte[] seed) {
        if (authenticationData == null || authenticationData.toString().isEmpty()) {
            return new byte[0];
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] bytePwd = authenticationData.toString().getBytes(StandardCharsets.UTF_8);
            byte[] stage1 = messageDigest.digest(bytePwd);
            messageDigest.reset();
            byte[] stage2 = messageDigest.digest(stage1);
            messageDigest.reset();
            messageDigest.update(seed);
            messageDigest.update(stage2);
            byte[] digest = messageDigest.digest();
            byte[] returnBytes = new byte[digest.length];
            for (int i = 0; i < digest.length; ++i) {
                returnBytes[i] = (byte)(stage1[i] ^ digest[i]);
            }
            return returnBytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not use SHA-1, failing", e);
        }
    }

    @Override
    public ByteBuf encode(Context context, ByteBufAllocator allocator) {
        if (this.password == null) {
            return allocator.ioBuffer(0);
        }
        ByteBuf buf = allocator.ioBuffer(32);
        buf.writeBytes(NativePasswordPacket.encrypt(this.password, this.seed));
        return buf;
    }

    @Override
    public Sequencer getSequencer() {
        return this.sequencer;
    }
}

