/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.flow;

import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.authentication.AuthenticationPlugin;
import org.mariadb.r2dbc.message.client.ClearPasswordPacket;
import org.mariadb.r2dbc.message.client.ClientMessage;
import org.mariadb.r2dbc.message.server.AuthMoreDataPacket;
import org.mariadb.r2dbc.message.server.AuthSwitchPacket;

public final class PamPluginFlow
implements AuthenticationPlugin {
    public static final String TYPE = "dialog";
    private int counter = -1;

    @Override
    public PamPluginFlow create() {
        return new PamPluginFlow();
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public ClientMessage next(MariadbConnectionConfiguration configuration, AuthSwitchPacket authSwitchPacket, AuthMoreDataPacket authMoreDataPacket) {
        ++this.counter;
        if (this.counter == 0) {
            return new ClearPasswordPacket(authSwitchPacket.getSequencer(), configuration.getPassword());
        }
        if (configuration.getPamOtherPwd() == null) {
            throw new IllegalArgumentException("PAM authentication is set with multiple password, but pamOtherPwd option wasn't set");
        }
        if (configuration.getPamOtherPwd().length < this.counter) {
            throw new IllegalArgumentException(String.format("PAM authentication required at least %s passwords, but pamOtherPwd has only %s", this.counter, configuration.getPamOtherPwd().length));
        }
        return new ClearPasswordPacket(authSwitchPacket.getSequencer(), configuration.getPamOtherPwd()[this.counter - 1]);
    }
}

