/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.server;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.message.server.ServerMessage;
import org.mariadb.r2dbc.util.Assert;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class ErrorPacket
implements ServerMessage {
    private static final Logger logger = Loggers.getLogger(ErrorPacket.class);
    private final short errorCode;
    private final String message;
    private final String sqlState;
    private Sequencer sequencer;

    private ErrorPacket(Sequencer sequencer, short errorCode, String sqlState, String message) {
        this.sequencer = sequencer;
        this.errorCode = errorCode;
        this.message = message;
        this.sqlState = sqlState;
    }

    public static ErrorPacket decode(Sequencer sequencer, ByteBuf buf) {
        String msg;
        String sqlState;
        Assert.requireNonNull(buf, "buffer must not be null");
        buf.skipBytes(1);
        short errorCode = buf.readShortLE();
        byte next = buf.getByte(buf.readerIndex());
        if (next == 35) {
            buf.skipBytes(1);
            sqlState = buf.readCharSequence(5, StandardCharsets.UTF_8).toString();
            msg = buf.readCharSequence(buf.readableBytes(), StandardCharsets.UTF_8).toString();
        } else {
            msg = buf.readCharSequence(buf.readableBytes(), StandardCharsets.UTF_8).toString();
            sqlState = "HY000";
        }
        ErrorPacket err = new ErrorPacket(sequencer, errorCode, sqlState, msg);
        logger.warn("Error: '{}' sqlState='{}' code={} ", new Object[]{msg, sqlState, errorCode});
        return err;
    }

    public short getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    @Override
    public boolean ending() {
        return true;
    }
}

