/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.server;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.message.server.ServerMessage;

public final class InitialHandshakePacket
implements ServerMessage {
    private static final String MARIADB_RPL_HACK_PREFIX = "5.5.5-";
    private Sequencer sequencer;
    private String serverVersion;
    private long threadId;
    private byte[] seed;
    private long capabilities;
    private short defaultCollation;
    private short serverStatus;
    private boolean mariaDBServer;
    private String authenticationPluginType;
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;

    private InitialHandshakePacket(Sequencer sequencer, String serverVersion, long threadId, byte[] seed, long capabilities, short defaultCollation, short serverStatus, boolean mariaDBServer, String authenticationPluginType) {
        this.sequencer = sequencer;
        this.serverVersion = serverVersion;
        this.threadId = threadId;
        this.seed = seed;
        this.capabilities = capabilities;
        this.defaultCollation = defaultCollation;
        this.serverStatus = serverStatus;
        this.mariaDBServer = mariaDBServer;
        this.authenticationPluginType = authenticationPluginType;
        this.parseVersion(serverVersion);
    }

    public static InitialHandshakePacket decode(Sequencer sequencer, ByteBuf buffer) {
        long serverCapabilities;
        boolean serverMariaDb;
        byte[] seed;
        byte protocolVersion = buffer.readByte();
        if (protocolVersion != 10) {
            throw new IllegalArgumentException(String.format("Unexpected initial handshake protocol value [%s]", protocolVersion));
        }
        int nullLength = buffer.bytesBefore((byte)0);
        String serverVersion = buffer.toString(buffer.readerIndex(), nullLength, StandardCharsets.US_ASCII);
        buffer.skipBytes(nullLength + 1);
        long threadId = buffer.readIntLE();
        byte[] seed1 = new byte[8];
        buffer.readBytes(seed1);
        buffer.skipBytes(1);
        int serverCapabilities2FirstBytes = buffer.readShortLE() & 0xFFFF;
        short defaultCollation = buffer.readUnsignedByte();
        short serverStatus = buffer.readShortLE();
        int serverCapabilities4FirstBytes = serverCapabilities2FirstBytes + (buffer.readShortLE() << 16);
        int saltLength = 0;
        if ((serverCapabilities4FirstBytes & 0x80000) != 0) {
            saltLength = Math.max(12, buffer.readByte() - 9);
        } else {
            buffer.skipBytes(1);
        }
        buffer.skipBytes(6);
        long mariaDbAdditionalCapacities = buffer.readIntLE();
        if ((serverCapabilities4FirstBytes & 0x8000) != 0) {
            byte[] seed2;
            if (saltLength > 0) {
                seed2 = new byte[saltLength];
                buffer.readBytes(seed2);
            } else {
                seed2 = new byte[buffer.bytesBefore((byte)0)];
                buffer.readBytes(seed2);
                buffer.skipBytes(1);
            }
            seed = new byte[seed1.length + seed2.length];
            System.arraycopy(seed1, 0, seed, 0, seed1.length);
            System.arraycopy(seed2, 0, seed, seed1.length, seed2.length);
        } else {
            seed = seed1;
        }
        buffer.skipBytes(1);
        if (serverVersion.startsWith(MARIADB_RPL_HACK_PREFIX)) {
            serverMariaDb = true;
            serverVersion = serverVersion.substring(MARIADB_RPL_HACK_PREFIX.length());
        } else {
            serverMariaDb = serverVersion.contains("MariaDB");
        }
        if ((serverCapabilities4FirstBytes & 1) == 0) {
            serverCapabilities = ((long)serverCapabilities4FirstBytes & 0xFFFFFFFFL) + (mariaDbAdditionalCapacities << 32);
            serverMariaDb = true;
        } else {
            serverCapabilities = (long)serverCapabilities4FirstBytes & 0xFFFFFFFFL;
        }
        String authenticationPluginType = null;
        if ((serverCapabilities4FirstBytes & 0x80000) != 0) {
            int nullStLength = buffer.bytesBefore((byte)0);
            authenticationPluginType = buffer.toString(buffer.readerIndex(), nullStLength, StandardCharsets.US_ASCII);
            buffer.skipBytes(nullStLength + 1);
        }
        return new InitialHandshakePacket(sequencer, serverVersion, threadId, seed, serverCapabilities, defaultCollation, serverStatus, serverMariaDb, authenticationPluginType);
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public long getCapabilities() {
        return this.capabilities;
    }

    public short getDefaultCollation() {
        return this.defaultCollation;
    }

    public short getServerStatus() {
        return this.serverStatus;
    }

    public boolean isMariaDBServer() {
        return this.mariaDBServer;
    }

    public String getAuthenticationPluginType() {
        return this.authenticationPluginType;
    }

    @Override
    public Sequencer getSequencer() {
        return this.sequencer;
    }

    private void parseVersion(String serverVersion) {
        int length = serverVersion.length();
        int type = 0;
        int val = 0;
        for (int offset = 0; offset < length; ++offset) {
            char car = serverVersion.charAt(offset);
            if (car < '0' || car > '9') {
                switch (type) {
                    case 0: {
                        this.majorVersion = val;
                        break;
                    }
                    case 1: {
                        this.minorVersion = val;
                        break;
                    }
                    case 2: {
                        this.patchVersion = val;
                        return;
                    }
                }
                ++type;
                val = 0;
                continue;
            }
            val = val * 10 + car - 48;
        }
        if (type == 2) {
            this.patchVersion = val;
        }
    }

    public int getMajorServerVersion() {
        return this.majorVersion;
    }

    public int getMinorServerVersion() {
        return this.minorVersion;
    }

    @Override
    public boolean ending() {
        return true;
    }
}

