/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.netty.buffer.ByteBuf;
import org.mariadb.r2dbc.client.CmdElement;
import org.mariadb.r2dbc.client.DecoderStateInterface;
import org.mariadb.r2dbc.client.MariadbPacketDecoder;
import org.mariadb.r2dbc.message.server.AuthMoreDataPacket;
import org.mariadb.r2dbc.message.server.AuthSwitchPacket;
import org.mariadb.r2dbc.message.server.ColumnCountPacket;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.message.server.EofPacket;
import org.mariadb.r2dbc.message.server.ErrorPacket;
import org.mariadb.r2dbc.message.server.InitialHandshakePacket;
import org.mariadb.r2dbc.message.server.OkPacket;
import org.mariadb.r2dbc.message.server.PrepareResultPacket;
import org.mariadb.r2dbc.message.server.RowPacket;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.message.server.ServerMessage;
import org.mariadb.r2dbc.message.server.SkipPacket;
import org.mariadb.r2dbc.util.PrepareCache;
import org.mariadb.r2dbc.util.ServerPrepareResult;

public enum DecoderState implements DecoderStateInterface
{
    INIT_HANDSHAKE{

        @Override
        public DecoderState decoder(short val, int len, long serverCapabilities) {
            return this;
        }

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return InitialHandshakePacket.decode(sequencer, body);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return FAST_AUTH_RESPONSE;
        }
    }
    ,
    FAST_AUTH_RESPONSE{

        @Override
        public DecoderState decoder(short val, int len, long serverCapabilities) {
            switch (val) {
                case 0: {
                    return OK_PACKET;
                }
                case 254: {
                    return AUTHENTICATION_SWITCH;
                }
                case 255: {
                    return ERROR;
                }
            }
            throw new IllegalArgumentException(String.format("Error in protocol: %s is not a supported", val));
        }
    }
    ,
    OK_PACKET{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return OkPacket.decode(sequencer, body, decoder.getContext());
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return QUERY_RESPONSE;
        }
    }
    ,
    AUTHENTICATION_SWITCH{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return AuthSwitchPacket.decode(sequencer, body, decoder.getContext());
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return AUTHENTICATION_SWITCH_RESPONSE;
        }
    }
    ,
    AUTHENTICATION_SWITCH_RESPONSE{

        @Override
        public DecoderState decoder(short val, int len, long serverCapabilities) {
            switch (val) {
                case 0: {
                    return OK_PACKET;
                }
                case 1: {
                    return AUTHENTICATION_MORE_DATA;
                }
                case 254: {
                    return AUTHENTICATION_SWITCH;
                }
                case 255: {
                    return ERROR;
                }
            }
            throw new IllegalArgumentException(String.format("Error in protocol: %s is not a supported", val));
        }
    }
    ,
    AUTHENTICATION_MORE_DATA{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return AuthMoreDataPacket.decode(sequencer, body, decoder.getContext());
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return AUTHENTICATION_SWITCH_RESPONSE;
        }
    }
    ,
    QUERY_RESPONSE{

        @Override
        public DecoderState decoder(short val, int len, long serverCapabilities) {
            switch (val) {
                case 0: {
                    return OK_PACKET;
                }
                case 255: {
                    return ERROR;
                }
            }
            return COLUMN_COUNT;
        }
    }
    ,
    COLUMN_COUNT{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            ColumnCountPacket columnCountPacket = ColumnCountPacket.decode(sequencer, body, decoder.getContext());
            decoder.setStateCounter(columnCountPacket.getColumnCount());
            return columnCountPacket;
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return COLUMN_DEFINITION;
        }
    }
    ,
    COLUMN_DEFINITION{

        @Override
        public DecoderState decoder(short val, int len, long serverCapabilities) {
            return this;
        }

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            decoder.decrementStateCounter();
            return ColumnDefinitionPacket.decode(sequencer, body, decoder.getContext(), false);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            if (decoder.getStateCounter() <= 0) {
                if ((decoder.getServerCapabilities() & 0x1000000L) > 0L) {
                    return ROW_RESPONSE;
                }
                return EOF_INTERMEDIATE_RESPONSE;
            }
            return this;
        }
    }
    ,
    EOF_INTERMEDIATE_RESPONSE{

        @Override
        public DecoderState decoder(short val, int len, long serverCapabilities) {
            return this;
        }

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return EofPacket.decode(sequencer, body, decoder.getContext(), false);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return ROW_RESPONSE;
        }
    }
    ,
    EOF_END{

        @Override
        public DecoderState decoder(short val, int len, long serverCapabilities) {
            return this;
        }

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return EofPacket.decode(sequencer, body, decoder.getContext(), true);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return QUERY_RESPONSE;
        }
    }
    ,
    ROW_RESPONSE{

        @Override
        public DecoderState decoder(short val, int len, long serverCapabilities) {
            switch (val) {
                case 254: {
                    if ((serverCapabilities & 0x1000000L) == 0L && len < 0xFFFFFF) {
                        return EOF_END;
                    }
                    if (len < 0xFFFFFF) {
                        return OK_PACKET;
                    }
                    return ROW;
                }
                case 255: {
                    return ERROR;
                }
            }
            return ROW;
        }
    }
    ,
    ROW{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return new RowPacket(body);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return ROW_RESPONSE;
        }
    }
    ,
    PREPARE_RESPONSE{
        PrepareResultPacket packet;

        @Override
        public DecoderState decoder(short val, int len, long serverCapabilities) {
            switch (val) {
                case 255: {
                    return ERROR;
                }
            }
            return this;
        }

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            this.packet = PrepareResultPacket.decode(sequencer, body, decoder.getContext());
            ServerPrepareResult prepareResult = new ServerPrepareResult(this.packet.getStatementId(), this.packet.getNumColumns(), this.packet.getNumParams());
            PrepareCache prepareCache = decoder.getClient().getPrepareCache();
            if (prepareCache != null && prepareCache.put(element.getSql(), prepareResult) != null) {
                prepareResult.decrementUse(decoder.getClient());
            }
            return this.packet;
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            if ((decoder.getServerCapabilities() & 0x1000000L) > 0L) {
                decoder.setStateCounter(this.packet.getNumParams() + this.packet.getNumColumns());
            } else {
                decoder.setStateCounter((this.packet.getNumParams() > 0 ? this.packet.getNumParams() + 1 : 0) + (this.packet.getNumColumns() > 0 ? this.packet.getNumColumns() + 1 : 0));
            }
            if (decoder.getStateCounter() > 0) {
                return SKIP;
            }
            throw new IllegalArgumentException("unexpected state");
        }
    }
    ,
    PREPARE_AND_EXECUTE_RESPONSE{
        PrepareResultPacket packet;

        @Override
        public DecoderState decoder(short val, int len, long serverCapabilities) {
            switch (val) {
                case 255: {
                    return ERROR_AND_EXECUTE_RESPONSE;
                }
            }
            return this;
        }

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            this.packet = PrepareResultPacket.decode(sequencer, body, decoder.getContext());
            ServerPrepareResult prepareResult = new ServerPrepareResult(this.packet.getStatementId(), this.packet.getNumColumns(), this.packet.getNumParams());
            PrepareCache prepareCache = decoder.getClient().getPrepareCache();
            if (prepareCache != null && prepareCache.put(element.getSql(), prepareResult) != null) {
                prepareResult.decrementUse(decoder.getClient());
            }
            return this.packet;
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            if ((decoder.getServerCapabilities() & 0x1000000L) > 0L) {
                decoder.setStateCounter(this.packet.getNumParams() + this.packet.getNumColumns());
            } else {
                decoder.setStateCounter((this.packet.getNumParams() > 0 ? this.packet.getNumParams() + 1 : 0) + (this.packet.getNumColumns() > 0 ? this.packet.getNumColumns() + 1 : 0));
            }
            if (decoder.getStateCounter() > 0) {
                return SKIP_EXECUTE;
            }
            return QUERY_RESPONSE;
        }
    }
    ,
    SKIP{

        @Override
        public DecoderState decoder(short val, int len, long serverCapabilities) {
            return this;
        }

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            decoder.decrementStateCounter();
            return SkipPacket.decode(decoder.getStateCounter() == 0);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return SKIP;
        }
    }
    ,
    SKIP_EXECUTE{

        @Override
        public DecoderState decoder(short val, int len, long serverCapabilities) {
            return this;
        }

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            decoder.decrementStateCounter();
            return SkipPacket.decode(false);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            if (decoder.getStateCounter() <= 0) {
                return QUERY_RESPONSE;
            }
            return SKIP_EXECUTE;
        }
    }
    ,
    ERROR{

        @Override
        public DecoderState decoder(short val, int len, long serverCapabilities) {
            return this;
        }

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return ErrorPacket.decode(sequencer, body);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            throw new IllegalArgumentException("unexpected state");
        }
    }
    ,
    ERROR_AND_EXECUTE_RESPONSE{

        @Override
        public DecoderState decoder(short val, int len, long serverCapabilities) {
            return this;
        }

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return ErrorPacket.decode(sequencer, body);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return SKIP_EXECUTE;
        }
    };

}

