/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.Clob;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.BufferUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ClobCodec
implements Codec<Clob> {
    public static final ClobCodec INSTANCE = new ClobCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.VARCHAR, DataType.VARSTRING, DataType.STRING);

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(Clob.class);
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return Clob.class.isAssignableFrom(value);
    }

    @Override
    public Clob decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Clob> type) {
        String rawValue = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
        return Clob.from((Publisher)Mono.just((Object)rawValue));
    }

    @Override
    public Clob decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Clob> type) {
        String rawValue = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
        return Clob.from((Publisher)Mono.just((Object)rawValue));
    }

    @Override
    public void encodeText(ByteBuf buf, Context context, Clob value) {
        buf.writeByte(39);
        Flux.from((Publisher)value.stream()).handle((tempVal, sync) -> {
            BufferUtils.write(buf, tempVal.toString(), false, context);
            sync.next((Object)buf);
        }).subscribe();
        buf.writeByte(39);
    }

    @Override
    public void encodeBinary(ByteBuf buf, Context context, Clob value) {
        buf.writeByte(254);
        int initialPos = buf.writerIndex();
        buf.writerIndex(buf.writerIndex() + 8);
        Flux.from((Publisher)value.stream()).handle((tempVal, sync) -> {
            buf.writeCharSequence(tempVal, StandardCharsets.UTF_8);
            sync.next((Object)buf);
        }).doOnComplete(() -> {
            int endPos = buf.writerIndex();
            buf.writerIndex(initialPos);
            buf.writeLongLE((long)(endPos - (initialPos + 8)));
            buf.writerIndex(endPos);
        }).subscribe();
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.VARSTRING;
    }
}

