/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.message.client.ClientMessage;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.Assert;

public final class QueryPacket
implements ClientMessage {
    private final String sql;
    private final Sequencer sequencer = new Sequencer(-1);

    public QueryPacket(String sql) {
        this.sql = Assert.requireNonNull(sql, "query must not be null");
    }

    @Override
    public ByteBuf encode(Context context, ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        ByteBuf out = byteBufAllocator.ioBuffer(this.sql.length() + 1);
        out.writeByte(3);
        out.writeCharSequence((CharSequence)this.sql, StandardCharsets.UTF_8);
        return out;
    }

    @Override
    public Sequencer getSequencer() {
        return this.sequencer;
    }
}

