/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.server;

import io.netty.buffer.ByteBuf;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.message.server.ServerMessage;

public final class PrepareResultPacket
implements ServerMessage {
    private final int statementId;
    private final int numColumns;
    private final int numParams;
    private final boolean eofDeprecated;
    private Sequencer sequencer;

    private PrepareResultPacket(Sequencer sequencer, int statementId, int numColumns, int numParams, boolean eofDeprecated) {
        this.sequencer = sequencer;
        this.statementId = statementId;
        this.numColumns = numColumns;
        this.numParams = numParams;
        this.eofDeprecated = eofDeprecated;
    }

    @Override
    public boolean ending() {
        return this.numParams == 0 && this.numColumns == 0 && this.eofDeprecated;
    }

    public static PrepareResultPacket decode(Sequencer sequencer, ByteBuf buffer, Context context) {
        buffer.readByte();
        int statementId = buffer.readIntLE();
        int numColumns = buffer.readUnsignedShortLE();
        int numParams = buffer.readUnsignedShortLE();
        return new PrepareResultPacket(sequencer, statementId, numColumns, numParams, (context.getServerCapabilities() & 0x1000000L) > 0L);
    }

    public int getStatementId() {
        return this.statementId;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int getNumParams() {
        return this.numParams;
    }

    public boolean isEofDeprecated() {
        return this.eofDeprecated;
    }
}

