/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.util;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcTransientResourceException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.mariadb.r2dbc.SslMode;
import org.mariadb.r2dbc.util.DefaultHostnameVerifier;

public class SslConfig {
    public static final SslConfig DISABLE_INSTANCE = new SslConfig(SslMode.DISABLED);
    private SslMode sslMode;
    private String serverSslCert;
    private String clientSslCert;
    private String clientSslKey;
    private CharSequence clientSslPassword;
    private List<String> tlsProtocol;
    private SslContextBuilder sslContextBuilder;

    public SslConfig(SslMode sslMode, String serverSslCert, String clientSslCert, String clientSslKey, CharSequence clientSslPassword, List<String> tlsProtocol) throws R2dbcTransientResourceException {
        this.sslMode = sslMode;
        this.serverSslCert = serverSslCert;
        this.clientSslCert = clientSslCert;
        this.tlsProtocol = tlsProtocol;
        this.clientSslCert = clientSslCert;
        this.clientSslKey = clientSslKey;
        this.clientSslPassword = clientSslPassword;
        if (sslMode != SslMode.DISABLED) {
            this.sslContextBuilder = this.getSslContextBuilder();
        }
    }

    public SslConfig(SslMode sslMode) {
        this.sslMode = sslMode;
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    private SslContextBuilder getSslContextBuilder() throws R2dbcTransientResourceException {
        SslContextBuilder sslCtxBuilder = SslContextBuilder.forClient();
        if (this.sslMode == SslMode.ENABLE_TRUST) {
            sslCtxBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        } else {
            if (this.serverSslCert != null) {
                try {
                    InputStream inStream = this.loadCert(this.serverSslCert);
                    sslCtxBuilder.trustManager(inStream);
                }
                catch (FileNotFoundException fileNotFoundEx) {
                    throw new R2dbcTransientResourceException("Failed to find serverSslCert file. serverSslCert=" + this.serverSslCert, "08000", (Throwable)fileNotFoundEx);
                }
            } else {
                throw new R2dbcTransientResourceException("Server certificate needed (option `serverSslCert`) for ssl mode " + (Object)((Object)this.sslMode), "08000");
            }
            if (this.clientSslCert != null && this.clientSslKey != null) {
                InputStream certificatesStream;
                try {
                    certificatesStream = this.loadCert(this.clientSslCert);
                }
                catch (FileNotFoundException fileNotFoundEx) {
                    throw new R2dbcTransientResourceException("Failed to find clientSslCert file. clientSslCert=" + this.clientSslCert, "08000", (Throwable)fileNotFoundEx);
                }
                try {
                    FileInputStream privateKeyStream = new FileInputStream(this.clientSslKey);
                    sslCtxBuilder.keyManager(certificatesStream, (InputStream)privateKeyStream, this.clientSslPassword == null ? null : this.clientSslPassword.toString());
                }
                catch (FileNotFoundException fileNotFoundEx) {
                    throw new R2dbcTransientResourceException("Failed to find clientSslKey file. clientSslKey=" + this.clientSslKey, "08000", (Throwable)fileNotFoundEx);
                }
            }
        }
        if (this.tlsProtocol != null) {
            sslCtxBuilder.protocols(this.tlsProtocol.toArray(new String[this.tlsProtocol.size()]));
        }
        return sslCtxBuilder;
    }

    public SslContext getSslContext() throws R2dbcTransientResourceException, SSLException {
        return this.sslContextBuilder.build();
    }

    private InputStream loadCert(String path) throws FileNotFoundException {
        InputStream inStream = null;
        if (path.startsWith("-----BEGIN CERTIFICATE-----")) {
            inStream = new ByteArrayInputStream(path.getBytes());
        } else if (path.startsWith("classpath:")) {
            String classpathFile = path.substring("classpath:".length());
            inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathFile);
        } else {
            inStream = new FileInputStream(path);
        }
        return inStream;
    }

    public GenericFutureListener<Future<? super Channel>> getHostNameVerifier(CompletableFuture<Void> result, String host, long threadId, SSLEngine engine) {
        return future -> {
            if (!future.isSuccess()) {
                result.completeExceptionally(future.cause());
                return;
            }
            if (this.sslMode == SslMode.ENABLE) {
                try {
                    DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
                    SSLSession session = engine.getSession();
                    if (!hostnameVerifier.verify(host, session, threadId)) {
                        Certificate[] certs = session.getPeerCertificates();
                        X509Certificate cert = (X509Certificate)certs[0];
                        hostnameVerifier.verify(host, cert, threadId);
                    }
                }
                catch (SSLException ex) {
                    result.completeExceptionally((Throwable)new R2dbcNonTransientResourceException("SSL hostname verification failed : " + ex.getMessage(), "08006"));
                    return;
                }
            }
            result.complete(null);
        };
    }

    public String toString() {
        return "SslConfig{sslMode=" + (Object)((Object)this.sslMode) + ", serverSslCert='" + this.serverSslCert + '\'' + ", clientSslCert='" + this.clientSslCert + '\'' + ", tlsProtocol=" + this.tlsProtocol + '}';
    }
}

