/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.Row;
import java.util.Collections;
import java.util.TreeSet;
import org.mariadb.r2dbc.codec.RowDecoder;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.Assert;
import reactor.util.annotation.Nullable;

public class MariadbRow
implements Row {
    private final ColumnDefinitionPacket[] columnDefinitionPackets;
    private final RowDecoder decoder;
    private final ByteBuf raw;

    MariadbRow(ColumnDefinitionPacket[] columnDefinitionPackets, RowDecoder decoder, ByteBuf data) {
        this.columnDefinitionPackets = columnDefinitionPackets;
        this.decoder = decoder;
        this.raw = data;
        decoder.resetRow(this.raw);
    }

    @Nullable
    public <T> T get(int index, Class<T> type) {
        Assert.requireNonNull(type, "type must not be null");
        return this.decoder.get(index, this.getMeta(index), type);
    }

    @Nullable
    public <T> T get(String name, Class<T> type) {
        Assert.requireNonNull(name, "name must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return this.get(this.getColumn(name), type);
    }

    private int getColumn(String name) {
        Assert.requireNonNull(name, "name must not be null");
        for (int i = 0; i < this.columnDefinitionPackets.length; ++i) {
            if (!this.columnDefinitionPackets[i].getColumnAlias().equalsIgnoreCase(name)) continue;
            return i;
        }
        TreeSet<String> columnNames = new TreeSet<String>();
        for (ColumnDefinitionPacket columnDef : this.columnDefinitionPackets) {
            columnNames.add(columnDef.getColumnAlias());
        }
        throw new IllegalArgumentException(String.format("Column name '%s' does not exist in column names %s", name, Collections.unmodifiableCollection(columnNames)));
    }

    private ColumnDefinitionPacket getMeta(int index) {
        if (index < 0) {
            throw new IllegalArgumentException(String.format("Column index %d must be positive", index));
        }
        if (index >= this.columnDefinitionPackets.length) {
            throw new IllegalArgumentException(String.format("Column index %d not in range [0-%s]", index, this.columnDefinitionPackets.length - 1));
        }
        return this.columnDefinitionPackets[index];
    }
}

