/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mariadb.r2dbc.MariadbColumnMetadata;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.Assert;

final class MariadbRowMetadata
implements RowMetadata {
    private final List<MariadbColumnMetadata> metadataList;
    private volatile Collection<String> columnNames;

    MariadbRowMetadata(List<MariadbColumnMetadata> metadataList) {
        this.metadataList = metadataList;
    }

    static MariadbRowMetadata toRowMetadata(ColumnDefinitionPacket[] metadataList) {
        ArrayList<MariadbColumnMetadata> columnMetadata = new ArrayList<MariadbColumnMetadata>(metadataList.length);
        for (ColumnDefinitionPacket col : metadataList) {
            columnMetadata.add(new MariadbColumnMetadata(col));
        }
        return new MariadbRowMetadata(columnMetadata);
    }

    public MariadbColumnMetadata getColumnMetadata(int index) {
        if (index < 0 || index >= this.metadataList.size()) {
            throw new IllegalArgumentException(String.format("Column index %d is not in permit range[0,%s]", index, this.metadataList.size() - 1));
        }
        return this.metadataList.get(index);
    }

    public MariadbColumnMetadata getColumnMetadata(String name) {
        return this.metadataList.get(this.getColumn(name));
    }

    private int getColumn(String name) {
        Assert.requireNonNull(name, "name must not be null");
        for (int i = 0; i < this.metadataList.size(); ++i) {
            if (!this.metadataList.get(i).getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("Column name '%s' does not exist in column names %s", name, this.getColumnNames()));
    }

    public List<MariadbColumnMetadata> getColumnMetadatas() {
        return Collections.unmodifiableList(this.metadataList);
    }

    public Collection<String> getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = this.getColumnNames(this.metadataList);
        }
        return Collections.unmodifiableCollection(this.columnNames);
    }

    private Collection<String> getColumnNames(List<MariadbColumnMetadata> columnMetadatas) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (MariadbColumnMetadata columnMetadata : columnMetadatas) {
            columnNames.add(columnMetadata.getName());
        }
        return Collections.unmodifiableCollection(columnNames);
    }

    public String toString() {
        if (this.columnNames == null) {
            this.columnNames = this.getColumnNames(this.metadataList);
        }
        StringBuilder sb = new StringBuilder("MariadbRowMetadata{");
        sb.append("columnNames=").append(this.columnNames).append("}");
        return sb.toString();
    }
}

