/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.Cipher;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.message.client.ClientMessage;
import org.mariadb.r2dbc.message.server.Sequencer;

public final class Sha256PasswordPacket
implements ClientMessage {
    private Sequencer sequencer;
    private CharSequence password;
    private byte[] seed;
    private PublicKey publicKey;

    public Sha256PasswordPacket(Sequencer sequencer, CharSequence password, byte[] seed, PublicKey publicKey) {
        this.sequencer = sequencer;
        this.password = password;
        byte[] truncatedSeed = new byte[seed.length - 1];
        System.arraycopy(seed, 0, truncatedSeed, 0, seed.length - 1);
        this.seed = truncatedSeed;
        this.publicKey = publicKey;
    }

    public static byte[] encrypt(PublicKey publicKey, CharSequence password, byte[] seed) throws R2dbcException {
        byte[] bytePwd = password.toString().getBytes(StandardCharsets.UTF_8);
        byte[] nullFinishedPwd = Arrays.copyOf(bytePwd, bytePwd.length + 1);
        byte[] xorBytes = new byte[nullFinishedPwd.length];
        int seedLength = seed.length;
        for (int i = 0; i < xorBytes.length; ++i) {
            xorBytes[i] = (byte)(nullFinishedPwd[i] ^ seed[i % seedLength]);
        }
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, publicKey);
            return cipher.doFinal(xorBytes);
        }
        catch (Exception ex) {
            throw new R2dbcPermissionDeniedException("Could not connect using SHA256 plugin : " + ex.getMessage(), "S1009", (Throwable)ex);
        }
    }

    @Override
    public ByteBuf encode(Context context, ByteBufAllocator allocator) {
        if (this.password == null) {
            return allocator.ioBuffer(0);
        }
        ByteBuf buf = allocator.ioBuffer(256);
        buf.writeBytes(Sha256PasswordPacket.encrypt(this.publicKey, this.password, this.seed));
        return buf;
    }

    @Override
    public Sequencer getSequencer() {
        return this.sequencer;
    }
}

