/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.server;

import io.netty.buffer.ByteBuf;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.message.server.ServerMessage;

public class EofPacket
implements ServerMessage {
    private final Sequencer sequencer;
    private final short serverStatus;
    private final short warningCount;
    private final boolean ending;
    private final boolean resultSetEnd;

    public EofPacket(Sequencer sequencer, short serverStatus, short warningCount, boolean resultSetEnd, boolean ending) {
        this.sequencer = sequencer;
        this.serverStatus = serverStatus;
        this.warningCount = warningCount;
        this.resultSetEnd = resultSetEnd;
        this.ending = ending;
    }

    public static EofPacket decode(Sequencer sequencer, ByteBuf buf, Context context, boolean resultSetEnd) {
        buf.skipBytes(1);
        short warningCount = buf.readShortLE();
        short serverStatus = buf.readShortLE();
        context.setServerStatus(serverStatus);
        return new EofPacket(sequencer, serverStatus, warningCount, resultSetEnd, resultSetEnd && (serverStatus & 8) == 0);
    }

    public short getServerStatus() {
        return this.serverStatus;
    }

    public short getWarningCount() {
        return this.warningCount;
    }

    @Override
    public boolean ending() {
        return this.ending;
    }

    @Override
    public boolean resultSetEnd() {
        return this.resultSetEnd;
    }
}

