/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import io.netty.channel.unix.DomainSocketAddress;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.MariadbConnectionFactoryMetadata;
import org.mariadb.r2dbc.MariadbSimpleQueryStatement;
import org.mariadb.r2dbc.api.MariadbConnection;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.client.ClientImpl;
import org.mariadb.r2dbc.client.ClientPipelineImpl;
import org.mariadb.r2dbc.message.flow.AuthenticationFlow;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.HostAddress;
import reactor.core.publisher.Mono;
import reactor.netty.resources.ConnectionProvider;

public final class MariadbConnectionFactory
implements ConnectionFactory {
    private final MariadbConnectionConfiguration configuration;

    public MariadbConnectionFactory(MariadbConnectionConfiguration configuration) {
        this.configuration = Assert.requireNonNull(configuration, "configuration must not be null");
    }

    public static MariadbConnectionFactory from(MariadbConnectionConfiguration configuration) {
        return new MariadbConnectionFactory(configuration);
    }

    public Mono<MariadbConnection> create() {
        if (this.configuration.getSocket() != null) {
            return this.connectToHost((SocketAddress)new DomainSocketAddress(this.configuration.getSocket()), null).cast(MariadbConnection.class);
        }
        return this.doCreateConnection(0).cast(MariadbConnection.class);
    }

    private Mono<org.mariadb.r2dbc.MariadbConnection> doCreateConnection(int idx) {
        HostAddress hostAddress = this.configuration.getHostAddresses().get(idx);
        return this.connectToHost(InetSocketAddress.createUnresolved(hostAddress.getHost(), hostAddress.getPort()), hostAddress).onErrorResume(e -> {
            if (idx + 1 < this.configuration.getHostAddresses().size()) {
                return this.doCreateConnection(idx + 1);
            }
            return Mono.error((Throwable)e);
        });
    }

    private Mono<org.mariadb.r2dbc.MariadbConnection> connectToHost(SocketAddress endpoint, HostAddress hostAddress) {
        Mono<Client> clientMono = this.configuration.allowPipelining() ? ClientPipelineImpl.connect(ConnectionProvider.newConnection(), endpoint, hostAddress, this.configuration) : ClientImpl.connect(ConnectionProvider.newConnection(), endpoint, hostAddress, this.configuration);
        return clientMono.delayUntil(client -> AuthenticationFlow.exchange(client, this.configuration, hostAddress)).cast(Client.class).flatMap(client -> {
            Mono<Void> waiting = Mono.empty();
            if (this.configuration.getSessionVariables() != null && this.configuration.getSessionVariables().size() > 0 || client.isAutoCommit() != this.configuration.autocommit()) {
                waiting = this.setSessionVariables((Client)client);
            }
            if (this.configuration.getIsolationLevel() == null) {
                Mono isolationLevelMono = waiting.then(this.getIsolationLevel((Client)client));
                return isolationLevelMono.map(it -> new org.mariadb.r2dbc.MariadbConnection((Client)client, (IsolationLevel)it, this.configuration)).onErrorResume(throwable -> this.closeWithError((Client)client, (Throwable)throwable));
            }
            return waiting.then(Mono.just((Object)new org.mariadb.r2dbc.MariadbConnection((Client)client, this.configuration.getIsolationLevel(), this.configuration))).onErrorResume(throwable -> this.closeWithError((Client)client, (Throwable)throwable));
        }).onErrorMap(e -> this.cannotConnect((Throwable)e, endpoint));
    }

    private Mono<org.mariadb.r2dbc.MariadbConnection> closeWithError(Client client, Throwable throwable) {
        return client.close().then(Mono.error((Throwable)throwable));
    }

    private Throwable cannotConnect(Throwable throwable, SocketAddress endpoint) {
        if (throwable instanceof R2dbcException) {
            return throwable;
        }
        return new R2dbcNonTransientResourceException(String.format("Cannot connect to %s", endpoint), throwable);
    }

    public ConnectionFactoryMetadata getMetadata() {
        return MariadbConnectionFactoryMetadata.INSTANCE;
    }

    public String toString() {
        return "MariadbConnectionFactory{configuration=" + this.configuration + '}';
    }

    private Mono<Void> setSessionVariables(Client client) {
        StringBuilder sql = new StringBuilder("SET autocommit=" + (this.configuration.autocommit() ? "1" : "0"));
        if (this.configuration.getSessionVariables() != null && this.configuration.getSessionVariables().size() > 0) {
            Map<String, String> sessionVariable = this.configuration.getSessionVariables();
            Iterator<String> keys = sessionVariable.keySet().iterator();
            for (int i = 0; i < sessionVariable.size(); ++i) {
                String key = keys.next();
                String value = sessionVariable.get(key);
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Session variable '%s' has no value", key));
                }
                sql.append(",").append(key).append("=").append(value);
            }
        }
        return new MariadbSimpleQueryStatement(client, sql.toString()).execute().last().then();
    }

    private Mono<IsolationLevel> getIsolationLevel(Client client) {
        String sql = "SELECT @@tx_isolation";
        if (!client.getVersion().isMariaDBServer() && (client.getVersion().versionGreaterOrEqual(8, 0, 3) || client.getVersion().getMajorVersion() < 8 && client.getVersion().versionGreaterOrEqual(5, 7, 20))) {
            sql = "SELECT @@transaction_isolation";
        }
        return new MariadbSimpleQueryStatement(client, sql).execute().flatMap(it -> it.map((row, rowMetadata) -> {
            String level;
            switch (level = (String)row.get(0, String.class)) {
                case "REPEATABLE-READ": {
                    return IsolationLevel.REPEATABLE_READ;
                }
                case "READ-UNCOMMITTED": {
                    return IsolationLevel.READ_UNCOMMITTED;
                }
                case "SERIALIZABLE": {
                    return IsolationLevel.SERIALIZABLE;
                }
            }
            return IsolationLevel.READ_COMMITTED;
        })).defaultIfEmpty((Object)IsolationLevel.READ_COMMITTED).last();
    }
}

